/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v21.common.ComponentValueSetType;
import org.sdmx.resources.sdmxml.schemas.v21.common.DistinctKeyType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstrainedDataKeyBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstraintDataKeySetBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.mutable.registry.ConstrainedDataKeyMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyValueImpl;
import org.sdmxsource.util.ObjectUtil;

public class ConstrainedDataKeyBeanImpl
extends SdmxStructureBeanImpl
implements ConstrainedDataKeyBean {
    private static final long serialVersionUID = 4311899020748834418L;
    private List<KeyValue> keyValues = new ArrayList<KeyValue>();

    public ConstrainedDataKeyBeanImpl(ConstrainedDataKeyMutableBean mutable, ConstraintDataKeySetBean parent) {
        super(SDMX_STRUCTURE_TYPE.CONSTRAINED_DATA_KEY, (SdmxStructureBean)parent);
        for (KeyValue each : mutable.getKeyValues()) {
            this.keyValues.add(new KeyValueImpl(each.getCode(), each.getConcept()));
        }
        this.validate();
    }

    public ConstrainedDataKeyBeanImpl(DistinctKeyType dataKeyType, ConstraintDataKeySetBean parent) {
        super(SDMX_STRUCTURE_TYPE.CONSTRAINED_DATA_KEY, (SdmxStructureBean)parent);
        for (ComponentValueSetType componentValueSet : dataKeyType.getKeyValueList()) {
            String concept = componentValueSet.getId();
            if (componentValueSet.getValueList() == null || componentValueSet.getValueList().size() < 1 || componentValueSet.getValueList().size() > 1) {
                throw new ValidationException("KeyValue expected to contain a single value");
            }
            String value = componentValueSet.getValueList().get(0).getStringValue();
            this.keyValues.add(new KeyValueImpl(value, concept));
        }
        this.validate();
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            ConstrainedDataKeyBean that = (ConstrainedDataKeyBean)bean;
            return ObjectUtil.equivalentCollection(this.getKeyValues(), that.getKeyValues());
        }
        return false;
    }

    @Override
    public List<KeyValue> getKeyValues() {
        return new ArrayList<KeyValue>(this.keyValues);
    }

    @Override
    public KeyValue getKeyValue(String dimensionId) {
        for (KeyValue kv : this.keyValues) {
            if (!kv.getConcept().equals(dimensionId)) continue;
            return kv;
        }
        return null;
    }

    private void validate() throws ValidationException {
        HashSet<String> kvIdSet = new HashSet<String>();
        int count = 0;
        int countWildcard = 0;
        for (KeyValue kv : this.keyValues) {
            if (kvIdSet.contains(kv.getConcept())) {
                throw new ValidationException("Constrained data key contains more then one value for dimension id: " + kv.getConcept());
            }
            kvIdSet.add(kv.getConcept());
            if (!kv.getCode().equals("*")) {
                ++count;
                continue;
            }
            ++countWildcard;
        }
        if (count == 1 && countWildcard > 0) {
            throw new ValidationException("Can not define a datakey set with only one code.  Please use Cube Region instead to mark code for inclusion or exclusion");
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConstrainedDataKeyBean)) {
            return false;
        }
        ConstrainedDataKeyBean other = (ConstrainedDataKeyBean)obj;
        if (other.getKeyValues().size() != this.getKeyValues().size()) {
            return false;
        }
        for (KeyValue otherKV : other.getKeyValues()) {
            boolean found = false;
            for (KeyValue thisKV : this.getKeyValues()) {
                if (!otherKV.equals(thisKV)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

