/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v21.common.ComponentValueSetType;
import org.sdmx.resources.sdmxml.schemas.v21.common.ContentConstraintTypeCodeType;
import org.sdmx.resources.sdmxml.schemas.v21.common.CubeRegionType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ContentConstraintType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstrainedDataKeyBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.CubeRegionBean;
import org.sdmxsource.sdmx.api.model.beans.registry.KeyValues;
import org.sdmxsource.sdmx.api.model.beans.registry.ReferencePeriodBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ReleaseCalendarBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.mutable.registry.ContentConstraintMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.KeyValuesMutable;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.ConstraintBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.CubeRegionBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.ReferencePeriodBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.ReleaseCalendarBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.ContentConstraintMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.CubeRegionMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.KeyValuesMutableImpl;
import org.sdmxsource.util.ObjectUtil;

public class ContentConstraintBeanImpl
extends ConstraintBeanImpl
implements ContentConstraintBean {
    private static final transient Logger LOG = Logger.getLogger(ContentConstraintBeanImpl.class);
    private static final long serialVersionUID = 896125780368907794L;
    private CubeRegionBean includedCubeRegion;
    private CubeRegionBean excludedCubeRegion;
    private ReferencePeriodBean referencePeriodBean;
    private ReleaseCalendarBean releaseCalendarBean;
    private boolean isDefiningActualDataPresent = true;

    public ContentConstraintBeanImpl(ContentConstraintBean bean, URL actualLocation, boolean isServiceUrl) {
        super(bean, actualLocation, isServiceUrl);
    }

    public ContentConstraintBeanImpl(ContentConstraintMutableBean mutable) {
        super(mutable);
        if (mutable.getIncludedCubeRegion() != null && (ObjectUtil.validCollection(mutable.getIncludedCubeRegion().getKeyValues()) || ObjectUtil.validCollection(mutable.getIncludedCubeRegion().getAttributeValues()))) {
            this.includedCubeRegion = new CubeRegionBeanImpl(mutable.getIncludedCubeRegion(), this);
        }
        if (mutable.getExcludedCubeRegion() != null && (ObjectUtil.validCollection(mutable.getExcludedCubeRegion().getKeyValues()) || ObjectUtil.validCollection(mutable.getExcludedCubeRegion().getAttributeValues()))) {
            this.excludedCubeRegion = new CubeRegionBeanImpl(mutable.getExcludedCubeRegion(), this);
        }
        if (mutable.getReferencePeriod() != null) {
            this.referencePeriodBean = new ReferencePeriodBeanImpl(mutable.getReferencePeriod(), (ContentConstraintBean)this);
        }
        if (mutable.getReleaseCalendar() != null) {
            this.releaseCalendarBean = new ReleaseCalendarBeanImpl(mutable.getReleaseCalendar(), (ContentConstraintBean)this);
        }
        this.isDefiningActualDataPresent = mutable.getIsDefiningActualDataPresent();
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.toString());
        }
    }

    public ContentConstraintBeanImpl(ContentConstraintType type) {
        super(type, SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT);
        if (type.isSetType()) {
            boolean bl = this.isDefiningActualDataPresent = type.getType() == ContentConstraintTypeCodeType.ACTUAL;
        }
        if (ObjectUtil.validCollection(type.getMetadataKeySetList())) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "ContentConstraintBeanImpl - MetadataKeySet");
        }
        if (ObjectUtil.validCollection(type.getCubeRegionList())) {
            this.buildCubeRegions(type.getCubeRegionList());
        }
        if (ObjectUtil.validCollection(type.getMetadataTargetRegionList())) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "ContentConstraintBeanImpl - MetadataTargetRegionList");
        }
        if (type.getReferencePeriod() != null) {
            this.referencePeriodBean = new ReferencePeriodBeanImpl(type.getReferencePeriod(), (ContentConstraintBean)this);
        }
        if (type.getReleaseCalendar() != null) {
            this.releaseCalendarBean = new ReleaseCalendarBeanImpl(type.getReleaseCalendar(), (ContentConstraintBean)this);
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.toString());
        }
    }

    private void buildCubeRegions(List<CubeRegionType> cubeRegionsTypes) {
        for (CubeRegionType cubeRegionType : cubeRegionsTypes) {
            boolean isExcluded = false;
            if (cubeRegionType.getAttributeList() != null) {
                for (ComponentValueSetType currentKey : cubeRegionType.getAttributeList()) {
                    if (!currentKey.isSetInclude() || currentKey.getInclude()) continue;
                    isExcluded = true;
                    break;
                }
            }
            if (!isExcluded && cubeRegionType.getKeyValueList() != null) {
                for (ComponentValueSetType currentKey : cubeRegionType.getKeyValueList()) {
                    if (!currentKey.isSetInclude() || currentKey.getInclude()) continue;
                    isExcluded = true;
                    break;
                }
            }
            this.storeCubeRegion(new CubeRegionBeanImpl(cubeRegionType, isExcluded, this), isExcluded);
        }
    }

    private void storeCubeRegion(CubeRegionBean currentCubeRegion, boolean isExcluded) {
        if (!isExcluded) {
            if (this.includedCubeRegion == null) {
                this.includedCubeRegion = currentCubeRegion;
            } else {
                this.mergeCubeRegion(true, currentCubeRegion);
            }
        } else if (this.excludedCubeRegion == null) {
            this.excludedCubeRegion = currentCubeRegion;
        } else {
            this.mergeCubeRegion(false, currentCubeRegion);
        }
    }

    private void mergeCubeRegion(boolean mergeIncluded, CubeRegionBean toMerge) {
        CubeRegionMutableBeanImpl mutable = null;
        mutable = mergeIncluded ? new CubeRegionMutableBeanImpl(this.includedCubeRegion) : new CubeRegionMutableBeanImpl(this.excludedCubeRegion);
        this.mergeKeyValues(mutable.getKeyValues(), toMerge.getKeyValues());
        this.mergeKeyValues(mutable.getAttributeValues(), toMerge.getAttributeValues());
        if (mergeIncluded) {
            this.includedCubeRegion = new CubeRegionBeanImpl(mutable, this);
        } else {
            this.excludedCubeRegion = new CubeRegionBeanImpl(mutable, this);
        }
    }

    private void mergeKeyValues(List<KeyValuesMutable> existingKeyValues, List<KeyValues> toMerge) {
        for (KeyValues currentKeyValues : toMerge) {
            KeyValuesMutable existingMutable = this.getKeyValues(currentKeyValues.getId(), existingKeyValues);
            if (existingMutable == null) {
                existingKeyValues.add(new KeyValuesMutableImpl(currentKeyValues));
                continue;
            }
            if (currentKeyValues.getTimeRange() != null) {
                if (ObjectUtil.validCollection(existingMutable.getKeyValues())) {
                    throw new ValidationException("Can not create CubeRegion as it is defining both a TimeRange and a Set of allowed values for a Key Value with the same Id");
                }
                throw new ValidationException("Can not create CubeRegion as it is a TimeRange twice for a Key Value with the same Id");
            }
            for (String currentValue : currentKeyValues.getValues()) {
                if (existingMutable.getKeyValues().contains(currentValue)) {
                    if (existingMutable.isCascadeValue(currentValue) != currentKeyValues.isCascadeValue(currentValue)) {
                        throw new ValidationException("Can not create CubeRegion as it defines a Key/Value '" + currentKeyValues.getId() + "'/'+currentValue)+' twice, once with cascade values set to true, and once false");
                    }
                    LOG.warn("Duplicate definition of KeyValue in 2 different Cube Regions");
                } else {
                    existingMutable.addValue(currentValue);
                }
                if (!currentKeyValues.isCascadeValue(currentValue)) continue;
                existingMutable.addCascade(currentValue);
            }
        }
    }

    private KeyValuesMutable getKeyValues(String id, List<KeyValuesMutable> kvs) {
        for (KeyValuesMutable kvMutable : kvs) {
            if (!kvMutable.getId().equals(id)) continue;
            return kvMutable;
        }
        return null;
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            ContentConstraintBean that = (ContentConstraintBean)bean;
            if (!super.equivalent(this.getIncludedCubeRegion(), that.getIncludedCubeRegion())) {
                return false;
            }
            if (!super.equivalent(this.getExcludedCubeRegion(), that.getExcludedCubeRegion())) {
                return false;
            }
            if (!super.equivalent(this.referencePeriodBean, that.getReferencePeriod())) {
                return false;
            }
            if (!super.equivalent(this.releaseCalendarBean, that.getReleaseCalendar())) {
                return false;
            }
            if (this.isDefiningActualDataPresent != that.isDefiningActualDataPresent()) {
                return false;
            }
            return super.deepEqualsInternal(that);
        }
        return false;
    }

    private void validate() {
        Set allIncludes;
        super.validateMaintainableAttributes();
        HashMap<String, HashSet<String>> includedCodesForKey = new HashMap<String, HashSet<String>>();
        HashSet<String> wildcardedConcepts = new HashSet<String>();
        if (this.getIncludedSeriesKeys() != null) {
            for (ConstrainedDataKeyBean cdkb : this.getIncludedSeriesKeys().getConstrainedDataKeys()) {
                for (KeyValue kv : cdkb.getKeyValues()) {
                    if (this.containsKey(this.excludedCubeRegion, kv)) {
                        throw new ValidationException("Constraint is in conflict with itself.  Included series key contains component '" + kv.getConcept() + "' with value '" + kv.getCode() + "'.  This code has also been specified as excluded by the constraint's CubeRegion");
                    }
                    if (kv.getCode().equals("*")) {
                        wildcardedConcepts.add(kv.getConcept());
                        includedCodesForKey.remove(kv.getConcept());
                        continue;
                    }
                    if (wildcardedConcepts.contains(kv.getConcept())) continue;
                    HashSet<String> includedCodes = (HashSet<String>)includedCodesForKey.get(kv.getConcept());
                    if (includedCodes == null) {
                        includedCodes = new HashSet<String>();
                        includedCodesForKey.put(kv.getConcept(), includedCodes);
                    }
                    includedCodes.add(kv.getCode());
                }
            }
        }
        if (this.getIncludedCubeRegion() != null) {
            for (KeyValues kvs : this.getIncludedCubeRegion().getKeyValues()) {
                allIncludes = (Set)includedCodesForKey.get(kvs.getId());
                if (!(allIncludes == null || allIncludes.containsAll(kvs.getValues()) && kvs.getValues().containsAll(allIncludes))) {
                    throw new ValidationException("Constraint is in conflict with itself. The constraint defines valid series, this can not be further restricted by the cube region.  The Cube Region has further restricted dimension '" + kvs.getId() + "' by not including all the codes defined by the keyset.");
                }
                if (this.getExcludedCubeRegion() == null) continue;
                this.validateNoKeyValuesDuplicates(kvs, this.getExcludedCubeRegion().getKeyValues());
            }
        }
        if (this.getExcludedCubeRegion() != null) {
            for (KeyValues kvs : this.getExcludedCubeRegion().getKeyValues()) {
                allIncludes = (Set)includedCodesForKey.get(kvs.getId());
                if (allIncludes != null) {
                    throw new ValidationException("Constraint is in conflict with itself. The constraint defines valid series, the dimension  '" + kvs.getId() + "' can not be further restriced by the cube region to " + "exclude codes which are already marked for inclusion by the keyset");
                }
                if (this.getIncludedCubeRegion() == null) continue;
                this.validateNoKeyValuesDuplicates(kvs, this.getIncludedCubeRegion().getKeyValues());
            }
        }
    }

    private void validateNoKeyValuesDuplicates(KeyValues kvs, List<KeyValues> kvsList) {
        for (KeyValues currentKvs : kvsList) {
            if (!currentKvs.getId().equals(kvs.getId())) continue;
            for (String currentValue : currentKvs.getValues()) {
                if (!kvs.getValues().contains(currentValue)) continue;
                throw new ValidationException("CubeRegion contains a Key Value that is both included and excluded Id='" + kvs.getId() + "' Value='" + currentValue + "'");
            }
        }
    }

    private boolean containsKey(CubeRegionBean cubeRegion, KeyValue kv) {
        if (cubeRegion != null) {
            return cubeRegion.getValues(kv.getConcept()).contains(kv.getCode());
        }
        return false;
    }

    @Override
    public ContentConstraintBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new ContentConstraintBeanImpl(this, actualLocation, isServiceUrl);
    }

    @Override
    public ContentConstraintMutableBean getMutableInstance() {
        return new ContentConstraintMutableBeanImpl(this);
    }

    @Override
    public CubeRegionBean getIncludedCubeRegion() {
        return this.includedCubeRegion;
    }

    @Override
    public CubeRegionBean getExcludedCubeRegion() {
        return this.excludedCubeRegion;
    }

    @Override
    public ReferencePeriodBean getReferencePeriod() {
        return this.referencePeriodBean;
    }

    @Override
    public ReleaseCalendarBean getReleaseCalendar() {
        return this.releaseCalendarBean;
    }

    @Override
    public boolean isDefiningActualDataPresent() {
        return this.isDefiningActualDataPresent;
    }
}

