/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DataProviderRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.MetadataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ProvisionAgreementType;
import org.sdmx.resources.sdmxml.schemas.v21.common.DataProviderReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.StructureUsageReferenceType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.StructureException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.ProvisionAgreementMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.MaintainableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.ProvisionAgreementMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class ProvisionAgreementBeanImpl
extends MaintainableBeanImpl
implements ProvisionAgreementBean {
    private static Logger LOG = Logger.getLogger(ProvisionAgreementBeanImpl.class);
    private static final long serialVersionUID = 1L;
    private CrossReferenceBean structureUseage;
    private CrossReferenceBean dataproviderRef;

    private ProvisionAgreementBeanImpl(ProvisionAgreementBean bean, URL actualLocation, boolean isServiceUrl) {
        super(bean, actualLocation, isServiceUrl);
        LOG.debug("Stub ProvisionAgreementBean Built");
    }

    public ProvisionAgreementBeanImpl(ProvisionAgreementMutableBean provisionAgreementMutable) {
        super(provisionAgreementMutable);
        LOG.debug("Building ProvisionAgreementBean from Mutable Bean");
        try {
            if (provisionAgreementMutable.getStructureUsage() != null) {
                this.structureUseage = new CrossReferenceBeanImpl((SDMXBean)this, provisionAgreementMutable.getStructureUsage());
            }
            if (provisionAgreementMutable.getDataproviderRef() != null) {
                this.dataproviderRef = new CrossReferenceBeanImpl((SDMXBean)this, provisionAgreementMutable.getDataproviderRef());
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ProvisionAgreementBean Built " + this.getUrn());
        }
    }

    public ProvisionAgreementBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.structure.ProvisionAgreementType provisionAgreementType) {
        super(provisionAgreementType, SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT);
        LOG.debug("Building ProvisionAgreementBean from 2.1 SDMX");
        try {
            if (provisionAgreementType.getStructureUsage() != null) {
                StructureUsageReferenceType dfRef = provisionAgreementType.getStructureUsage();
                this.structureUseage = RefUtil.createReference(this, dfRef);
            }
            if (provisionAgreementType.getDataProvider() != null) {
                DataProviderReferenceType dpRef = provisionAgreementType.getDataProvider();
                this.dataproviderRef = RefUtil.createReference(this, dpRef);
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ProvisionAgreementBean Built " + this.getUrn());
        }
    }

    public ProvisionAgreementBeanImpl(ProvisionAgreementType provisionAgreementType) {
        super(provisionAgreementType, SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT, provisionAgreementType.getValidTo(), provisionAgreementType.getValidFrom(), null, null, null, provisionAgreementType.getId(), provisionAgreementType.getUri(), provisionAgreementType.getNameList(), provisionAgreementType.getDescriptionList(), null, provisionAgreementType.getAnnotations());
        LOG.debug("Building ProvisionAgreementBean from 2.0 SDMX");
        try {
            if (provisionAgreementType.getDataflowRef() != null) {
                DataflowRefType dfRef = provisionAgreementType.getDataflowRef();
                this.structureUseage = ObjectUtil.validString(dfRef.getURN()) ? new CrossReferenceBeanImpl((SDMXBean)this, dfRef.getURN()) : new CrossReferenceBeanImpl(this, dfRef.getAgencyID(), dfRef.getDataflowID(), dfRef.getVersion(), SDMX_STRUCTURE_TYPE.DATAFLOW);
                this.agencyId = this.structureUseage.getMaintainableReference().getAgencyId();
            }
            if (provisionAgreementType.getMetadataflowRef() != null) {
                MetadataflowRefType mdfRef = provisionAgreementType.getMetadataflowRef();
                this.structureUseage = ObjectUtil.validString(mdfRef.getURN()) ? new CrossReferenceBeanImpl((SDMXBean)this, mdfRef.getURN()) : new CrossReferenceBeanImpl(this, mdfRef.getAgencyID(), mdfRef.getMetadataflowID(), mdfRef.getVersion(), SDMX_STRUCTURE_TYPE.METADATA_FLOW);
                this.agencyId = this.structureUseage.getMaintainableReference().getAgencyId();
            }
            if (provisionAgreementType.getDataProviderRef() != null) {
                DataProviderRefType dpRef = provisionAgreementType.getDataProviderRef();
                this.dataproviderRef = ObjectUtil.validString(dpRef.getURN()) ? new CrossReferenceBeanImpl((SDMXBean)this, dpRef.getURN()) : new CrossReferenceBeanImpl(this, dpRef.getOrganisationSchemeAgencyID(), dpRef.getOrganisationSchemeID(), dpRef.getVersion(), SDMX_STRUCTURE_TYPE.DATA_PROVIDER, dpRef.getDataProviderID());
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ProvisionAgreementBean Built " + this.getUrn());
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            ProvisionAgreementBean that = (ProvisionAgreementBean)bean;
            if (!super.equivalent(this.structureUseage, that.getStructureUseage())) {
                return false;
            }
            if (!super.equivalent(this.dataproviderRef, that.getDataproviderRef())) {
                return false;
            }
            return super.deepEqualsInternal(that);
        }
        return false;
    }

    private void validate() throws ValidationException {
        if (this.dataproviderRef == null) {
            throw new ValidationException("Provision Agreement missing reference to a data provider");
        }
        if (!this.dataproviderRef.getMaintainableReference().getVersion().equals("1.0")) {
            throw new ValidationException("Version 2.0 Data Provider Scheme is no longer supported.  Data Provider Scheme has a fixed version of 1.0 in SDMX 2.1");
        }
        if (this.structureUseage == null) {
            throw new ValidationException("Provision Agreement missing reference to a data/metadata flows");
        }
        super.validateAgencyId();
    }

    @Override
    protected void validateAgencyId() {
    }

    @Override
    public CrossReferenceBean getStructureUseage() {
        return this.structureUseage;
    }

    @Override
    public List<CrossReferenceBean> getCrossReferencedConstrainables() {
        ArrayList<CrossReferenceBean> returnList = new ArrayList<CrossReferenceBean>();
        returnList.add(this.getStructureUseage());
        returnList.add(this.getDataproviderRef());
        return returnList;
    }

    @Override
    public CrossReferenceBean getDataproviderRef() {
        return this.dataproviderRef;
    }

    @Override
    public ProvisionAgreementMutableBean getMutableInstance() {
        return new ProvisionAgreementMutableBeanImpl(this);
    }

    @Override
    public ProvisionAgreementBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new ProvisionAgreementBeanImpl(this, actualLocation, isServiceUrl);
    }
}

