/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.data.query;

import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.model.data.query.DataQuerySelection;
import org.sdmxsource.sdmx.sdmxbeans.exception.ModelException;
import org.sdmxsource.util.ObjectUtil;

public class DataQueryDimensionSelectionImpl
implements DataQuerySelection {
    private static final long serialVersionUID = -7578131456147153451L;
    private String concept;
    private Set<String> values = new HashSet<String>();

    public DataQueryDimensionSelectionImpl(String concept, String ... value) {
        if (!ObjectUtil.validString(concept)) {
            throw new ModelException(ExceptionCode.QUERY_SELECTION_MISSING_CONCEPT, new Object[0]);
        }
        this.concept = concept;
        if (value == null || value.length == 0) {
            throw new ModelException(ExceptionCode.QUERY_SELECTION_MISSING_CONCEPT_VALUE, new Object[0]);
        }
        for (String currentValue : value) {
            this.values.add(currentValue);
        }
    }

    public DataQueryDimensionSelectionImpl(String concept, Set<String> values) {
        if (!ObjectUtil.validString(concept)) {
            throw new ModelException(ExceptionCode.QUERY_SELECTION_MISSING_CONCEPT, new Object[0]);
        }
        this.concept = concept;
        if (!ObjectUtil.validCollection(values)) {
            throw new ModelException(ExceptionCode.QUERY_SELECTION_MISSING_CONCEPT_VALUE, new Object[0]);
        }
        this.values = new HashSet<String>(values);
    }

    @Override
    public String getDimensionId() {
        return this.concept;
    }

    @Override
    public String getValue() {
        if (this.values.size() > 1) {
            throw new IllegalArgumentException("More then one value exists for this selection");
        }
        return (String)this.values.toArray()[0];
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    @Override
    public Set<String> getValues() {
        return this.values;
    }

    @Override
    public boolean hasMultipleValues() {
        return this.values.size() > 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataQuerySelection) {
            DataQuerySelection that = (DataQuerySelection)obj;
            if (this.getDimensionId().equals(that.getDimensionId()) && this.getValues().containsAll(that.getValues()) && that.getValues().containsAll(this.getValues())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("");
        sb.append(this.concept);
        sb.append("");
        sb.append(" : ");
        String concat = "";
        for (String currentValue : this.values) {
            sb.append(concat);
            sb.append(currentValue);
            concat = ",";
        }
        return sb.toString();
    }
}

