/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.header;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v20.message.PartyType;
import org.sdmx.resources.sdmxml.schemas.v21.message.ContactType;
import org.sdmx.resources.sdmxml.schemas.v21.message.SenderType;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.util.ObjectUtil;

public class PartyBeanImpl
implements PartyBean,
Serializable {
    private static final long serialVersionUID = -4454791463810290878L;
    private Map<String, String> name = new HashMap<String, String>();
    private String id;
    private List<PartyBean.ContactBean> contacts = new ArrayList<PartyBean.ContactBean>();
    private String timeZone;

    public PartyBeanImpl(Map<String, String> name, String id, List<PartyBean.ContactBean> contacts, String timeZone) {
        if (name != null) {
            this.name = new HashMap<String, String>(name);
        }
        this.id = id;
        if (contacts != null) {
            this.contacts = new ArrayList<PartyBean.ContactBean>(contacts);
        }
        this.timeZone = timeZone;
        this.validate();
    }

    public PartyBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.message.PartyType partyType) {
        this.id = partyType.getId();
        if (ObjectUtil.validCollection(partyType.getNameList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : partyType.getNameList()) {
                this.name.put(tt.getLang(), tt.getStringValue());
            }
        }
        if (ObjectUtil.validCollection(partyType.getContactList())) {
            for (ContactType contactType : partyType.getContactList()) {
                this.contacts.add(new ContactImpl(contactType));
            }
        }
        this.validate();
    }

    public PartyBeanImpl(SenderType senderType) {
        this.id = senderType.getId();
        if (ObjectUtil.validCollection(senderType.getNameList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : senderType.getNameList()) {
                this.name.put(tt.getLang(), tt.getStringValue());
            }
        }
        if (ObjectUtil.validCollection(senderType.getContactList())) {
            for (ContactType contactType : senderType.getContactList()) {
                this.contacts.add(new ContactImpl(contactType));
            }
        }
        this.timeZone = senderType.getTimezone();
        this.validate();
    }

    public PartyBeanImpl(PartyType partyType) {
        this.id = partyType.getId();
        if (ObjectUtil.validCollection(partyType.getNameList())) {
            for (TextType tt : partyType.getNameList()) {
                String lang = tt.getLang() == null ? Locale.ENGLISH.getLanguage() : tt.getLang();
                this.name.put(lang, tt.getStringValue());
            }
        }
        if (ObjectUtil.validCollection(partyType.getContactList())) {
            for (org.sdmx.resources.sdmxml.schemas.v20.message.ContactType contactType : partyType.getContactList()) {
                this.contacts.add(new ContactImpl(contactType));
            }
        }
        this.validate();
    }

    public PartyBeanImpl(org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.PartyType partyType) {
        this.id = partyType.getId();
        if (ObjectUtil.validCollection(partyType.getNameList())) {
            for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType tt : partyType.getNameList()) {
                String lang = tt.getLang() == null ? Locale.ENGLISH.getLanguage() : tt.getLang();
                this.name.put(lang, tt.getStringValue());
            }
        }
        if (ObjectUtil.validCollection(partyType.getContactList())) {
            for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.ContactType contactType : partyType.getContactList()) {
                this.contacts.add(new ContactImpl(contactType));
            }
        }
        this.validate();
    }

    public void validate() throws ValidationException {
        Pattern idPattern;
        if (!ObjectUtil.validString(this.id)) {
            throw new ValidationException("Party missing mandatory id");
        }
        if (this.timeZone != null && !(idPattern = Pattern.compile("(\\+|\\-)(14:00|((0[0-9]|1[0-3]):[0-5][0-9]))")).matcher(this.timeZone).matches()) {
            throw new ValidationException("Time zone '" + this.timeZone + "' is in an invalid format. please ensure the format matches the patttern (\\+|\\-)(14:00|((0[0-9]|1[0-3]):[0-5][0-9]) example +12:30");
        }
        PartyBeanImpl.replaceNullKeyWithDefaultLocale(this.name);
    }

    private static void replaceNullKeyWithDefaultLocale(Map<String, String> map) {
        if (map.containsKey(null)) {
            String defaultName = map.get(null);
            map.remove(null);
            map.put(Locale.ENGLISH.getLanguage(), defaultName);
        }
    }

    @Override
    public Map<String, String> getName() {
        return new HashMap<String, String>(this.name);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<PartyBean.ContactBean> getContacts() {
        return new ArrayList<PartyBean.ContactBean>(this.contacts);
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }

    public static class ContactImpl
    implements PartyBean.ContactBean,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, String> name = new HashMap<String, String>();
        private Map<String, String> role = new HashMap<String, String>();
        private Map<String, String> departments = new HashMap<String, String>();
        private List<String> email = new ArrayList<String>();
        private List<String> fax = new ArrayList<String>();
        private List<String> telephone = new ArrayList<String>();
        private List<String> uri = new ArrayList<String>();
        private List<String> x400 = new ArrayList<String>();

        public ContactImpl(Map<String, String> name, Map<String, String> role, Map<String, String> departments, List<String> email, List<String> fax, List<String> telephone, List<String> uri, List<String> x400) {
            if (name != null) {
                this.name = new HashMap<String, String>(name);
            }
            if (role != null) {
                this.role = new HashMap<String, String>(role);
            }
            if (departments != null) {
                this.departments = new HashMap<String, String>(departments);
            }
            if (email != null) {
                this.email = new ArrayList<String>(email);
            }
            if (fax != null) {
                this.fax = new ArrayList<String>(fax);
            }
            if (telephone != null) {
                this.telephone = new ArrayList<String>(telephone);
            }
            if (uri != null) {
                this.uri = new ArrayList<String>(uri);
            }
            if (x400 != null) {
                this.x400 = new ArrayList<String>(x400);
            }
        }

        public ContactImpl(ContactType contactType) {
            if (ObjectUtil.validCollection(contactType.getDepartmentList())) {
                for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : contactType.getDepartmentList()) {
                    this.departments.put(tt.getLang(), tt.getStringValue());
                }
            }
            if (ObjectUtil.validCollection(contactType.getEmailList())) {
                this.email = new ArrayList<String>(contactType.getEmailList());
            }
            if (ObjectUtil.validCollection(contactType.getFaxList())) {
                this.fax = new ArrayList<String>(contactType.getFaxList());
            }
            if (ObjectUtil.validCollection(contactType.getNameList())) {
                for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : contactType.getNameList()) {
                    this.name.put(tt.getLang(), tt.getStringValue());
                }
            }
            if (ObjectUtil.validCollection(contactType.getRoleList())) {
                for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : contactType.getRoleList()) {
                    this.role.put(tt.getLang(), tt.getStringValue());
                }
            }
            if (ObjectUtil.validCollection(contactType.getTelephoneList())) {
                this.telephone = new ArrayList<String>(contactType.getTelephoneList());
            }
            if (ObjectUtil.validCollection(contactType.getURIList())) {
                this.uri = new ArrayList<String>(contactType.getURIList());
            }
            if (ObjectUtil.validCollection(contactType.getX400List())) {
                this.x400 = new ArrayList<String>(contactType.getX400List());
            }
            this.validate();
        }

        public ContactImpl(org.sdmx.resources.sdmxml.schemas.v20.message.ContactType contactType) {
            String lang;
            if (ObjectUtil.validCollection(contactType.getDepartmentList())) {
                for (TextType tt : contactType.getDepartmentList()) {
                    this.departments.put(tt.getLang(), tt.getStringValue());
                }
            }
            if (ObjectUtil.validCollection(contactType.getEmailList())) {
                this.email = new ArrayList<String>(contactType.getEmailList());
            }
            if (ObjectUtil.validCollection(contactType.getFaxList())) {
                this.fax = new ArrayList<String>(contactType.getFaxList());
            }
            if (ObjectUtil.validCollection(contactType.getNameList())) {
                for (TextType tt : contactType.getNameList()) {
                    lang = tt.getLang() == null ? Locale.ENGLISH.getLanguage() : tt.getLang();
                    this.name.put(lang, tt.getStringValue());
                }
            }
            if (ObjectUtil.validCollection(contactType.getRoleList())) {
                for (TextType tt : contactType.getRoleList()) {
                    lang = tt.getLang() == null ? Locale.ENGLISH.getLanguage() : tt.getLang();
                    this.role.put(lang, tt.getStringValue());
                }
            }
            if (ObjectUtil.validCollection(contactType.getTelephoneList())) {
                this.telephone = new ArrayList<String>(contactType.getTelephoneList());
            }
            if (ObjectUtil.validCollection(contactType.getURIList())) {
                this.uri = new ArrayList<String>(contactType.getURIList());
            }
            if (ObjectUtil.validCollection(contactType.getX400List())) {
                this.x400 = new ArrayList<String>(contactType.getX400List());
            }
            this.validate();
        }

        public ContactImpl(org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.ContactType contactType) {
            String lang;
            if (ObjectUtil.validCollection(contactType.getDepartmentList())) {
                for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType tt : contactType.getDepartmentList()) {
                    this.departments.put(tt.getLang(), tt.getStringValue());
                }
            }
            if (ObjectUtil.validCollection(contactType.getEmailList())) {
                this.email = new ArrayList<String>(contactType.getEmailList());
            }
            if (ObjectUtil.validCollection(contactType.getFaxList())) {
                this.fax = new ArrayList<String>(contactType.getFaxList());
            }
            if (ObjectUtil.validCollection(contactType.getNameList())) {
                for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType tt : contactType.getNameList()) {
                    lang = tt.getLang() == null ? Locale.ENGLISH.getLanguage() : tt.getLang();
                    this.name.put(lang, tt.getStringValue());
                }
            }
            if (ObjectUtil.validCollection(contactType.getRoleList())) {
                for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType tt : contactType.getRoleList()) {
                    lang = tt.getLang() == null ? Locale.ENGLISH.getLanguage() : tt.getLang();
                    this.role.put(lang, tt.getStringValue());
                }
            }
            if (ObjectUtil.validCollection(contactType.getTelephoneList())) {
                this.telephone = new ArrayList<String>(contactType.getTelephoneList());
            }
            if (ObjectUtil.validCollection(contactType.getURIList())) {
                this.uri = new ArrayList<String>(contactType.getURIList());
            }
            if (ObjectUtil.validCollection(contactType.getX400List())) {
                this.x400 = new ArrayList<String>(contactType.getX400List());
            }
            this.validate();
        }

        private void validate() {
            PartyBeanImpl.replaceNullKeyWithDefaultLocale(this.name);
            PartyBeanImpl.replaceNullKeyWithDefaultLocale(this.role);
            PartyBeanImpl.replaceNullKeyWithDefaultLocale(this.departments);
        }

        @Override
        public Map<String, String> getName() {
            return new HashMap<String, String>(this.name);
        }

        @Override
        public Map<String, String> getRole() {
            return new HashMap<String, String>(this.role);
        }

        @Override
        public Map<String, String> getDepartments() {
            return new HashMap<String, String>(this.departments);
        }

        @Override
        public List<String> getEmail() {
            return new ArrayList<String>(this.email);
        }

        @Override
        public List<String> getFax() {
            return new ArrayList<String>(this.fax);
        }

        @Override
        public List<String> getTelephone() {
            return new ArrayList<String>(this.telephone);
        }

        @Override
        public List<String> getUri() {
            return new ArrayList<String>(this.uri);
        }

        @Override
        public List<String> getX400() {
            return new ArrayList<String>(this.x400);
        }
    }
}

