/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.metadata;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v21.common.RefBaseType;
import org.sdmx.resources.sdmxml.schemas.v21.metadata.generic.MetadataSetType;
import org.sdmx.resources.sdmxml.schemas.v21.metadata.generic.ReportType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataReportBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataSetBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SDMXBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.metadata.MetadataReportBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class MetadataSetBeanImpl
extends SDMXBeanImpl
implements MetadataSetBean {
    private static final long serialVersionUID = -4992186811361863150L;
    private CrossReferenceBean _structureRef;
    private SdmxDate _reportingBeginDate;
    private SdmxDate _reportingEndDate;
    private SdmxDate _publicationYear;
    private SdmxDate _validFromDate;
    private SdmxDate _validToDate;
    private Object _publicationPeriod;
    private CrossReferenceBean _dataProviderReference;
    private List<MetadataReportBean> _reports = new ArrayList<MetadataReportBean>();

    public MetadataSetBeanImpl(MetadataBean parent, MetadataSetType createdFrom) {
        super(SDMX_STRUCTURE_TYPE.METADATA_SET, (SDMXBean)parent);
        for (DatasetStructureReferenceBean structurereference : parent.getHeader().getStructures()) {
            if (!structurereference.getId().equals(createdFrom.getStructureRef())) continue;
            this._structureRef = new CrossReferenceBeanImpl((SDMXBean)this, structurereference.getStructureReference());
            break;
        }
        if (createdFrom.getReportingBeginDate() != null) {
            this._reportingBeginDate = new SdmxDateImpl(createdFrom.getReportingBeginDate().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (createdFrom.getReportingEndDate() != null) {
            this._reportingEndDate = new SdmxDateImpl(createdFrom.getReportingEndDate().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (createdFrom.getPublicationYear() != null) {
            this._publicationYear = new SdmxDateImpl(createdFrom.getPublicationYear().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (createdFrom.getValidFromDate() != null) {
            this._validFromDate = new SdmxDateImpl(createdFrom.getValidFromDate().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (createdFrom.getValidToDate() != null) {
            this._validToDate = new SdmxDateImpl(createdFrom.getValidToDate().getTime(), TIME_FORMAT.DATE_TIME);
        }
        this._publicationPeriod = createdFrom.getPublicationPeriod();
        if (createdFrom.getDataProvider() != null) {
            if (ObjectUtil.validString(createdFrom.getDataProvider().getURN())) {
                this._dataProviderReference = new CrossReferenceBeanImpl((SDMXBean)this, createdFrom.getDataProvider().getURN());
            } else {
                RefBaseType dfRef = createdFrom.getDataProvider().getRef();
                this._dataProviderReference = new CrossReferenceBeanImpl(this, dfRef.getAgencyID(), dfRef.getId(), dfRef.getVersion(), SDMX_STRUCTURE_TYPE.DATA_PROVIDER);
            }
        }
        if (ObjectUtil.validCollection(createdFrom.getReportList())) {
            for (ReportType currentReport : createdFrom.getReportList()) {
                this._reports.add(new MetadataReportBeanImpl(this, currentReport));
            }
        }
        this.validate();
    }

    private void validate() throws ValidationException {
        if (!ObjectUtil.validCollection(this._reports)) {
            throw new ValidationException("Metadata Set requires at least one Report");
        }
        if (this._structureRef == null) {
            throw new ValidationException("Metadata Set requires a reference to an MSD");
        }
        if (this._structureRef.getTargetReference() != SDMX_STRUCTURE_TYPE.MSD) {
            throw new ValidationException("Metadata Set reference must be a reference to an MSD");
        }
    }

    @Override
    public CrossReferenceBean getMsdReference() {
        return this._structureRef;
    }

    @Override
    public SdmxDate getPublicationYear() {
        return this._publicationYear;
    }

    @Override
    public Object getPublicationPeriod() {
        return this._publicationPeriod;
    }

    @Override
    public CrossReferenceBean getDataProviderReference() {
        return this._dataProviderReference;
    }

    @Override
    public SdmxDate getReportingBeginDate() {
        return this._reportingBeginDate;
    }

    @Override
    public SdmxDate getReportingEndDate() {
        return this._reportingEndDate;
    }

    @Override
    public SdmxDate getValidFromDate() {
        return this._validFromDate;
    }

    @Override
    public SdmxDate getValidToDate() {
        return this._validToDate;
    }

    @Override
    public List<MetadataReportBean> getReports() {
        return new ArrayList<MetadataReportBean>(this._reports);
    }
}

