/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.mutable.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.SdmxReader;
import org.sdmxsource.sdmx.api.model.beans.base.NameableBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.mutable.base.NameableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.IdentifiableMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextTypeWrapperMutableBeanImpl;

public abstract class NameableMutableBeanImpl
extends IdentifiableMutableBeanImpl
implements NameableMutableBean {
    private static final long serialVersionUID = 1L;
    private List<TextTypeWrapperMutableBean> name;
    private List<TextTypeWrapperMutableBean> description;

    public NameableMutableBeanImpl(SDMX_STRUCTURE_TYPE structureType) {
        super(structureType);
    }

    public NameableMutableBeanImpl(NameableBean bean) {
        super(bean);
        if (bean.getName() != null) {
            this.name = new ArrayList<TextTypeWrapperMutableBean>();
            for (TextTypeWrapper currentTextType : bean.getNames()) {
                this.name.add(new TextTypeWrapperMutableBeanImpl(currentTextType));
            }
        }
        if (bean.getDescription() != null) {
            this.description = new ArrayList<TextTypeWrapperMutableBean>();
            for (TextTypeWrapper currentTextType : bean.getDescriptions()) {
                this.description.add(new TextTypeWrapperMutableBeanImpl(currentTextType));
            }
        }
    }

    @Override
    protected boolean processReader(SdmxReader reader) {
        if (super.processReader(reader)) {
            return true;
        }
        if (reader.getCurrentElement().equals("Name")) {
            String lang = reader.getAttributeValue("lang", false);
            this.addName(lang, reader.getCurrentElementValue());
            return true;
        }
        if (reader.getCurrentElement().equals("Description")) {
            String lang = reader.getAttributeValue("lang", false);
            this.addDescription(lang, reader.getCurrentElementValue());
            return true;
        }
        return false;
    }

    @Override
    public void addDescription(String locale, String name) {
        if (this.description == null) {
            this.description = new ArrayList<TextTypeWrapperMutableBean>();
        }
        for (TextTypeWrapperMutableBean currentTT : this.description) {
            if (!currentTT.getLocale().equals(locale)) continue;
            currentTT.setValue(name);
            return;
        }
        TextTypeWrapperMutableBeanImpl tt = new TextTypeWrapperMutableBeanImpl();
        tt.setLocale(locale);
        tt.setValue(name);
        this.description.add(tt);
    }

    @Override
    public void addName(String locale, String name) {
        if (this.name == null) {
            this.name = new ArrayList<TextTypeWrapperMutableBean>();
        }
        for (TextTypeWrapperMutableBean currentTT : this.name) {
            if (!currentTT.getLocale().equals(locale)) continue;
            currentTT.setValue(name);
            return;
        }
        TextTypeWrapperMutableBeanImpl tt = new TextTypeWrapperMutableBeanImpl();
        tt.setLocale(locale);
        tt.setValue(name);
        this.name.add(tt);
    }

    @Override
    public String getName(boolean defaultIfNull) {
        Iterator<TextTypeWrapperMutableBean> i$ = this.getName().iterator();
        if (i$.hasNext()) {
            TextTypeWrapperMutableBean mutable = i$.next();
            return mutable.getValue();
        }
        return null;
    }

    @Override
    public List<TextTypeWrapperMutableBean> getName() {
        return this.name;
    }

    @Override
    public void setName(List<TextTypeWrapperMutableBean> name) {
        this.name = name;
    }

    @Override
    public List<TextTypeWrapperMutableBean> getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(List<TextTypeWrapperMutableBean> description) {
        this.description = description;
    }
}

