/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.superbeans.categoryscheme;

import org.sdmxsource.sdmx.api.exception.ReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategoryBean;
import org.sdmxsource.sdmx.api.model.superbeans.categoryscheme.CategorisationSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base.MaintainableSuperBeanImpl;

public class CategorisationSuperBeanImpl
extends MaintainableSuperBeanImpl
implements CategorisationSuperBean {
    private static final long serialVersionUID = 1L;
    private CategorisationBean categorisation;
    private IdentifiableBean structure;
    private CategoryBean category;

    public CategorisationSuperBeanImpl(CategorisationBean categorisation, SdmxBeanRetrievalManager retMan) {
        super(categorisation);
        MaintainableBean maint = retMan.getMaintainable(categorisation.getStructureReference());
        MaintainableBean cs = retMan.getMaintainable(categorisation.getCategoryReference());
        for (IdentifiableBean ident : cs.getIdentifiableComposites()) {
            if (!categorisation.getCategoryReference().isMatch(ident)) continue;
            this.category = (CategoryBean)ident;
            break;
        }
        if (categorisation.getStructureReference().getTargetReference().isMaintainable() && categorisation.getStructureReference().isMatch(maint)) {
            this.structure = maint;
        } else {
            for (IdentifiableBean ident : maint.getIdentifiableComposites()) {
                if (!categorisation.getStructureReference().isMatch(ident)) continue;
                this.structure = ident;
                break;
            }
        }
        if (this.structure == null) {
            throw new ReferenceException(categorisation.getStructureReference());
        }
        if (this.category == null) {
            throw new ReferenceException(categorisation.getCategoryReference());
        }
    }

    @Override
    public IdentifiableBean getStructure() {
        return this.structure;
    }

    @Override
    public CategoryBean getCategory() {
        return this.category;
    }

    @Override
    public CategorisationBean getBuiltFrom() {
        return this.categorisation;
    }
}

