/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.superbeans.datastructure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.GroupBean;
import org.sdmxsource.sdmx.api.model.superbeans.base.ComponentSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.conceptscheme.ConceptSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.AttributeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DimensionSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.GroupSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.PrimaryMeasureSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base.MaintainableSuperBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.datastructure.GroupSuperBeanImpl;

public class DataStructureSuperBeanImpl
extends MaintainableSuperBeanImpl
implements DataStructureSuperBean {
    private static final long serialVersionUID = 1L;
    private List<DimensionSuperBean> dimensions;
    private List<AttributeSuperBean> attributes;
    private PrimaryMeasureSuperBean primaryMeasure;
    private List<GroupSuperBean> groups = new ArrayList<GroupSuperBean>();
    private Map<String, DimensionSuperBean> conceptDimensionMap;
    private Map<String, ComponentSuperBean> conceptComponentMap = new HashMap<String, ComponentSuperBean>();
    private Map<String, CodelistSuperBean> conceptCodelistMap = new HashMap<String, CodelistSuperBean>();
    private Set<CodelistSuperBean> referencedCodelists = new HashSet<CodelistSuperBean>();
    private DataStructureBean keyFamily;

    public DataStructureSuperBeanImpl(DataStructureBean dataStructure, List<DimensionSuperBean> dimensions, List<AttributeSuperBean> attributes, PrimaryMeasureSuperBean primaryMeasure) {
        super(dataStructure);
        this.keyFamily = dataStructure;
        this.dimensions = dimensions;
        this.attributes = attributes;
        this.primaryMeasure = primaryMeasure;
        this.conceptDimensionMap = new HashMap<String, DimensionSuperBean>();
        for (DimensionSuperBean currentDimension : dimensions) {
            this.conceptDimensionMap.put(currentDimension.getId(), currentDimension);
            this.conceptComponentMap.put(currentDimension.getId(), currentDimension);
            if (currentDimension.getCodelist(true) == null) continue;
            this.conceptCodelistMap.put(currentDimension.getId(), currentDimension.getCodelist(true));
            this.referencedCodelists.add(currentDimension.getCodelist(true));
        }
        if (attributes != null) {
            for (AttributeSuperBean currentBean : attributes) {
                this.conceptComponentMap.put(currentBean.getId(), currentBean);
                if (currentBean.getCodelist(true) == null) continue;
                this.conceptCodelistMap.put(currentBean.getId(), currentBean.getCodelist(true));
                this.referencedCodelists.add(currentBean.getCodelist(true));
            }
        }
        if (primaryMeasure != null) {
            this.conceptComponentMap.put(primaryMeasure.getId(), primaryMeasure);
            if (primaryMeasure.getCodelist(true) != null) {
                this.conceptCodelistMap.put(primaryMeasure.getId(), primaryMeasure.getCodelist(true));
                this.referencedCodelists.add(primaryMeasure.getCodelist(true));
            }
        }
        for (GroupBean currentGroup : dataStructure.getGroups()) {
            this.groups.add(new GroupSuperBeanImpl(currentGroup, this));
        }
    }

    @Override
    public DataStructureBean getDataStructureBean() {
        return this.keyFamily;
    }

    @Override
    public DataStructureBean getBuiltFrom() {
        return this.keyFamily;
    }

    @Override
    public Set<CodelistSuperBean> getReferencedCodelists() {
        return new HashSet<CodelistSuperBean>(this.referencedCodelists);
    }

    @Override
    public Set<ComponentSuperBean> getComponents() {
        return new HashSet<ComponentSuperBean>(this.conceptComponentMap.values());
    }

    @Override
    public Set<ConceptSuperBean> getReferencedConcepts() {
        HashSet<ConceptSuperBean> returnConcepts = new HashSet<ConceptSuperBean>();
        for (ComponentSuperBean currentComponent : this.conceptComponentMap.values()) {
            returnConcepts.add(currentComponent.getConcept());
        }
        return returnConcepts;
    }

    @Override
    public CodelistSuperBean getCodelistByComponentId(String conceptId) {
        return this.conceptCodelistMap.get(conceptId);
    }

    @Override
    public ComponentSuperBean getComponentById(String conceptId) {
        return this.conceptComponentMap.get(conceptId);
    }

    @Override
    public DimensionSuperBean getTimeDimension() {
        for (DimensionSuperBean currentDimension : this.dimensions) {
            if (!currentDimension.isTimeDimension()) continue;
            return currentDimension;
        }
        return null;
    }

    @Override
    public DimensionSuperBean getDimensionById(String conceptId) {
        return this.conceptDimensionMap.get(conceptId);
    }

    @Override
    public List<DimensionSuperBean> getDimensions() {
        return new ArrayList<DimensionSuperBean>(this.dimensions);
    }

    @Override
    public List<DimensionSuperBean> getDimensions(SDMX_STRUCTURE_TYPE ... includeTypes) {
        if (this.dimensions != null) {
            ArrayList<DimensionSuperBean> returnList = new ArrayList<DimensionSuperBean>();
            for (DimensionSuperBean dim : this.dimensions) {
                if (includeTypes != null && includeTypes.length > 0) {
                    for (SDMX_STRUCTURE_TYPE currentType : includeTypes) {
                        if (currentType != dim.getBuiltFrom().getStructureType()) continue;
                        returnList.add(dim);
                    }
                    continue;
                }
                returnList.add(dim);
            }
            return returnList;
        }
        return new ArrayList<DimensionSuperBean>();
    }

    @Override
    public List<AttributeSuperBean> getAttributes() {
        return new ArrayList<AttributeSuperBean>(this.attributes);
    }

    @Override
    public PrimaryMeasureSuperBean getPrimaryMeasure() {
        return this.primaryMeasure;
    }

    @Override
    public List<AttributeSuperBean> getDatasetAttributes() {
        return this.getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL.DATA_SET);
    }

    @Override
    public Set<AttributeSuperBean> getGroupAttributes() {
        List<AttributeSuperBean> allGroupAttributes = this.getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL.GROUP);
        return new HashSet<AttributeSuperBean>(allGroupAttributes);
    }

    @Override
    public List<AttributeSuperBean> getGroupAttributes(String groupId) {
        List<AttributeSuperBean> allGroupAttributes = this.getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL.GROUP);
        ArrayList<AttributeSuperBean> returnList = new ArrayList<AttributeSuperBean>();
        for (AttributeSuperBean currentAttribute : allGroupAttributes) {
            if (!currentAttribute.getAttachmentGroup().equals(groupId)) continue;
            returnList.add(currentAttribute);
        }
        return returnList;
    }

    @Override
    public List<GroupSuperBean> getGroups() {
        return new ArrayList<GroupSuperBean>(this.groups);
    }

    @Override
    public GroupSuperBean getGroup(String id) {
        if (this.groups != null) {
            for (GroupSuperBean currentBean : this.groups) {
                if (!currentBean.getId().equals(id)) continue;
                return currentBean;
            }
        }
        return null;
    }

    @Override
    public List<AttributeSuperBean> getObservationAttributes() {
        return this.getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION);
    }

    @Override
    public List<AttributeSuperBean> getSeriesAttributes() {
        return this.getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP);
    }

    private List<AttributeSuperBean> getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL type) {
        ArrayList<AttributeSuperBean> returnList = new ArrayList<AttributeSuperBean>();
        for (AttributeSuperBean currentAttribute : this.attributes) {
            if (!currentAttribute.getAttachmentLevel().equals((Object)type)) continue;
            returnList.add(currentAttribute);
        }
        return returnList;
    }

    @Override
    public String getAttributeAttachmentGroup(String id) {
        for (AttributeSuperBean a : this.attributes) {
            if (!a.getId().equals(id)) continue;
            return a.getAttachmentGroup();
        }
        return null;
    }

    @Override
    public String getGroupId(Set<String> dimensions) {
        for (GroupSuperBean g : this.groups) {
            HashSet<String> grpDims = new HashSet<String>();
            for (DimensionSuperBean d : g.getDimensions()) {
                grpDims.add(d.getId());
            }
            if (!((Object)grpDims).equals(dimensions)) continue;
            return g.getId();
        }
        return null;
    }
}

