/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.builder.ConstraintBuilder;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.DataSourceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.ConstraintAttachmentMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.KeyValuesMutable;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.ConstrainedDataKeyMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.ConstraintDataKeySetMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.ContentConstraintAttachmentMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.ContentConstraintMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.CubeRegionMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.KeyValuesMutableImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.ReferencePeriodMutableBeanImpl;
import org.springframework.stereotype.Service;

@Service
public class ConstraintBuilderImpl
implements ConstraintBuilder {
    @Override
    public ContentConstraintBean buildConstraint(DataReaderEngine dre, StructureReferenceBean attachment, DataSourceBean dsAttachement, boolean indexAttributes, boolean indexDataset, boolean indexReportingPeriod, boolean indexTimeSeries, boolean definingDataPresent, MaintainableRefBean refParams) {
        dre.reset();
        if (!dre.moveNextDataset()) {
            throw new ValidationException("Can not index time series for registered datasource, the data retrieved from the datasource does not contain a dataset");
        }
        if (!(indexAttributes || indexDataset || indexReportingPeriod || indexTimeSeries)) {
            return null;
        }
        DatasetHeaderBean header = dre.getCurrentDatasetHeaderBean();
        if (indexTimeSeries && !header.isTimeSeries()) {
            throw new ValidationException("Can not index time series for registered datasource, the data retrieved from the datasource is not time series");
        }
        ContentConstraintMutableBeanImpl mutableBean = new ContentConstraintMutableBeanImpl();
        mutableBean.setAgencyId(refParams.getAgencyId());
        mutableBean.setId(refParams.getMaintainableId());
        mutableBean.setVersion(refParams.getVersion());
        mutableBean.addName("en", "Generated Constraint");
        mutableBean.addDescription("en", "Constraint built from dataset");
        mutableBean.setIsDefiningActualDataPresent(true);
        mutableBean.setConstraintAttachment(this.buildAttachement(attachment, dsAttachement));
        ConstraintDataKeySetMutableBeanImpl dataKeySet = null;
        HashMap<String, Set<String>> cubeRegionMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> attributeMap = new HashMap<String, Set<String>>();
        Date reportFrom = null;
        Date reportTo = null;
        HashSet<String> processedDates = new HashSet<String>();
        while (dre.moveNextKeyable()) {
            Keyable key = dre.getCurrentKey();
            if (key.isSeries()) {
                if (indexTimeSeries) {
                    if (dataKeySet == null) {
                        dataKeySet = new ConstraintDataKeySetMutableBeanImpl();
                        mutableBean.setIncludedSeriesKeys(dataKeySet);
                    }
                    ConstrainedDataKeyMutableBeanImpl dataKey = new ConstrainedDataKeyMutableBeanImpl();
                    dataKey.setKeyValues(key.getKey());
                    dataKeySet.addConstrainedDataKey(dataKey);
                }
                if (indexDataset) {
                    this.storeKeyValuesOnMap(key.getKey(), cubeRegionMap);
                }
                if (indexAttributes) {
                    this.storeKeyValuesOnMap(key.getAttributes(), attributeMap);
                }
            }
            if (!indexAttributes && !indexReportingPeriod) continue;
            while (dre.moveNextObservation()) {
                Observation obs = dre.getCurrentObservation();
                if (indexReportingPeriod && !processedDates.contains(obs.getObsTime())) {
                    Date obsDate = obs.getObsAsTimeDate();
                    if (reportFrom == null || reportFrom.getTime() > obsDate.getTime()) {
                        reportFrom = obsDate;
                    }
                    if (reportTo == null || reportTo.getTime() < obsDate.getTime()) {
                        reportTo = obsDate;
                    }
                    processedDates.add(obs.getObsTime());
                }
                if (!indexAttributes) continue;
                this.storeKeyValuesOnMap(obs.getAttributes(), attributeMap);
            }
        }
        if (indexAttributes || indexDataset) {
            CubeRegionMutableBeanImpl cubeRegionMutableBean = new CubeRegionMutableBeanImpl();
            mutableBean.setIncludedCubeRegion(cubeRegionMutableBean);
            if (indexAttributes) {
                this.createKeyValues(attributeMap, cubeRegionMutableBean.getAttributeValues());
            }
            if (indexDataset) {
                this.createKeyValues(cubeRegionMap, cubeRegionMutableBean.getKeyValues());
            }
        }
        if (indexReportingPeriod && reportFrom != null && reportTo != null) {
            ReferencePeriodMutableBeanImpl refPeriodMutable = new ReferencePeriodMutableBeanImpl();
            refPeriodMutable.setEndTime(reportTo);
            refPeriodMutable.setStartTime(reportFrom);
            mutableBean.setReferencePeriod(refPeriodMutable);
        }
        return mutableBean.getImmutableInstance();
    }

    private void createKeyValues(Map<String, Set<String>> cubeRegionMap, List<KeyValuesMutable> populateMap) {
        for (String currentConcept : cubeRegionMap.keySet()) {
            KeyValuesMutableImpl kvs = new KeyValuesMutableImpl();
            kvs.setId(currentConcept);
            kvs.setKeyValues(new ArrayList<String>((Collection)cubeRegionMap.get(currentConcept)));
            populateMap.add(kvs);
        }
    }

    private void storeKeyValuesOnMap(List<KeyValue> kvs, Map<String, Set<String>> cubeRegionMap) {
        for (KeyValue kv : kvs) {
            Set<String> valuesForConcept = cubeRegionMap.get(kv.getConcept());
            if (valuesForConcept == null) {
                valuesForConcept = new HashSet<String>();
                cubeRegionMap.put(kv.getConcept(), valuesForConcept);
            }
            valuesForConcept.add(kv.getCode());
        }
    }

    private ConstraintAttachmentMutableBean buildAttachement(StructureReferenceBean attachment, DataSourceBean dsAttachement) {
        ContentConstraintAttachmentMutableBeanImpl mutable = new ContentConstraintAttachmentMutableBeanImpl();
        mutable.addStructureReference(attachment);
        return mutable;
    }
}

