/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.superbeans.impl;

import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.exception.ReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.superbeans.SuperBeans;
import org.sdmxsource.sdmx.api.model.superbeans.base.SuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.conceptscheme.ConceptSchemeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.conceptscheme.ConceptSuperBean;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.CodelistSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.ConceptSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.StructureBuilderImpl;
import org.sdmxsource.sdmx.structureretrieval.manager.InMemorySdmxSuperBeanRetrievalManager;
import org.sdmxsource.sdmx.util.beans.container.SuperBeansImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class ComponentSuperBeanBuilder<K extends SuperBean, V extends SDMXBean>
extends StructureBuilderImpl<K, V> {
    private static final Logger LOG = Logger.getLogger(ComponentSuperBeanBuilder.class);
    @Autowired
    private CodelistSuperBeanBuilder codelistSuperBeanBuilder;
    @Autowired
    private ConceptSuperBeanBuilder conceptSuperBeanBuilder;

    CodelistSuperBean getCodelist(ComponentBean componentBean, SdmxBeanRetrievalManager retrievalManager, SuperBeans existingBeans) {
        if (existingBeans == null) {
            existingBeans = new SuperBeansImpl();
        }
        InMemorySdmxSuperBeanRetrievalManager superBeanRetrievalManager = new InMemorySdmxSuperBeanRetrievalManager(existingBeans);
        if (componentBean.hasCodedRepresentation()) {
            MaintainableRefBean codelistRef = componentBean.getRepresentation().getRepresentationRef().getMaintainableReference();
            LOG.debug("get codelist super bean : " + codelistRef);
            CodelistSuperBean codelistSuperBean = superBeanRetrievalManager.getCodelistSuperBean(codelistRef);
            if (codelistSuperBean == null) {
                CodelistBean codelistBean = retrievalManager.getCodelist(codelistRef);
                if (codelistBean == null) {
                    throw new ReferenceException("Can not resolve reference to codelist: " + codelistRef);
                }
                LOG.debug("no existing super bean found build new : " + codelistBean.getUrn());
                codelistSuperBean = this.codelistSuperBeanBuilder.build(codelistBean);
                existingBeans.addCodelist(codelistSuperBean);
            }
            return codelistSuperBean;
        }
        LOG.debug("component is uncoded");
        return null;
    }

    ConceptSuperBean getConcept(ComponentBean componentBean, SdmxBeanRetrievalManager retrievalManager, SuperBeans existingBeans) {
        if (existingBeans == null) {
            existingBeans = new SuperBeansImpl();
        }
        InMemorySdmxSuperBeanRetrievalManager superBeanRetrievalManager = new InMemorySdmxSuperBeanRetrievalManager(existingBeans);
        ConceptBean conceptBean = null;
        CrossReferenceBean conceptRef = componentBean.getConceptRef();
        LOG.debug("get concept super bean : " + conceptRef);
        MaintainableRefBean conceptSchemeRef = conceptRef.getMaintainableReference();
        String conceptId = conceptRef.getChildReference().getId();
        ConceptSchemeSuperBean csSuperBean = superBeanRetrievalManager.getConceptSchemeSuperBean(conceptSchemeRef);
        if (csSuperBean != null) {
            LOG.debug("check existing concept scheme super bean : " + csSuperBean.getUrn());
            for (ConceptSuperBean concept : csSuperBean.getConcepts()) {
                if (!concept.getId().equals(conceptId)) continue;
                LOG.debug("existing concept super bean found");
                return concept;
            }
        }
        LOG.debug("No existing concept super bean found, build new from concept scheme bean");
        ConceptSchemeBean conceptSchemeBean = retrievalManager.getConceptScheme(conceptSchemeRef);
        if (conceptSchemeBean == null) {
            LOG.error("Could not find concept scheme bean to build concept super bean from : " + conceptSchemeRef);
            throw new ReferenceException(ExceptionCode.REFERENCE_ERROR_UNRESOLVABLE, "Concept Scheme", conceptSchemeRef);
        }
        for (ConceptBean currentConcept : conceptSchemeBean.getItems()) {
            if (!currentConcept.getId().equals(conceptId)) continue;
            conceptBean = currentConcept;
            break;
        }
        if (conceptBean == null) {
            LOG.error("Could not find concept bean to build concept super bean from : " + conceptRef);
            throw new ReferenceException(ExceptionCode.REFERENCE_ERROR_UNRESOLVABLE, "Concept", conceptRef.toString());
        }
        return this.conceptSuperBeanBuilder.build(conceptBean, retrievalManager, existingBeans);
    }
}

