/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.superbeans.impl;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.superbeans.SuperBeans;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.AttributeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DimensionSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.PrimaryMeasureSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.datastructure.DataStructureSuperBeanImpl;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.AttributeSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.DimensionSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.PrimaryMeasureSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.StructureBuilderImpl;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.SuperBeansBuilderImpl;
import org.sdmxsource.sdmx.util.beans.container.SuperBeansImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataStructureSuperBeanBuilder
extends StructureBuilderImpl<DataStructureSuperBean, DataStructureBean> {
    private static final Logger LOG = Logger.getLogger(SuperBeansBuilderImpl.class);
    @Autowired
    private AttributeSuperBeanBuilder attributeSuperBeanBuilder;
    @Autowired
    private DimensionSuperBeanBuilder dimensionSuperBeanBuilder;
    @Autowired
    private PrimaryMeasureSuperBeanBuilder primaryMeasureSuperBeanBuilder;

    @Override
    public DataStructureSuperBean build(DataStructureBean buildFrom, SdmxBeanRetrievalManager retrievalManager, SuperBeans existingBeans) {
        if (existingBeans == null) {
            existingBeans = new SuperBeansImpl();
        }
        LOG.debug("Build KeyFamilySuperBean SuperBean");
        ArrayList<AttributeSuperBean> attributes = new ArrayList<AttributeSuperBean>();
        ArrayList<DimensionSuperBean> dimensions = new ArrayList<DimensionSuperBean>();
        for (DimensionBean currentDimension : buildFrom.getDimensions(new SDMX_STRUCTURE_TYPE[0])) {
            LOG.debug("Build Dimension: " + currentDimension.getUrn());
            dimensions.add(this.dimensionSuperBeanBuilder.build(currentDimension, retrievalManager, existingBeans));
        }
        for (AttributeBean currentAttribute : buildFrom.getAttributes()) {
            LOG.debug("Build Attribute: " + currentAttribute.getUrn());
            attributes.add(this.attributeSuperBeanBuilder.build(currentAttribute, retrievalManager, existingBeans));
        }
        PrimaryMeasureSuperBean primaryMeasure = null;
        if (buildFrom.getPrimaryMeasure() != null) {
            LOG.debug("Build Measure: " + buildFrom.getPrimaryMeasure().getUrn());
            primaryMeasure = this.primaryMeasureSuperBeanBuilder.build(buildFrom.getPrimaryMeasure(), retrievalManager, existingBeans);
        }
        return new DataStructureSuperBeanImpl(buildFrom, dimensions, attributes, primaryMeasure);
    }
}

