/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.superbeans.impl;

import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.superbeans.SuperBeans;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataflowSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.registry.ProvisionAgreementSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.registry.ProvisionAgreementSuperBeanImpl;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.DataflowSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.StructureBuilderImpl;
import org.sdmxsource.sdmx.structureretrieval.manager.InMemorySdmxSuperBeanRetrievalManager;
import org.sdmxsource.sdmx.util.beans.container.SuperBeansImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProvisionSuperBeanBuilder
extends StructureBuilderImpl<ProvisionAgreementSuperBean, ProvisionAgreementBean> {
    private static final Logger LOG = Logger.getLogger(ProvisionSuperBeanBuilder.class);
    @Autowired
    private DataflowSuperBeanBuilder dataflowSuperBeanBuilder;

    @Override
    public ProvisionAgreementSuperBean build(ProvisionAgreementBean buildFrom, SdmxBeanRetrievalManager retrievalManager, SuperBeans existingBeans) {
        DataProviderSchemeBean dataproviderScheme;
        if (existingBeans == null) {
            existingBeans = new SuperBeansImpl();
        }
        InMemorySdmxSuperBeanRetrievalManager superBeanRetrievalManager = new InMemorySdmxSuperBeanRetrievalManager(existingBeans);
        MaintainableRefBean dataflowRef = buildFrom.getStructureUseage().getMaintainableReference();
        LOG.debug("Build provision, resolve dataflow ref: " + dataflowRef);
        DataflowSuperBean dataflowSuperBean = superBeanRetrievalManager.getDataflowSuperBean(dataflowRef);
        if (dataflowSuperBean == null) {
            LOG.debug("Dataflow ref super bean not found, build new: " + dataflowRef);
            DataflowBean dataflow = retrievalManager.getDataflow(dataflowRef);
            if (dataflow == null) {
                throw new ValidationException("Error creating Provision Agreement SuperBean '" + buildFrom.getUrn() + "'.  Dataflow reference not found :" + buildFrom.getStructureUseage().getTargetUrn());
            }
            dataflowSuperBean = this.dataflowSuperBeanBuilder.build(dataflow, retrievalManager, existingBeans);
            existingBeans.addDataflow(dataflowSuperBean);
        }
        if ((dataproviderScheme = retrievalManager.getDataProviderSchemeBean(buildFrom.getDataproviderRef().getMaintainableReference())) == null) {
            throw new ValidationException("Error creating Provision Agreement SuperBean '" + buildFrom.getUrn() + "'.  Data Provider Scheme could not be found:" + buildFrom.getDataproviderRef().getMaintainableUrn());
        }
        DataProviderBean dataProvider = null;
        String targetUrn = buildFrom.getDataproviderRef().getTargetUrn();
        for (DataProviderBean currentDataProvider : dataproviderScheme.getItems()) {
            if (!currentDataProvider.getUrn().equals(targetUrn)) continue;
            dataProvider = currentDataProvider;
        }
        if (dataProvider == null) {
            throw new ValidationException("Error creating Provision Agreement SuperBean '" + buildFrom.getUrn() + "'.  Data Provider could not be found in scheme:" + targetUrn);
        }
        return new ProvisionAgreementSuperBeanImpl(buildFrom, dataflowSuperBean, dataProvider);
    }
}

