/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v21;

import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v21.common.MaintainableReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.RefBaseType;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.SubmissionResultType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.SubmitStructureResponseType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.SubmittedStructureType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v21.AbstractResponseBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v21.V2_1Helper;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.StructureHeaderXmlBeanBuilder;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubmitStructureResponseBuilderV2_1
extends AbstractResponseBuilder {
    @Autowired
    private StructureHeaderXmlBeanBuilder headerXmlBeansBuilder;

    public RegistryInterfaceDocument buildErrorResponse(Throwable th, StructureReferenceBean errorBean) throws BuilderException {
        if (errorBean == null) {
            throw new BuilderException(th, "Registry could not determine Maintainable Artefact in error");
        }
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        SubmitStructureResponseType returnType = regInterface.addNewSubmitStructureResponse();
        V2_1Helper.setHeader(regInterface);
        this.addSubmissionResult(returnType, errorBean, th);
        return responseType;
    }

    public RegistryInterfaceDocument buildSuccessResponse(SdmxBeans beans) throws BuilderException {
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        SubmitStructureResponseType returnType = regInterface.addNewSubmitStructureResponse();
        regInterface.setHeader(this.headerXmlBeansBuilder.build(beans.getHeader()));
        this.processMaintainables(returnType, beans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]));
        return responseType;
    }

    private void processMaintainables(SubmitStructureResponseType returnType, Set<MaintainableBean> maints) {
        for (MaintainableBean maint : maints) {
            this.addSubmissionResult(returnType, maint.asReference(), null);
        }
    }

    private void addSubmissionResult(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        SubmissionResultType submissionResult = returnType.addNewSubmissionResult();
        this.addStatus(submissionResult.addNewStatusMessage(), th);
        SubmittedStructureType submittedStructure = submissionResult.addNewSubmittedStructure();
        MaintainableReferenceType refType = submittedStructure.addNewMaintainableObject();
        if (ObjectUtil.validString(sRef.getMaintainableUrn())) {
            refType.setURN(sRef.getMaintainableUrn());
        } else {
            RefBaseType ref = refType.addNewRef();
            MaintainableRefBean mRef = sRef.getMaintainableReference();
            if (ObjectUtil.validString(mRef.getAgencyId())) {
                ref.setAgencyID(mRef.getAgencyId());
            }
            if (ObjectUtil.validString(mRef.getMaintainableId())) {
                ref.setAgencyID(mRef.getMaintainableId());
            }
            if (ObjectUtil.validString(mRef.getVersion())) {
                ref.setAgencyID(mRef.getVersion());
            }
        }
    }
}

