/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategoryIDType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategoryRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataflowType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamilyRefType;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.IdentifiableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AbstractBuilder;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service(value="DataflowXmlBeanBuilderV2")
public class DataflowXmlBeanBuilder
extends AbstractBuilder {
    public DataflowType build(DataflowBean buildFrom, Set<CategorisationBean> categorisations) throws BuilderException {
        DataflowType builtObj = DataflowType.Factory.newInstance();
        if (this.validString(buildFrom.getAgencyId())) {
            builtObj.setAgencyID(buildFrom.getAgencyId());
        }
        if (this.validString(buildFrom.getId())) {
            builtObj.setId(buildFrom.getId());
        }
        if (buildFrom.getUri() != null) {
            builtObj.setUri(buildFrom.getUri().toString());
        } else if (buildFrom.getStructureURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        } else if (buildFrom.getServiceURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        }
        if (this.validString(buildFrom.getUrn())) {
            builtObj.setUrn(buildFrom.getUrn());
        }
        if (this.validString(buildFrom.getVersion())) {
            builtObj.setVersion(buildFrom.getVersion());
        }
        if (buildFrom.getStartDate() != null) {
            builtObj.setValidFrom(buildFrom.getStartDate().getDate());
        }
        if (buildFrom.getEndDate() != null) {
            builtObj.setValidTo(buildFrom.getEndDate().getDate());
        }
        if (this.validCollection(buildFrom.getNames())) {
            builtObj.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            builtObj.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (this.hasAnnotations(buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType(buildFrom));
        }
        if (buildFrom.isExternalReference().isSet()) {
            builtObj.setIsExternalReference(buildFrom.isExternalReference().isTrue());
        }
        if (buildFrom.isFinal().isSet()) {
            builtObj.setIsFinal(buildFrom.isFinal().isTrue());
        }
        if (ObjectUtil.validCollection(categorisations)) {
            for (CategorisationBean currentCategoryRef : categorisations) {
                CategoryRefType categoryRefType = builtObj.addNewCategoryRef();
                CrossReferenceBean refBean = currentCategoryRef.getCategoryReference();
                if (refBean != null) {
                    MaintainableRefBean mRef = refBean.getMaintainableReference();
                    if (this.validString(mRef.getAgencyId())) {
                        categoryRefType.setCategorySchemeAgencyID(mRef.getAgencyId());
                    }
                    if (this.validString(mRef.getMaintainableId())) {
                        categoryRefType.setCategorySchemeID(mRef.getMaintainableId());
                    }
                    if (this.validString(mRef.getVersion())) {
                        categoryRefType.setCategorySchemeVersion(mRef.getVersion());
                    }
                }
                CategoryIDType idType = null;
                IdentifiableRefBean childRef = refBean.getChildReference();
                int i = 0;
                while (childRef != null) {
                    idType = i == 0 ? categoryRefType.addNewCategoryID() : idType.addNewCategoryID();
                    idType.setID(childRef.getId());
                    childRef = childRef.getChildReference();
                    ++i;
                }
                if (!this.validString(refBean.getTargetUrn())) continue;
                categoryRefType.setURN(refBean.getTargetUrn());
            }
        }
        if (buildFrom.getDataStructureRef() != null) {
            KeyFamilyRefType kfRType = builtObj.addNewKeyFamilyRef();
            CrossReferenceBean kfRef = buildFrom.getDataStructureRef();
            MaintainableRefBean refBean = kfRef.getMaintainableReference();
            if (this.validString(refBean.getAgencyId())) {
                kfRType.setKeyFamilyAgencyID(refBean.getAgencyId());
            }
            if (this.validString(refBean.getMaintainableId())) {
                kfRType.setKeyFamilyID(refBean.getMaintainableId());
            }
            if (this.validString(refBean.getVersion())) {
                kfRType.setVersion(refBean.getVersion());
            }
            if (this.validString(kfRef.getTargetUrn())) {
                kfRType.setURN(kfRef.getTargetUrn());
            }
        }
        return builtObj;
    }
}

