/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import java.util.HashSet;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v20.message.HeaderType;
import org.sdmx.resources.sdmxml.schemas.v20.message.StructureDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.StructureType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategorySchemeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategorySchemesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodeListType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodeListsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptSchemeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataflowType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataflowsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchicalCodelistType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchicalCodelistsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamiliesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamilyType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataStructureDefinitionType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataStructureDefinitionsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataflowType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataflowsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.OrganisationSchemesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ReportingTaxonomiesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ReportingTaxonomyType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.StructureSetType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.StructureSetsType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.V2Helper;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.CategorySchemeXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.CodelistXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.ConceptSchemeXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.ConceptXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.DataStructureXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.DataflowXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.HierarchicalCodelistXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.MetadataStructureDefinitionXmlBeansBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.MetadataflowXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.OrganisationSchemeXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.ProcessXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.ReportingTaxonomyXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.StructureHeaderXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.StructureSetXmlBeanBuilder;
import org.sdmxsource.sdmx.util.beans.MaintainableUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="StructureXmlBeanBuilderV2")
public class StructureXmlBeanBuilder
implements Builder<StructureDocument, SdmxBeans> {
    @Autowired
    private CategorySchemeXmlBeanBuilder categorySchemeXmlBeanBuilder;
    @Autowired
    private CodelistXmlBeanBuilder codelistXmlBeanBuilder;
    @Autowired
    private ConceptSchemeXmlBeanBuilder conceptSchemeXmlBeanBuilder;
    @Autowired
    private ConceptXmlBeanBuilder conceptXmlBeanBuilder;
    @Autowired
    private DataflowXmlBeanBuilder dataflowXmlBeanBuilder;
    @Autowired
    private HierarchicalCodelistXmlBeanBuilder hierarchicalCodelistXmlBeanBuilder;
    @Autowired
    private DataStructureXmlBeanBuilder dataStructureXmlBeanBuilder;
    @Autowired
    private MetadataflowXmlBeanBuilder metadataflowXmlBeanBuilder;
    @Autowired
    private MetadataStructureDefinitionXmlBeansBuilder metadataStructureDefinitionXmlBeansBuilder;
    @Autowired
    private OrganisationSchemeXmlBeanBuilder organisationSchemeXmlBeanBuilder;
    @Autowired
    private ProcessXmlBeanBuilder processXmlBeanBuilder;
    @Autowired
    private ReportingTaxonomyXmlBeanBuilder reportingTaxonomyXmlBeanBuilder;
    @Autowired
    private StructureSetXmlBeanBuilder structureSetXmlBeanBuilder;
    @Autowired
    private StructureHeaderXmlBeanBuilder structureHeaderXmlBeanBuilder;

    @Override
    public StructureDocument build(SdmxBeans buildFrom) throws BuilderException {
        StructureDocument doc = StructureDocument.Factory.newInstance();
        StructureType returnType = doc.addNewStructure();
        HeaderType headerType = null;
        if (buildFrom.getHeader() != null) {
            headerType = this.structureHeaderXmlBeanBuilder.build(buildFrom.getHeader());
            returnType.setHeader(headerType);
        } else {
            headerType = returnType.addNewHeader();
            V2Helper.setHeader(headerType, buildFrom);
        }
        Set<CategorisationBean> categorisations = buildFrom.getCategorisations();
        if (buildFrom.getCategorySchemes().size() > 0) {
            CategorySchemesType catSchemesType = returnType.addNewCategorySchemes();
            for (CategorySchemeBean categorySchemeBean : buildFrom.getCategorySchemes()) {
                HashSet<CategorisationBean> matchingCategorisations = new HashSet<CategorisationBean>();
                for (CategorisationBean cat : categorisations) {
                    if (cat.isStub() || !MaintainableUtil.match(categorySchemeBean, cat.getCategoryReference())) continue;
                    matchingCategorisations.add(cat);
                }
                catSchemesType.getCategorySchemeList().add(this.build(categorySchemeBean, categorisations));
            }
        }
        if (buildFrom.getCodelists().size() > 0) {
            CodeListsType codeListsType = returnType.addNewCodeLists();
            for (CodelistBean codelistBean : buildFrom.getCodelists()) {
                codeListsType.getCodeListList().add(this.build(codelistBean));
            }
        }
        if (buildFrom.getConceptSchemes().size() > 0) {
            ConceptsType conceptsType = returnType.addNewConcepts();
            for (ConceptSchemeBean conceptSchemeBean : buildFrom.getConceptSchemes()) {
                conceptsType.getConceptSchemeList().add(this.build(conceptSchemeBean));
            }
        }
        if (buildFrom.getDataflows().size() > 0) {
            DataflowsType dataflowsType = returnType.addNewDataflows();
            for (DataflowBean dataflowBean : buildFrom.getDataflows()) {
                dataflowsType.getDataflowList().add(this.build(dataflowBean, this.getCategorisations(dataflowBean, categorisations)));
            }
        }
        if (buildFrom.getHierarchicalCodelists().size() > 0) {
            HierarchicalCodelistsType hierarchicalCodelistsType = returnType.addNewHierarchicalCodelists();
            for (HierarchicalCodelistBean hierarchicalCodelistBean : buildFrom.getHierarchicalCodelists()) {
                hierarchicalCodelistsType.getHierarchicalCodelistList().add(this.build(hierarchicalCodelistBean));
            }
        }
        if (buildFrom.getDataStructures().size() > 0) {
            KeyFamiliesType keyFamiliesType = returnType.addNewKeyFamilies();
            for (DataStructureBean dataStructureBean : buildFrom.getDataStructures()) {
                keyFamiliesType.getKeyFamilyList().add(this.build(dataStructureBean));
            }
        }
        if (buildFrom.getMetadataflows().size() > 0) {
            MetadataflowsType metadataflowsType = returnType.addNewMetadataflows();
            for (MetadataFlowBean metadataFlowBean : buildFrom.getMetadataflows()) {
                metadataflowsType.getMetadataflowList().add(this.build(metadataFlowBean, this.getCategorisations(metadataFlowBean, categorisations)));
            }
        }
        if (buildFrom.getMetadataStructures().size() > 0) {
            MetadataStructureDefinitionsType msdsType = returnType.addNewMetadataStructureDefinitions();
            for (MetadataStructureDefinitionBean metadataStructureDefinitionBean : buildFrom.getMetadataStructures()) {
                msdsType.getMetadataStructureDefinitionList().add(this.build(metadataStructureDefinitionBean));
            }
        }
        if (buildFrom.getOrganisationUnitSchemes().size() > 0) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME.getType());
        }
        OrganisationSchemesType orgSchemesType = null;
        if (buildFrom.getAgenciesSchemes().size() > 0) {
            orgSchemesType = returnType.addNewOrganisationSchemes();
            for (AgencySchemeBean agencySchemeBean : buildFrom.getAgenciesSchemes()) {
                orgSchemesType.getOrganisationSchemeList().add(this.organisationSchemeXmlBeanBuilder.build(agencySchemeBean));
            }
        }
        if (buildFrom.getDataConsumerSchemes().size() > 0) {
            if (orgSchemesType == null) {
                orgSchemesType = returnType.addNewOrganisationSchemes();
            }
            for (DataConsumerSchemeBean dataConsumerSchemeBean : buildFrom.getDataConsumerSchemes()) {
                orgSchemesType.getOrganisationSchemeList().add(this.organisationSchemeXmlBeanBuilder.build(dataConsumerSchemeBean));
            }
        }
        if (buildFrom.getDataProviderSchemes().size() > 0) {
            if (orgSchemesType == null) {
                orgSchemesType = returnType.addNewOrganisationSchemes();
            }
            for (DataProviderSchemeBean dataProviderSchemeBean : buildFrom.getDataProviderSchemes()) {
                orgSchemesType.getOrganisationSchemeList().add(this.organisationSchemeXmlBeanBuilder.build(dataProviderSchemeBean));
            }
        }
        if (buildFrom.getProcesses().size() > 0) {
            ProcessesType processesType = returnType.addNewProcesses();
            for (ProcessBean processBean : buildFrom.getProcesses()) {
                processesType.getProcessList().add(this.build(processBean));
            }
        }
        if (buildFrom.getStructureSets().size() > 0) {
            StructureSetsType structureSetsType = returnType.addNewStructureSets();
            for (StructureSetBean structureSetBean : buildFrom.getStructureSets()) {
                structureSetsType.getStructureSetList().add(this.build(structureSetBean));
            }
        }
        if (buildFrom.getReportingTaxonomys().size() > 0) {
            ReportingTaxonomiesType reportingTaxonomiesType = returnType.addNewReportingTaxonomies();
            for (ReportingTaxonomyBean reportingTaxonomyBean : buildFrom.getReportingTaxonomys()) {
                reportingTaxonomiesType.getReportingTaxonomyList().add(this.build(reportingTaxonomyBean));
            }
        }
        if (buildFrom.getAttachmentConstraints().size() > 0) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "Attachment Constraint at SMDX v2.0 - please use SDMX v2.1");
        }
        if (buildFrom.getContentConstraintBeans().size() > 0) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "Content Constraint at SMDX v2.0 - please use SDMX v2.1");
        }
        if (buildFrom.getMetadataStructures().size() > 0) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "Metadata Structure Definition at SMDX v2.0 - please use SDMX v2.1");
        }
        return doc;
    }

    private Set<CategorisationBean> getCategorisations(MaintainableBean maint, Set<CategorisationBean> categorisations) {
        HashSet<CategorisationBean> returnSet = new HashSet<CategorisationBean>();
        if (maint.isStub()) {
            return returnSet;
        }
        for (CategorisationBean cat : categorisations) {
            if (cat.isStub() || cat.getStructureReference().getTargetReference() != maint.getStructureType() || !MaintainableUtil.match(maint, cat.getStructureReference())) continue;
            returnSet.add(cat);
        }
        return returnSet;
    }

    public XmlObject build(MaintainableBean bean, Set<CategorisationBean> categorisations) {
        switch (bean.getStructureType()) {
            case CATEGORY_SCHEME: {
                return this.build((CategorySchemeBean)bean, categorisations);
            }
            case CODE_LIST: {
                return this.build((CodelistBean)bean);
            }
            case CONCEPT_SCHEME: {
                return this.build((ConceptSchemeBean)bean);
            }
            case DATAFLOW: {
                return this.build((DataflowBean)bean, categorisations);
            }
            case HIERARCHICAL_CODELIST: {
                return this.build((HierarchicalCodelistBean)bean);
            }
            case DSD: {
                return this.build((DataStructureBean)bean);
            }
            case METADATA_FLOW: {
                return this.build((MetadataFlowBean)bean, categorisations);
            }
            case MSD: {
                return this.build((MetadataStructureDefinitionBean)bean);
            }
            case PROCESS: {
                return this.build((ProcessBean)bean);
            }
            case REPORTING_TAXONOMY: {
                return this.build((ReportingTaxonomyBean)bean);
            }
            case STRUCTURE_SET: {
                return this.build((StructureSetBean)bean);
            }
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, new Object[]{bean.getStructureType()});
    }

    public CategorySchemeType build(CategorySchemeBean bean, Set<CategorisationBean> categorisations) {
        return this.categorySchemeXmlBeanBuilder.build(bean, categorisations);
    }

    @Override
    public CodeListType build(CodelistBean bean) {
        return this.codelistXmlBeanBuilder.build(bean);
    }

    @Override
    public ConceptSchemeType build(ConceptSchemeBean bean) {
        return this.conceptSchemeXmlBeanBuilder.build(bean);
    }

    @Override
    public ConceptType build(ConceptBean bean) {
        return this.conceptXmlBeanBuilder.build(bean);
    }

    public DataflowType build(DataflowBean bean, Set<CategorisationBean> categorisations) {
        return this.dataflowXmlBeanBuilder.build(bean, categorisations);
    }

    @Override
    public HierarchicalCodelistType build(HierarchicalCodelistBean bean) {
        return this.hierarchicalCodelistXmlBeanBuilder.build(bean);
    }

    @Override
    public KeyFamilyType build(DataStructureBean bean) {
        return this.dataStructureXmlBeanBuilder.build(bean);
    }

    public MetadataflowType build(MetadataFlowBean bean, Set<CategorisationBean> categorisations) {
        return this.metadataflowXmlBeanBuilder.build(bean, categorisations);
    }

    @Override
    public MetadataStructureDefinitionType build(MetadataStructureDefinitionBean bean) {
        return this.metadataStructureDefinitionXmlBeansBuilder.build(bean);
    }

    @Override
    public ProcessType build(ProcessBean bean) {
        return this.processXmlBeanBuilder.build(bean);
    }

    @Override
    public ReportingTaxonomyType build(ReportingTaxonomyBean bean) {
        return this.reportingTaxonomyXmlBeanBuilder.build(bean);
    }

    @Override
    public StructureSetType build(StructureSetBean bean) {
        return this.structureSetXmlBeanBuilder.build(bean);
    }
}

