/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21;

import org.sdmx.resources.sdmxml.schemas.v21.common.ComponentValueSetType;
import org.sdmx.resources.sdmxml.schemas.v21.common.ContentConstraintTypeCodeType;
import org.sdmx.resources.sdmxml.schemas.v21.common.CubeRegionType;
import org.sdmx.resources.sdmxml.schemas.v21.common.ReferencePeriodType;
import org.sdmx.resources.sdmxml.schemas.v21.common.SimpleValueType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ContentConstraintType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ReleaseCalendarType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.CubeRegionBean;
import org.sdmxsource.sdmx.api.model.beans.registry.KeyValues;
import org.sdmxsource.sdmx.api.model.beans.registry.ReferencePeriodBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ReleaseCalendarBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.ConstraintBeanAssembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.TimeRangeXmlAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContentConstraintXmlBeanBuilder
extends ConstraintBeanAssembler
implements Builder<ContentConstraintType, ContentConstraintBean> {
    @Autowired
    private TimeRangeXmlAssembler timeRangeXmlAssembler;

    @Override
    public ContentConstraintType build(ContentConstraintBean buildFrom) throws BuilderException {
        ContentConstraintType returnType = ContentConstraintType.Factory.newInstance();
        super.assemble(returnType, buildFrom);
        if (buildFrom.isDefiningActualDataPresent()) {
            returnType.setType(ContentConstraintTypeCodeType.ACTUAL);
        } else {
            returnType.setType(ContentConstraintTypeCodeType.ALLOWED);
        }
        if (buildFrom.getIncludedCubeRegion() != null) {
            this.buildCubeRegion(returnType.addNewCubeRegion(), buildFrom.getIncludedCubeRegion(), true);
        }
        if (buildFrom.getExcludedCubeRegion() != null) {
            this.buildCubeRegion(returnType.addNewCubeRegion(), buildFrom.getExcludedCubeRegion(), false);
        }
        if (buildFrom.getReleaseCalendar() != null) {
            ReleaseCalendarBean calBean = buildFrom.getReleaseCalendar();
            ReleaseCalendarType calType = returnType.addNewReleaseCalendar();
            calType.setOffset(calBean.getOffset());
            calType.setPeriodicity(calBean.getPeriodicity());
            calType.setTolerance(calBean.getTolerance());
        }
        if (buildFrom.getReferencePeriod() != null) {
            ReferencePeriodBean refPeriodBean = buildFrom.getReferencePeriod();
            ReferencePeriodType refPeriodType = returnType.addNewReferencePeriod();
            if (refPeriodBean.getStartTime() != null) {
                refPeriodType.setStartTime(refPeriodBean.getStartTime().getDateAsCalendar());
            }
            if (refPeriodBean.getEndTime() != null) {
                refPeriodType.setEndTime(refPeriodBean.getEndTime().getDateAsCalendar());
            }
        }
        return returnType;
    }

    private void buildCubeRegion(CubeRegionType cubeRegionType, CubeRegionBean cubeRegionBean, boolean isIncluded) {
        SimpleValueType simpleValueType;
        ComponentValueSetType cvst;
        cubeRegionType.setInclude(isIncluded);
        for (KeyValues currentKv : cubeRegionBean.getKeyValues()) {
            cvst = cubeRegionType.addNewKeyValue();
            cvst.setId(currentKv.getId());
            if (currentKv.getTimeRange() != null) {
                this.timeRangeXmlAssembler.assemble(cvst.addNewTimeRange(), currentKv.getTimeRange());
            }
            for (String value : currentKv.getValues()) {
                simpleValueType = cvst.addNewValue();
                simpleValueType.setStringValue(value);
                if (!currentKv.isCascadeValue(value)) continue;
                simpleValueType.setCascadeValues(true);
            }
        }
        for (KeyValues currentKv : cubeRegionBean.getAttributeValues()) {
            cvst = cubeRegionType.addNewAttribute();
            cvst.setId(currentKv.getId());
            if (currentKv.getTimeRange() != null) {
                this.timeRangeXmlAssembler.assemble(cvst.addNewTimeRange(), currentKv.getTimeRange());
            }
            for (String value : currentKv.getValues()) {
                simpleValueType = cvst.addNewValue();
                simpleValueType.setStringValue(value);
                if (!currentKv.isCascadeValue(value)) continue;
                simpleValueType.setCascadeValues(true);
            }
        }
    }
}

