/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21;

import org.apache.xmlbeans.XmlAnyURI;
import org.sdmx.resources.sdmxml.schemas.v21.registry.DataSourceType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.QueryableDataSourceType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.RegistrationType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.beans.base.DataSourceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.AbstractBeanAssembler;
import org.springframework.stereotype.Service;

@Service
public class RegistrationXmlBeanBuilder
extends AbstractBeanAssembler
implements Builder<RegistrationType, RegistrationBean> {
    @Override
    public RegistrationType build(RegistrationBean buildFrom) throws BuilderException {
        RegistrationType returnType = RegistrationType.Factory.newInstance();
        returnType.setId(buildFrom.getId());
        if (buildFrom.getIndexAttributes().isSet()) {
            returnType.setIndexAttributes(buildFrom.getIndexAttributes().isTrue());
        }
        if (buildFrom.getIndexDataset().isSet()) {
            returnType.setIndexDataSet(buildFrom.getIndexDataset().isTrue());
        }
        if (buildFrom.getIndexReportingPeriod().isSet()) {
            returnType.setIndexReportingPeriod(buildFrom.getIndexReportingPeriod().isTrue());
        }
        if (buildFrom.getIndexTimeSeries().isSet()) {
            returnType.setIndexTimeSeries(buildFrom.getIndexTimeSeries().isTrue());
        }
        super.setReference(returnType.addNewProvisionAgreement().addNewRef(), buildFrom.getProvisionAgreementRef());
        if (buildFrom.getDataSource() != null) {
            DataSourceType dataSourceType = returnType.addNewDatasource();
            DataSourceBean dataSource = buildFrom.getDataSource();
            String dataUrl = dataSource.getDataUrl().toString();
            if (dataSource.isSimpleDatasource()) {
                XmlAnyURI simpleDataSource = dataSourceType.addNewSimpleDataSource();
                simpleDataSource.setStringValue(dataUrl);
            } else {
                QueryableDataSourceType queryableDataSource = dataSourceType.addNewQueryableDataSource();
                queryableDataSource.setDataURL(dataUrl);
                if (dataSource.getWSDLUrl() != null) {
                    queryableDataSource.setWADLURL(dataSource.getWSDLUrl().toString());
                }
                if (dataSource.getWadlUrl() != null) {
                    queryableDataSource.setWSDLURL(dataSource.getWadlUrl().toString());
                }
                if (dataSource.isRESTDatasource()) {
                    queryableDataSource.setIsRESTDatasource(true);
                    queryableDataSource.setIsWebServiceDatasource(false);
                } else if (dataSource.isWebServiceDatasource()) {
                    queryableDataSource.setIsWebServiceDatasource(true);
                    queryableDataSource.setIsRESTDatasource(false);
                }
            }
        }
        if (buildFrom.getLastUpdated() != null) {
            returnType.setLastUpdated(buildFrom.getLastUpdated().getDateAsCalendar());
        }
        if (buildFrom.getValidFrom() != null) {
            returnType.setValidFrom(buildFrom.getValidFrom().getDateAsCalendar());
        }
        if (buildFrom.getValidTo() != null) {
            returnType.setValidTo(buildFrom.getValidTo().getDateAsCalendar());
        }
        return returnType;
    }
}

