/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers;

import org.sdmx.resources.sdmxml.schemas.v21.common.TimePeriodRangeType;
import org.sdmx.resources.sdmxml.schemas.v21.common.TimeRangeValueType;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.TimeRangeBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.Assembler;
import org.springframework.stereotype.Service;

@Service
public class TimeRangeXmlAssembler
implements Assembler<TimeRangeValueType, TimeRangeBean> {
    @Override
    public void assemble(TimeRangeValueType assembleInto, TimeRangeBean assembleFrom) throws BuilderException {
        if (assembleFrom.isRange()) {
            this.setDate(assembleInto.addNewStartPeriod(), assembleFrom.getStartDate(), assembleFrom.isStartInclusive());
            this.setDate(assembleInto.addNewEndPeriod(), assembleFrom.getEndDate(), assembleFrom.isEndInclusive());
        } else if (assembleFrom.getStartDate() != null) {
            this.setDate(assembleInto.addNewBeforePeriod(), assembleFrom.getStartDate(), assembleFrom.isStartInclusive());
        } else {
            this.setDate(assembleInto.addNewAfterPeriod(), assembleFrom.getEndDate(), assembleFrom.isEndInclusive());
        }
    }

    private void setDate(TimePeriodRangeType tpr, SdmxDate d, boolean inclusive) {
        tpr.setIsInclusive(inclusive);
        tpr.setStringValue(d.getDateInSdmxFormat());
    }
}

