/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.engine.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sdmxsource.sdmx.api.engine.StructureWritingEngine;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;

public abstract class AbstractWritingEngine
implements StructureWritingEngine {
    private OutputStream outputStream;
    private boolean prettyfy;

    public AbstractWritingEngine(OutputStream outputStream, boolean prettyfy) {
        this.outputStream = outputStream;
        this.prettyfy = prettyfy;
    }

    @Override
    public void writeStructure(MaintainableBean bean) {
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiable(bean);
        this.writeStructures(beans);
    }

    @Override
    public void writeStructures(SdmxBeans beans) {
        XmlObject docV21 = this.build(beans);
        try {
            if (this.prettyfy) {
                XmlOptions options = new XmlOptions();
                options.setSaveAggressiveNamespaces();
                options.setSavePrettyPrint();
                docV21.save(this.outputStream, options);
            } else {
                docV21.save(this.outputStream);
            }
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract XmlObject build(SdmxBeans var1);
}

