/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.impl;

import java.net.URI;
import java.net.URL;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ReferenceException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.manager.parse.StructureParsingManager;
import org.sdmxsource.sdmx.api.model.ResolutionSettings;
import org.sdmxsource.sdmx.api.model.StructureWorkspace;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.structureparser.manager.ExternalReferenceManager;
import org.sdmxsource.sdmx.util.beans.MaintainableUtil;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.util.io.ReadableDataLocationTmp;
import org.sdmxsource.util.io.URIUtil;
import org.sdmxsource.util.log.LoggingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalReferenceManagerImpl
implements ExternalReferenceManager {
    private static final Logger LOG = Logger.getLogger(ExternalReferenceManagerImpl.class);
    @Autowired
    private StructureParsingManager structureParsingManager;
    private static final ResolutionSettings retriervalSettings = new ResolutionSettings(ResolutionSettings.RESOLVE_EXTERNAL_SETTING.DO_NOT_RESOLVE, ResolutionSettings.RESOLVE_CROSS_REFERENCES.DO_NOT_RESOLVE, 0);

    @Override
    public SdmxBeans resolveExternalReferences(SdmxBeans structures, boolean isSubstitute, boolean isLienient) throws ValidationException, ReferenceException {
        LOG.debug("resolveExternalReferences request");
        SdmxBeansImpl returnBeans = new SdmxBeansImpl();
        if (structures == null) {
            return returnBeans;
        }
        this.resolveBeans(structures.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]), returnBeans, isLienient);
        if (isSubstitute) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("substititing " + returnBeans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]).size() + " externally resolved beans");
            }
            structures.merge(returnBeans);
        }
        return returnBeans;
    }

    private void resolveBeans(Set<? extends MaintainableBean> maintinableBeans, SdmxBeans returnBeans, boolean isLienient) {
        for (MaintainableBean maintainableBean : maintinableBeans) {
            if (!maintainableBean.isExternalReference().isTrue()) continue;
            SdmxBeans retrievedStructures = this.resolve(maintainableBean, isLienient);
            if (retrievedStructures != null) {
                MaintainableBean resolvedReference = MaintainableUtil.resolveReference(retrievedStructures.getCodelists(), maintainableBean.asReference());
                if (resolvedReference == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("can not resolve reference, not found in returned beans ");
                    }
                    this.addException(maintainableBean, isLienient);
                    continue;
                }
                returnBeans.addIdentifiable(resolvedReference);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("can not resolve reference, not beans returnd from URL ");
        }
    }

    private SdmxBeans resolve(MaintainableBean maintBean, boolean isLienient) {
        block12: {
            URI uri = null;
            try {
                URL urlLocation = maintBean.getStructureURL();
                if (urlLocation == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("can not resolve reference, StructureURL not set ");
                    }
                    this.addException(maintBean, isLienient);
                    break block12;
                }
                ReadableDataLocationTmp dataLocation = new ReadableDataLocationTmp(urlLocation);
                StructureWorkspace sw = this.structureParsingManager.parseStructures(dataLocation, retriervalSettings, null);
                SdmxBeans sdmxBeans = sw.getStructureBeans(false);
                return sdmxBeans;
            }
            catch (ReferenceException refEx) {
                if (isLienient) {
                    this.addException(maintBean, refEx.getMessage());
                    break block12;
                }
                throw refEx;
            }
            catch (Throwable th) {
                if (isLienient) {
                    this.addException(maintBean, th.getMessage());
                    break block12;
                }
                throw new RuntimeException(th);
            }
            finally {
                if (uri != null) {
                    URIUtil.closeUri(uri);
                    URIUtil.deleteUri(uri);
                }
            }
        }
        return null;
    }

    private void addException(MaintainableBean maintBean, boolean isLienient) {
        if (isLienient) {
            if (maintBean.getStructureURL() == null) {
                this.addException(maintBean, "External location not set");
            } else {
                this.addException(maintBean, "External location `" + maintBean.getStructureURL().toString() + "` does not contain structure : " + maintBean.getUrn());
            }
        } else {
            if (maintBean.getStructureURL() == null) {
                throw new ReferenceException(ExceptionCode.EXTERNAL_STRUCTURE_NOT_FOUND_AT_URI, maintBean.getUrn(), "NOT SET");
            }
            throw new ReferenceException(ExceptionCode.EXTERNAL_STRUCTURE_NOT_FOUND_AT_URI, maintBean.getUrn(), maintBean.getStructureURL().toString());
        }
    }

    private void addException(MaintainableBean maintBean, String message) {
        LoggingUtil.error(LOG, message);
    }

    public void setStructureParsingManager(StructureParsingManager structureParsingManager) {
        this.structureParsingManager = structureParsingManager;
    }
}

