/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.impl;

import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_OUTPUT_FORMAT;
import org.sdmxsource.sdmx.api.engine.StructureWritingEngine;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.manager.output.StructureWritingManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.structureparser.engine.impl.RegistryQueryResponseWritingEngineV2;
import org.sdmxsource.sdmx.structureparser.engine.impl.StructureWritingEngineEDI;
import org.sdmxsource.sdmx.structureparser.engine.impl.StructureWritingEngineV1;
import org.sdmxsource.sdmx.structureparser.engine.impl.StructureWritingEngineV2;
import org.sdmxsource.sdmx.structureparser.engine.impl.StructureWritingEngineV21;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.springframework.stereotype.Service;

@Service
public class StructureWritingManagerImpl
implements StructureWritingManager {
    private static Logger LOG = Logger.getLogger(StructureWritingManagerImpl.class);

    @Override
    public void writeStructures(SdmxBeans beans, STRUCTURE_OUTPUT_FORMAT outputFormat, OutputStream out) {
        LOG.debug("write structures in format :" + (Object)((Object)outputFormat));
        SDMX_SCHEMA schemaVersion = outputFormat.getOutputVersion();
        if (!outputFormat.isQueryResponse() && !outputFormat.isRegistryDocument()) {
            this.getBeanEngine(schemaVersion, out).writeStructures(beans);
            return;
        }
        switch (outputFormat) {
            case CSV: {
                throw new UnsupportedException(new Object[]{"Writing structures as  " + (Object)((Object)outputFormat) + " not currently supported"});
            }
            case EDI: {
                throw new UnsupportedException(new Object[]{"Writing structures as  " + (Object)((Object)outputFormat) + " not currently supported"});
            }
            case SDMX_V21_QUERY_RESPONSE_DOCUMENT: {
                throw new UnsupportedException(new Object[]{"Writing structures as  " + (Object)((Object)outputFormat) + " not currently supported"});
            }
            case SDMX_V21_REGISTRY_SUBMIT_DOCUMENT: {
                throw new UnsupportedException(new Object[]{"Writing structures as  " + (Object)((Object)outputFormat) + " not currently supported"});
            }
            case SDMX_V2_REGISTRY_QUERY_RESPONSE_DOCUMENT: {
                new RegistryQueryResponseWritingEngineV2(out).writeStructures(beans);
                return;
            }
            case SDMX_V2_REGISTRY_SUBMIT_DOCUMENT: {
                throw new UnsupportedException(new Object[]{"Writing structures as  " + (Object)((Object)outputFormat) + " not currently supported"});
            }
        }
    }

    @Override
    public void writeStructure(MaintainableBean bean, HeaderBean header, STRUCTURE_OUTPUT_FORMAT outputFormat, OutputStream out) {
        SdmxBeansImpl beans = new SdmxBeansImpl(header);
        beans.addIdentifiable(bean);
        this.writeStructures(beans, outputFormat, out);
    }

    private StructureWritingEngine getBeanEngine(SDMX_SCHEMA schemaVersion, OutputStream out) {
        switch (schemaVersion) {
            case VERSION_ONE: {
                return new StructureWritingEngineV1(out);
            }
            case VERSION_TWO: {
                return new StructureWritingEngineV2(out);
            }
            case EDI: {
                return new StructureWritingEngineEDI(out);
            }
            case VERSION_TWO_POINT_ONE: {
                return new StructureWritingEngineV21(out);
            }
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, (Object)((Object)schemaVersion) + " - StructureWritingManagerImpl.writeStructure");
    }
}

