/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.parsing.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.QueryMessageDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.QueryMessageDocument;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.data.query.DataQuery;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.RESTDataQueryImpl;
import org.sdmxsource.sdmx.structureparser.builder.query.DataQueryBuilder;
import org.sdmxsource.sdmx.structureparser.manager.parsing.DataQueryParseManager;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.sdmxsource.util.log.LoggingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataQueryParseManagerImpl
implements DataQueryParseManager {
    private Logger log = Logger.getLogger(DataQueryParseManagerImpl.class);
    @Autowired
    private DataQueryBuilder dataQueryBuilder;

    @Override
    public DataQuery parseRESTQuery(String query, SdmxBeanRetrievalManager beanRetrievalManager) {
        if (!query.startsWith("Data/")) {
            throw new ValidationException("Expecting REST Query for Data to start with 'Data/'");
        }
        String[] split = query.split("\\?");
        String queryPrefix = split[0];
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        if (split.length > 1) {
            String[] queryPostFix = split[1].split("=");
            if (queryPostFix.length % 2 != 0) {
                throw new ValidationException("Missing equals '=' in query parameters '" + split[1] + "'");
            }
            int i = 0;
            while (i < queryPostFix.length) {
                queryParameters.put(queryPostFix[i], queryPostFix[i + 1]);
                i += 2;
            }
        }
        RESTDataQueryImpl dataQuery = new RESTDataQueryImpl(queryPrefix.split("/"), queryParameters);
        return this.dataQueryBuilder.buildDataQuery(dataQuery, beanRetrievalManager);
    }

    @Override
    public List<DataQuery> buildDataQuery(ReadableDataLocation dataQueryLocation, SdmxBeanRetrievalManager beanRetrievalManager) {
        this.log.debug("DataParseManagerImpl.buildDataQuery");
        InputStream stream = null;
        try {
            SDMX_SCHEMA schemaVersion = SdmxMessageUtil.getSchemaVersion(dataQueryLocation);
            LoggingUtil.debug(this.log, "Schema Version Determined to be : " + (Object)((Object)schemaVersion));
            stream = dataQueryLocation.getInputStream();
            switch (schemaVersion) {
                case VERSION_ONE: {
                    QueryMessageDocument queryV1 = QueryMessageDocument.Factory.parse(stream);
                    List<DataQuery> list = this.dataQueryBuilder.buildDataQuery(queryV1.getQueryMessage().getQuery(), beanRetrievalManager);
                    return list;
                }
                case VERSION_TWO: {
                    org.sdmx.resources.sdmxml.schemas.v20.message.QueryMessageDocument queryV2 = QueryMessageDocument.Factory.parse(stream);
                    List<DataQuery> list = this.dataQueryBuilder.buildDataQuery(queryV2.getQueryMessage().getQuery(), beanRetrievalManager);
                    return list;
                }
            }
            try {
                throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "buildDataQuery in version " + (Object)((Object)schemaVersion));
            }
            catch (XmlException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

