/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.engine.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.ProvisionBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.structureretrieval.engine.CrossReferenceResolverEngine;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class CrossReferenceResolverEngineImpl
implements CrossReferenceResolverEngine {
    Logger log = Logger.getLogger(CrossReferenceResolverEngineImpl.class);
    private boolean resolveAgencies;
    private Map<IdentifiableBean, Set<IdentifiableBean>> crossReferences = new HashMap<IdentifiableBean, Set<IdentifiableBean>>();
    private Set<MaintainableBean> maintainables = new HashSet<MaintainableBean>();
    private Map<String, AgencyBean> agencies = new HashMap<String, AgencyBean>();

    private void resetMaps() {
        this.crossReferences = new HashMap<IdentifiableBean, Set<IdentifiableBean>>();
        this.maintainables = new HashSet<MaintainableBean>();
        this.agencies = new HashMap<String, AgencyBean>();
    }

    @Override
    public Map<IdentifiableBean, Set<CrossReferenceBean>> getMissingCrossReferences(SdmxBeans beans, int numberLevelsDeep, SdmxBeanRetrievalManager retrievalManager) {
        HashMap<IdentifiableBean, Set<CrossReferenceBean>> returnMap = new HashMap<IdentifiableBean, Set<CrossReferenceBean>>();
        this.resolveReferences(beans, false, numberLevelsDeep, retrievalManager, returnMap);
        return returnMap;
    }

    @Override
    public Set<IdentifiableBean> resolveReferences(ProvisionAgreementBean provision, SdmxBeanRetrievalManager structRetrievalManager) {
        if (structRetrievalManager == null) {
            throw new IllegalArgumentException("StructureRetrievalManager can not be null");
        }
        HashSet<IdentifiableBean> returnSet = new HashSet<IdentifiableBean>();
        if (provision.getStructureUseage() != null) {
            MaintainableBean structureUseage = structRetrievalManager.getMaintainable(provision.getStructureUseage());
            if (structureUseage == null) {
                throw new ReferenceException(ExceptionCode.REFERENCE_ERROR_UNRESOLVABLE, provision.getStructureUseage().getTargetReference().getType(), provision.getStructureUseage());
            }
            returnSet.add(structureUseage);
        }
        if (provision.getDataproviderRef() != null) {
            DataProviderSchemeBean orgScheme = structRetrievalManager.getDataProviderSchemeBean(provision.getDataproviderRef().getMaintainableReference());
            if (orgScheme == null) {
                throw new ReferenceException(ExceptionCode.REFERENCE_ERROR_UNRESOLVABLE, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME.toString(), provision.getDataproviderRef().getMaintainableReference());
            }
            if (!ObjectUtil.validCollection(orgScheme.getItems())) {
                throw new ReferenceException(ExceptionCode.REFERENCE_ERROR_UNRESOLVABLE, SDMX_STRUCTURE_TYPE.DATA_PROVIDER.toString(), provision.getDataproviderRef());
            }
            boolean found = false;
            for (DataProviderBean dpBean : orgScheme.getItems()) {
                if (!dpBean.getId().equals(provision.getDataproviderRef().getChildReference().getId())) continue;
                found = true;
                returnSet.add(orgScheme);
                break;
            }
            if (!found) {
                throw new ReferenceException(ExceptionCode.REFERENCE_ERROR_UNRESOLVABLE, SDMX_STRUCTURE_TYPE.DATA_PROVIDER.toString(), provision.getDataproviderRef());
            }
        }
        return returnSet;
    }

    @Override
    public Map<String, Set<MaintainableBean>> getMissingAgencies(SdmxBeans beans, SdmxBeanRetrievalManager retrievalManager) {
        HashSet<String> agencyIds = new HashSet<String>();
        for (AgencyBean acy : beans.getAgencies()) {
            agencyIds.add(acy.getFullId());
        }
        HashMap<String, Set<MaintainableBean>> returnMap = new HashMap<String, Set<MaintainableBean>>();
        for (MaintainableBean currentMaint : beans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0])) {
            HashSet<MaintainableBean> maintainables;
            String referencedAgencyId = currentMaint.getAgencyId();
            if (agencyIds.contains(referencedAgencyId)) continue;
            if (retrievalManager != null) {
                try {
                    AgencyBean acy = retrievalManager.getAgency(referencedAgencyId);
                    if (acy != null) {
                        agencyIds.add(acy.getFullId());
                        continue;
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
            if ((maintainables = (HashSet<MaintainableBean>)returnMap.get(referencedAgencyId)) == null) {
                maintainables = new HashSet<MaintainableBean>();
                returnMap.put(referencedAgencyId, maintainables);
            }
            maintainables.add(currentMaint);
        }
        return returnMap;
    }

    @Override
    public Set<IdentifiableBean> resolveReferences(RegistrationBean registation, SdmxBeanRetrievalManager structRetrievalManager, ProvisionBeanRetrievalManager provRetrievalManager) {
        HashSet<IdentifiableBean> returnSet = new HashSet<IdentifiableBean>();
        if (registation.getProvisionAgreementRef() != null) {
            if (provRetrievalManager == null) {
                throw new IllegalArgumentException("ProvisionRetrievalManager can not be null");
            }
            ProvisionAgreementBean provision = provRetrievalManager.getProvision(registation);
            if (provision == null) {
                throw new ReferenceException(ExceptionCode.REFERENCE_ERROR_UNRESOLVABLE, SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT.toString(), registation.getProvisionAgreementRef());
            }
            returnSet.add(provision);
        }
        return returnSet;
    }

    @Override
    public Map<IdentifiableBean, Set<IdentifiableBean>> resolveReferences(SdmxBeans beans, boolean resolveAgencies, int numberLevelsDeep, SdmxBeanRetrievalManager retrievalManager) throws ReferenceException {
        return this.resolveReferences(beans, resolveAgencies, numberLevelsDeep, retrievalManager, null);
    }

    private Map<IdentifiableBean, Set<IdentifiableBean>> resolveReferences(SdmxBeans beans, boolean resolveAgencies, int numberLevelsDeep, SdmxBeanRetrievalManager retrievalManager, Map<IdentifiableBean, Set<CrossReferenceBean>> populateMap) throws ReferenceException {
        this.resetMaps();
        this.resolveAgencies = resolveAgencies;
        Map<IdentifiableBean, Set<IdentifiableBean>> returnMap = null;
        int numberBeansLast = 0;
        int numberReferencesLast = 0;
        int numberBeansCurrent = -1;
        int numberReferencesCurrent = -1;
        SdmxBeans allBeans = beans;
        int currentLevel = 1;
        do {
            numberBeansLast = numberBeansCurrent;
            numberReferencesLast = numberReferencesCurrent;
            returnMap = this.resolveReferencesInternal(allBeans, retrievalManager, populateMap);
            numberBeansCurrent = returnMap.size();
            numberReferencesCurrent = this.countValues(returnMap);
            allBeans = new SdmxBeansImpl(beans);
            for (Set<IdentifiableBean> currentBeanSet : returnMap.values()) {
                for (IdentifiableBean currentBean : currentBeanSet) {
                    allBeans.addIdentifiable(currentBean);
                }
            }
        } while (currentLevel != numberLevelsDeep && (numberBeansCurrent != numberBeansLast || numberReferencesCurrent != numberReferencesLast));
        return returnMap;
    }

    @Override
    public Set<IdentifiableBean> resolveReferences(MaintainableBean bean, boolean resolveAgencies, int numberLevelsDeep, SdmxBeanRetrievalManager retrievalManager) throws ReferenceException {
        this.resetMaps();
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiable(bean);
        Map<IdentifiableBean, Set<IdentifiableBean>> references = this.resolveReferences(beans, resolveAgencies, numberLevelsDeep, retrievalManager);
        HashSet<IdentifiableBean> returnSet = new HashSet<IdentifiableBean>();
        for (IdentifiableBean key : references.keySet()) {
            returnSet.addAll((Collection<IdentifiableBean>)references.get(key));
        }
        return returnSet;
    }

    private int countValues(Map<IdentifiableBean, Set<IdentifiableBean>> map) {
        int numberReferences = 0;
        for (Set<IdentifiableBean> refences : map.values()) {
            numberReferences += refences.size();
        }
        return numberReferences;
    }

    private Map<IdentifiableBean, Set<IdentifiableBean>> resolveReferencesInternal(SdmxBeans beans, SdmxBeanRetrievalManager retrievalManager, Map<IdentifiableBean, Set<CrossReferenceBean>> populateMissingMap) throws ReferenceException {
        for (AgencyBean currentAgency : beans.getAgencies()) {
            this.agencies.put(currentAgency.getFullId(), currentAgency);
        }
        this.maintainables.addAll(beans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]));
        if (this.resolveAgencies) {
            for (MaintainableBean currentBean : beans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0])) {
                try {
                    this.resolveAgency(currentBean, retrievalManager);
                }
                catch (ReferenceException e) {
                    throw new ReferenceException(e, ExceptionCode.REFERENCE_ERROR, new Object[]{SDMX_STRUCTURE_TYPE.AGENCY, currentBean.getStructureType(), currentBean.toString()});
                }
            }
        }
        HashSet<MaintainableBean> loopSet = new HashSet<MaintainableBean>();
        loopSet.addAll(this.maintainables);
        for (MaintainableBean currentMaintainable : loopSet) {
            this.log.debug("Resolving References For : " + currentMaintainable.getUrn());
            Set<CrossReferenceBean> crossReferences = currentMaintainable.getCrossReferences();
            this.log.debug("Number of References : " + crossReferences.size());
            int i = 0;
            for (CrossReferenceBean crossReference : crossReferences) {
                ++i;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Resolving Reference " + i + ": " + crossReference.toString() + " - referenced from -" + (Object)((Object)crossReference.getReferencedFrom().getStructureType()));
                }
                try {
                    this.storeRef(crossReference.getReferencedFrom(), this.resolveCrossReference(crossReference, retrievalManager));
                }
                catch (ReferenceException e) {
                    this.handleMissingReference(e, populateMissingMap);
                }
            }
        }
        return this.crossReferences;
    }

    private void handleMissingReference(ReferenceException e, Map<IdentifiableBean, Set<CrossReferenceBean>> populateMissingMap) throws ReferenceException {
        Set<CrossReferenceBean> missingRefences;
        CrossReferenceBean crossReference;
        if (populateMissingMap != null && e.getCrossReference() != null) {
            crossReference = e.getCrossReference();
            missingRefences = populateMissingMap.get(crossReference.getReferencedFrom());
            if (missingRefences == null) {
                missingRefences = new HashSet<CrossReferenceBean>();
                if (crossReference.getReferencedFrom().getStructureType().isIdentifiable()) {
                    populateMissingMap.put((IdentifiableBean)crossReference.getReferencedFrom(), missingRefences);
                } else {
                    populateMissingMap.put(crossReference.getReferencedFrom().getParent(IdentifiableBean.class, true), missingRefences);
                }
            }
        } else {
            throw e;
        }
        missingRefences.add(crossReference);
    }

    private void resolveAgency(MaintainableBean maint, SdmxBeanRetrievalManager structRetrievalManager) throws ReferenceException {
        if (!this.resolveAgencies) {
            return;
        }
        if (maint.getAgencyId().equals("SDMX")) {
            return;
        }
        AgencyBean agency = this.resolveAgency(maint.getAgencyId(), structRetrievalManager);
        this.agencies.put(agency.getId(), agency);
        this.storeRef(maint, agency);
    }

    private AgencyBean resolveAgency(String agencyId, SdmxBeanRetrievalManager structureRetrievalManager) throws ReferenceException {
        if (this.agencies.containsKey(agencyId)) {
            return this.agencies.get(agencyId);
        }
        AgencyBean agency = null;
        if (structureRetrievalManager != null) {
            agency = structureRetrievalManager.getAgency(agencyId);
        }
        if (agency == null) {
            throw new ReferenceException(ExceptionCode.REFERENCE_ERROR_UNRESOLVABLE, new Object[]{SDMX_STRUCTURE_TYPE.AGENCY, agencyId});
        }
        return agency;
    }

    @Override
    public IdentifiableBean resolveCrossReference(CrossReferenceBean crossReference, SdmxBeanRetrievalManager structRetrievalManager) throws ReferenceException {
        if (crossReference.getTargetReference() == SDMX_STRUCTURE_TYPE.AGENCY) {
            return this.resolveAgency(crossReference.getChildReference().getId(), structRetrievalManager);
        }
        MaintainableBean maintainableParent = crossReference.getReferencedFrom().getParent(MaintainableBean.class, true);
        StructureReferenceBean maintainableReferenceObject = crossReference.hasChildReference() ? new StructureReferenceBeanImpl(crossReference.getMaintainableReference(), crossReference.getMaintainableStructureType()) : crossReference;
        MaintainableBean resolvedMaintainable = this.resolveMaintainableFromLocalMaps(maintainableReferenceObject, maintainableParent);
        if (resolvedMaintainable == null && structRetrievalManager != null) {
            try {
                resolvedMaintainable = structRetrievalManager.getMaintainable(maintainableReferenceObject);
            }
            catch (Throwable throwable) {
                throw new ReferenceException(crossReference);
            }
        }
        if (resolvedMaintainable == null) {
            throw new ReferenceException(crossReference);
        }
        this.maintainables.add(resolvedMaintainable);
        if (crossReference.hasChildReference()) {
            String targetUrn = crossReference.getTargetUrn();
            for (IdentifiableBean currentComposite : resolvedMaintainable.getIdentifiableComposites()) {
                if (!currentComposite.getUrn().equals(targetUrn)) continue;
                return currentComposite;
            }
        } else {
            return resolvedMaintainable;
        }
        throw new ReferenceException(crossReference);
    }

    private MaintainableBean resolveMaintainableFromLocalMaps(StructureReferenceBean queryObject, MaintainableBean maintainableParent) throws ReferenceException {
        MaintainableRefBean ref = queryObject.getMaintainableReference();
        String agencyId = ref.getAgencyId();
        String version = ref.getVersion();
        if (!ref.hasAgencyId()) {
            agencyId = maintainableParent.getAgencyId();
        }
        if (!ObjectUtil.validString(ref.getMaintainableId())) {
            throw new ReferenceException(ExceptionCode.REFERENCE_ERROR_MISSING_PARAMETERS, new Object[]{queryObject.getMaintainableStructureType(), ref});
        }
        if (!ObjectUtil.validString(ref.getVersion())) {
            version = "1.0";
        }
        for (MaintainableBean currentMaint : this.maintainables) {
            if (currentMaint.getStructureType() != queryObject.getMaintainableStructureType() || !ObjectUtil.validString(currentMaint.getAgencyId()) || !currentMaint.getAgencyId().equals(agencyId) || !currentMaint.getId().equals(ref.getMaintainableId()) || !currentMaint.getVersion().equals(version)) continue;
            return currentMaint;
        }
        return null;
    }

    private void storeRef(SDMXBean referencedFrom, IdentifiableBean reference) {
        Set<Object> refList;
        IdentifiableBean refFromIdentifiable = referencedFrom.getStructureType().isIdentifiable() ? (IdentifiableBean)referencedFrom : referencedFrom.getParent(IdentifiableBean.class, true);
        if (this.crossReferences.containsKey(refFromIdentifiable)) {
            refList = this.crossReferences.get(refFromIdentifiable);
        } else {
            refList = new HashSet();
            this.crossReferences.put(refFromIdentifiable, refList);
        }
        refList.add(reference);
    }
}

