/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.manager.retrieval.RegistrationBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.util.beans.MaintainableUtil;
import org.sdmxsource.util.ObjectUtil;

public class InMemoryRegistrationRetrievalManager
implements RegistrationBeanRetrievalManager {
    private Set<RegistrationBean> registrations;

    public InMemoryRegistrationRetrievalManager() {
        this(null);
    }

    public InMemoryRegistrationRetrievalManager(Set<RegistrationBean> registrations) {
        this.registrations = registrations == null ? new HashSet<RegistrationBean>() : registrations;
    }

    public void deleteRegistration(RegistrationBean registration) {
        this.registrations.remove(registration);
    }

    public void addRegistrations(Set<RegistrationBean> registrations) {
        if (registrations != null) {
            this.registrations.addAll(registrations);
        }
    }

    @Override
    public Set<RegistrationBean> getAllRegistrations() {
        return new HashSet<RegistrationBean>(this.registrations);
    }

    @Override
    public Set<RegistrationBean> getRegistrations(MaintainableRefBean ref) {
        MaintainableUtil<RegistrationBean> filter = new MaintainableUtil<RegistrationBean>();
        return filter.filterCollection(this.registrations, ref);
    }

    @Override
    public RegistrationBean getRegistration(MaintainableRefBean ref) {
        Set<RegistrationBean> registrations = this.getRegistrations(ref);
        if (!ObjectUtil.validCollection(registrations)) {
            return null;
        }
        if (registrations.size() > 1) {
            throw new IllegalArgumentException("More then one registration returned for reference (expected only one):" + ref);
        }
        return (RegistrationBean)registrations.toArray()[0];
    }

    @Override
    public Set<RegistrationBean> getRegistrations(StructureReferenceBean provisionRefs) {
        HashSet<RegistrationBean> returnSet = new HashSet<RegistrationBean>();
        for (RegistrationBean currentReg : this.registrations) {
            if (!currentReg.getProvisionAgreementRef().getTargetUrn().equals(provisionRefs.getTargetUrn())) continue;
            returnSet.add(currentReg);
        }
        return returnSet;
    }

    @Override
    public Set<RegistrationBean> getRegistrations(ProvisionAgreementBean provision) {
        return this.getRegistrations(provision.asReference());
    }
}

