/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.manager.parse.StructureParsingManager;
import org.sdmxsource.sdmx.api.manager.persist.StructurePersistenceManager;
import org.sdmxsource.sdmx.api.manager.retrieval.CrossReferenceRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationUnitSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.AttachmentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.structureretrieval.engine.impl.CrossReferenceResolverEngineImpl;
import org.sdmxsource.sdmx.structureretrieval.manager.BaseSdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.util.model.Listener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.beans.factory.aspectj.ConfigurableObject;

@Configurable(preConstruction=true)
public class InMemoryRetrievalManager
extends BaseSdmxBeanRetrievalManager
implements SdmxBeanRetrievalManager,
StructurePersistenceManager,
Listener<ReadableDataLocation>,
ConfigurableObject {
    private static Logger LOG;
    protected SdmxBeans beans;
    protected CrossReferenceRetrievalManager crossRefControl;
    @Autowired(required=false)
    private StructureParsingManager structureParsingManager;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        Factory factory = new Factory("InMemoryRetrievalManager.java", Class.forName("org.sdmxsource.sdmx.structureretrieval.manager.InMemoryRetrievalManager"));
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 92);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 98);
        ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 102);
        ajc$tjp_3 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.sdmxsource.sdmx.structureretrieval.manager.InMemoryRetrievalManager", "", "", ""), 92);
        ajc$tjp_4 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.sdmxsource.sdmx.structureretrieval.manager.InMemoryRetrievalManager", "org.sdmxsource.sdmx.api.util.ReadableDataLocation:", "seed:", ""), 98);
        ajc$tjp_5 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.sdmxsource.sdmx.structureretrieval.manager.InMemoryRetrievalManager", "org.sdmxsource.sdmx.api.model.beans.SdmxBeans:org.sdmxsource.sdmx.api.manager.retrieval.CrossReferenceRetrievalManager:", "beans:crossRefControl:", ""), 102);
        ajc$tjp_6 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.sdmxsource.sdmx.structureretrieval.manager.InMemoryRetrievalManager", "org.sdmxsource.sdmx.api.model.beans.SdmxBeans:", "beans:", ""), 110);
        LOG = Logger.getLogger(InMemoryRetrievalManager.class);
    }

    public InMemoryRetrievalManager() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65(this);
        }
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && (this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class))) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(this);
        }
        this.beans = new SdmxBeansImpl();
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(this);
        }
    }

    public InMemoryRetrievalManager(ReadableDataLocation seed) {
        ReadableDataLocation readableDataLocation = seed;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)readableDataLocation);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65(this);
        }
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && (this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class))) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(this);
        }
        this.beans = new SdmxBeansImpl();
        this.invoke(seed);
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(this);
        }
    }

    public InMemoryRetrievalManager(SdmxBeans beans, CrossReferenceRetrievalManager crossRefControl) {
        SdmxBeans sdmxBeans = beans;
        CrossReferenceRetrievalManager crossReferenceRetrievalManager = crossRefControl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)sdmxBeans, (Object)crossReferenceRetrievalManager);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65(this);
        }
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && (this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class))) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(this);
        }
        this.beans = new SdmxBeansImpl();
        this.beans = beans;
        if (this.beans == null) {
            this.beans = new SdmxBeansImpl();
        }
        this.crossRefControl = crossRefControl;
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public InMemoryRetrievalManager(SdmxBeans beans) {
        void crossRefControl;
        Object var4_2 = null;
        SdmxBeans beans2 = beans;
        InMemoryRetrievalManager ajc$aspectInstance = this;
        SdmxBeans sdmxBeans = beans;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)sdmxBeans);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)ajc$aspectInstance, (Object)ajc$aspectInstance);
        if (ajc$aspectInstance != null && ajc$aspectInstance.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0(ajc$aspectInstance.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65(ajc$aspectInstance);
        }
        if (ajc$aspectInstance != null && ajc$aspectInstance.getClass().isAnnotationPresent(Configurable.class) && (ajc$aspectInstance == null || !ajc$aspectInstance.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0(ajc$aspectInstance.getClass().getAnnotation(Configurable.class))) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(ajc$aspectInstance);
        }
        ajc$aspectInstance.beans = new SdmxBeansImpl();
        ajc$aspectInstance.beans = beans2;
        if (ajc$aspectInstance.beans == null) {
            ajc$aspectInstance.beans = new SdmxBeansImpl();
        }
        ajc$aspectInstance.crossRefControl = crossRefControl;
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(this);
        }
    }

    @Override
    public void invoke(ReadableDataLocation seed) {
        this.beans = new SdmxBeansImpl();
        if (seed != null) {
            if (this.structureParsingManager == null) {
                throw new RuntimeException("Can not create an InMemoryRetrievalManager, StructureParsingManager is either not registered as a Spring Bean or Aspects are not enabled");
            }
            try {
                this.saveStructures(this.structureParsingManager.parseStructures(seed).getStructureBeans(false));
            }
            finally {
                seed.close();
            }
        }
    }

    @Override
    public void saveStructure(MaintainableBean maintainable) {
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiable(maintainable);
        this.saveStructures(beans);
    }

    @Override
    public void deleteStructure(MaintainableBean maintainable) {
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiable(maintainable);
        this.deleteStructures(beans);
    }

    @Override
    public void saveStructures(SdmxBeans beans) {
        this.beans.merge(beans);
    }

    @Override
    public void deleteStructures(SdmxBeans beans) {
        for (MaintainableBean currentMaint : beans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0])) {
            this.beans.removeMaintainable(currentMaint);
        }
    }

    public SdmxBeans getBeans() {
        return new SdmxBeansImpl(this.beans);
    }

    @Override
    public Set<MaintainableBean> getMaintainableWithReferences(StructureReferenceBean query) {
        Set<? extends MaintainableBean> maintainables = this.getMaintainables(query);
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiables(maintainables);
        this.resolveReferences(beans);
        return beans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]);
    }

    private void resolveReferences(SdmxBeans beans) {
        if (this.crossRefControl != null) {
            LOG.debug("resolve references for beans use crossRefControl");
            int numberBeansCurrent = -1;
            SdmxBeans allBeans = beans;
            SdmxBeans referencesToResolve = beans;
            SdmxBeansImpl newReferencesToResolve = new SdmxBeansImpl();
            int numberBeansLast = allBeans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]).size();
            do {
                numberBeansLast = numberBeansCurrent;
                HashSet<String> agencyReferences = new HashSet<String>();
                for (MaintainableBean maint : referencesToResolve.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0])) {
                    agencyReferences.add(maint.getAgencyId());
                    newReferencesToResolve.addIdentifiables(this.crossRefControl.getCrossReferencedStructures(maint, new SDMX_STRUCTURE_TYPE[0]));
                    for (IdentifiableBean ident : maint.getIdentifiableComposites()) {
                        newReferencesToResolve.addIdentifiables(this.crossRefControl.getCrossReferencedStructures(ident, new SDMX_STRUCTURE_TYPE[0]));
                    }
                }
                block3: for (String currentRef : agencyReferences) {
                    for (AgencyBean acy : this.beans.getAgencies()) {
                        if (!acy.getFullId().equals(currentRef)) continue;
                        newReferencesToResolve.addIdentifiable(acy);
                        continue block3;
                    }
                }
                allBeans.merge(newReferencesToResolve);
                referencesToResolve = newReferencesToResolve;
            } while ((numberBeansCurrent = allBeans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]).size()) != numberBeansLast);
        } else {
            LOG.debug("resolve references for beans create new cross reference resolver engine");
            CrossReferenceResolverEngineImpl resolver = new CrossReferenceResolverEngineImpl();
            Map<IdentifiableBean, Set<IdentifiableBean>> crossReferenceMap = resolver.resolveReferences(beans, false, 0, (SdmxBeanRetrievalManager)this);
            for (IdentifiableBean key : crossReferenceMap.keySet()) {
                beans.addIdentifiable(key);
                for (IdentifiableBean value : crossReferenceMap.get(key)) {
                    beans.addIdentifiable(value);
                }
            }
        }
        LOG.debug("resolve references complete");
    }

    @Override
    public Set<AttachmentConstraintBean> getAttachmentConstraints(MaintainableRefBean ref) {
        return this.beans.getAttachmentConstraints(ref);
    }

    @Override
    public Set<ContentConstraintBean> getContentConstraints(MaintainableRefBean ref) {
        return this.beans.getContentConstraintBeans(ref);
    }

    @Override
    public Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemeBeans(MaintainableRefBean ref) {
        return this.beans.getOrganisationUnitSchemes(ref);
    }

    @Override
    public Set<DataProviderSchemeBean> getDataProviderSchemeBeans(MaintainableRefBean ref) {
        return this.beans.getDataProviderSchemes(ref);
    }

    @Override
    public Set<DataConsumerSchemeBean> getDataConsumerSchemeBeans(MaintainableRefBean ref) {
        return this.beans.getDataConsumerSchemes(ref);
    }

    @Override
    public Set<AgencySchemeBean> getAgencySchemeBeans(MaintainableRefBean ref) {
        return this.beans.getAgenciesSchemes(ref);
    }

    @Override
    public Set<CategorisationBean> getCategorisationBeans(MaintainableRefBean ref) {
        return this.beans.getCategorisations(ref);
    }

    @Override
    public Set<CategorySchemeBean> getCategorySchemeBeans(MaintainableRefBean ref) {
        return this.beans.getCategorySchemes(ref);
    }

    @Override
    public Set<CodelistBean> getCodelistBeans(MaintainableRefBean ref) {
        return this.beans.getCodelists(ref);
    }

    @Override
    public Set<ConceptSchemeBean> getConceptSchemeBeans(MaintainableRefBean ref) {
        return this.beans.getConceptSchemes(ref);
    }

    @Override
    public Set<DataflowBean> getDataflowBeans(MaintainableRefBean ref) {
        return this.beans.getDataflows(ref);
    }

    @Override
    public Set<HierarchicalCodelistBean> getHierarchicCodeListBeans(MaintainableRefBean ref) {
        return this.beans.getHierarchicalCodelists(ref);
    }

    @Override
    public Set<DataStructureBean> getDataStructureBeans(MaintainableRefBean ref) {
        return this.beans.getDataStructures(ref);
    }

    @Override
    public Set<MetadataFlowBean> getMetadataflowBeans(MaintainableRefBean ref) {
        return this.beans.getMetadataflows(ref);
    }

    @Override
    public Set<MetadataStructureDefinitionBean> getMetadataStructureBeans(MaintainableRefBean ref) {
        return this.beans.getMetadataStructures(ref);
    }

    @Override
    public Set<ProcessBean> getProcessBeans(MaintainableRefBean ref) {
        return this.beans.getProcesses(ref);
    }

    @Override
    public Set<ReportingTaxonomyBean> getReportingTaxonomyBeans(MaintainableRefBean ref) {
        return this.beans.getReportingTaxonomys(ref);
    }

    @Override
    public Set<StructureSetBean> getStructureSetBeans(MaintainableRefBean ref) {
        return this.beans.getStructureSets(ref);
    }

    @Override
    public Set<ProvisionAgreementBean> getProvisionAgreementBeans(MaintainableRefBean ref) {
        return this.beans.getProvisionAgreements(ref);
    }
}

