/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_REFERENCE_DETAIL;
import org.sdmxsource.sdmx.api.exception.ReferenceException;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.StructureSearchManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationUnitSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.AttachmentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.RESTStructureQuery;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;

public class StructureSearchBeanRetrievalManager
implements SdmxBeanRetrievalManager {
    private StructureSearchManager structureSearchManager;

    public StructureSearchBeanRetrievalManager(StructureSearchManager structureSearchManager) {
        this.structureSearchManager = structureSearchManager;
    }

    @Override
    public Set<MaintainableBean> getMaintainableWithReferences(StructureReferenceBean query) throws ReferenceException {
        RESTStructureQuery sQuery = new RESTStructureQuery(STRUCTURE_QUERY_DETAIL.FULL, STRUCTURE_REFERENCE_DETAIL.DESCENDANTS, null, query, false);
        return this.structureSearchManager.getMaintainables(sQuery).getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]);
    }

    @Override
    public MaintainableBean getMaintainable(StructureReferenceBean query) throws ReferenceException {
        RESTStructureQuery sQuery = new RESTStructureQuery(STRUCTURE_QUERY_DETAIL.FULL, STRUCTURE_REFERENCE_DETAIL.NONE, null, query, false);
        SdmxBeans beans = this.structureSearchManager.getMaintainables(sQuery);
        Set<MaintainableBean> allMaintainables = beans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]);
        if (allMaintainables.size() == 0) {
            return null;
        }
        if (allMaintainables.size() > 1) {
            throw new RuntimeException("Expected only one bean from query : " + query.toString());
        }
        return (MaintainableBean)allMaintainables.toArray()[0];
    }

    @Override
    public AgencyBean getAgency(String id) {
        throw new UnsupportedException(new Object[]{"getAgency"});
    }

    @Override
    public AgencySchemeBean getAgencySchemeBean(MaintainableRefBean ref) {
        return (AgencySchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME).getBean();
    }

    @Override
    public AttachmentConstraintBean getAttachmentConstraint(MaintainableRefBean ref) {
        return (AttachmentConstraintBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.ATTACHMENT_CONSTRAINT).getBean();
    }

    @Override
    public CategorisationBean getCategorisation(MaintainableRefBean ref) {
        return (CategorisationBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.CATEGORISATION).getBean();
    }

    @Override
    public CodelistBean getCodelist(MaintainableRefBean ref) {
        return (CodelistBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.CODE_LIST).getBean();
    }

    @Override
    public ConceptSchemeBean getConceptScheme(MaintainableRefBean ref) {
        return (ConceptSchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME).getBean();
    }

    @Override
    public ContentConstraintBean getContentConstraint(MaintainableRefBean ref) {
        return (ContentConstraintBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT).getBean();
    }

    @Override
    public CategorySchemeBean getCategoryScheme(MaintainableRefBean ref) {
        return (CategorySchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME).getBean();
    }

    @Override
    public DataConsumerSchemeBean getDataConsumerSchemeBean(MaintainableRefBean ref) {
        return (DataConsumerSchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME).getBean();
    }

    @Override
    public DataflowBean getDataflow(MaintainableRefBean ref) {
        return (DataflowBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.DATAFLOW).getBean();
    }

    @Override
    public DataProviderSchemeBean getDataProviderSchemeBean(MaintainableRefBean ref) {
        return (DataProviderSchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME).getBean();
    }

    @Override
    public HierarchicalCodelistBean getHierarchicCodeList(MaintainableRefBean ref) {
        return (HierarchicalCodelistBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST).getBean();
    }

    @Override
    public MetadataFlowBean getMetadataflow(MaintainableRefBean ref) {
        return (MetadataFlowBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.METADATA_FLOW).getBean();
    }

    @Override
    public DataStructureBean getDataStructure(MaintainableRefBean ref) {
        return (DataStructureBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.DSD).getBean();
    }

    @Override
    public MetadataStructureDefinitionBean getMetadataStructure(MaintainableRefBean ref) {
        return (MetadataStructureDefinitionBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.MSD).getBean();
    }

    @Override
    public OrganisationUnitSchemeBean getOrganisationUnitScheme(MaintainableRefBean ref) {
        return (OrganisationUnitSchemeBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME).getBean();
    }

    @Override
    public ProcessBean getProcessBean(MaintainableRefBean ref) {
        return (ProcessBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.PROCESS).getBean();
    }

    @Override
    public ProvisionAgreementBean getProvisionAgreementBean(MaintainableRefBean ref) {
        return (ProvisionAgreementBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT).getBean();
    }

    @Override
    public StructureSetBean getStructureSet(MaintainableRefBean ref) {
        return (StructureSetBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.STRUCTURE_SET).getBean();
    }

    @Override
    public ReportingTaxonomyBean getReportingTaxonomy(MaintainableRefBean ref) {
        return (ReportingTaxonomyBean)new Resolver(ref, SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY).getBean();
    }

    @Override
    public Set<AttachmentConstraintBean> getAttachmentConstraints(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.ATTACHMENT_CONSTRAINT).getBeans();
    }

    @Override
    public Set<CategorisationBean> getCategorisationBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.CATEGORISATION).getBeans();
    }

    @Override
    public Set<CodelistBean> getCodelistBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.CODE_LIST).getBeans();
    }

    @Override
    public Set<ConceptSchemeBean> getConceptSchemeBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME).getBeans();
    }

    @Override
    public Set<ContentConstraintBean> getContentConstraints(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT).getBeans();
    }

    @Override
    public Set<CategorySchemeBean> getCategorySchemeBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME).getBeans();
    }

    @Override
    public Set<DataflowBean> getDataflowBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.DATAFLOW).getBeans();
    }

    @Override
    public Set<HierarchicalCodelistBean> getHierarchicCodeListBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST).getBeans();
    }

    @Override
    public Set<MetadataFlowBean> getMetadataflowBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.METADATA_FLOW).getBeans();
    }

    @Override
    public Set<DataStructureBean> getDataStructureBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.DSD).getBeans();
    }

    @Override
    public Set<MetadataStructureDefinitionBean> getMetadataStructureBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.MSD).getBeans();
    }

    @Override
    public Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemeBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME).getBeans();
    }

    @Override
    public Set<DataProviderSchemeBean> getDataProviderSchemeBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME).getBeans();
    }

    @Override
    public Set<DataConsumerSchemeBean> getDataConsumerSchemeBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME).getBeans();
    }

    @Override
    public Set<AgencySchemeBean> getAgencySchemeBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME).getBeans();
    }

    @Override
    public Set<ProcessBean> getProcessBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.PROCESS).getBeans();
    }

    @Override
    public Set<ProvisionAgreementBean> getProvisionAgreementBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT).getBeans();
    }

    @Override
    public Set<ReportingTaxonomyBean> getReportingTaxonomyBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY).getBeans();
    }

    @Override
    public Set<StructureSetBean> getStructureSetBeans(MaintainableRefBean ref) {
        return new Resolver(ref, SDMX_STRUCTURE_TYPE.STRUCTURE_SET).getBeans();
    }

    private class Resolver<T> {
        private StructureReferenceBean sRef;
        private SDMX_STRUCTURE_TYPE type;

        public Resolver(MaintainableRefBean ref, SDMX_STRUCTURE_TYPE type) {
            this.sRef = new StructureReferenceBeanImpl(ref, type);
            this.type = type;
        }

        private T getBean() {
            Set<T> beans = this.getBeans();
            if (beans.size() > 1) {
                throw new RuntimeException("Expected only one bean from query : " + this.sRef.toString());
            }
            if (beans.size() == 0) {
                return null;
            }
            return (T)beans.toArray()[0];
        }

        private Set<T> getBeans() {
            RESTStructureQuery sQuery = new RESTStructureQuery(STRUCTURE_QUERY_DETAIL.FULL, STRUCTURE_REFERENCE_DETAIL.NONE, this.type, this.sRef, false);
            SdmxBeans beans = StructureSearchBeanRetrievalManager.this.structureSearchManager.getMaintainables(sQuery);
            return beans.getMaintinables(this.type);
        }
    }
}

