/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.manager.retrieval.CrossReferenceRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.HeaderRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.RegistrationBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.ServiceRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.StructureSearchManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureQuery;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.structureretrieval.engine.impl.CrossReferenceResolverEngineImpl;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.util.VersionableUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class StructureSearchManagerImpl
implements StructureSearchManager {
    private Logger LOG = Logger.getLogger(StructureSearchManagerImpl.class);
    protected CrossReferenceRetrievalManager crossReferenceRetrievalManager;
    protected SdmxBeanRetrievalManager sdmxBeanRetrievalManager;
    private RegistrationBeanRetrievalManager registrationRetrievalManager;
    @Autowired(required=false)
    private HeaderRetrievalManager headerRetrievalManager;
    private ServiceRetrievalManager serviceRetrievalManager;

    public StructureSearchManagerImpl(SdmxBeanRetrievalManager sdmxBeanRetrievalManager, CrossReferenceRetrievalManager crossReferenceRetrievalManager) {
        if (sdmxBeanRetrievalManager == null) {
            throw new IllegalArgumentException("SdmxBeanRetrievalManager can not be null");
        }
        if (crossReferenceRetrievalManager == null) {
            throw new IllegalArgumentException("CrossReferenceControl can not be null");
        }
        this.sdmxBeanRetrievalManager = sdmxBeanRetrievalManager;
        this.crossReferenceRetrievalManager = crossReferenceRetrievalManager;
    }

    @Override
    public List<CategorisationBean> getCrossReferencingCategorisations(MaintainableBean maintainable) {
        ArrayList<CategorisationBean> returnList = new ArrayList<CategorisationBean>();
        for (MaintainableBean currentCategorisation : this.crossReferenceRetrievalManager.getCrossReferencingStructures(maintainable, SDMX_STRUCTURE_TYPE.CATEGORISATION)) {
            if (currentCategorisation.isStub()) {
                returnList.add(this.sdmxBeanRetrievalManager.getCategorisation(currentCategorisation.asReference().getMaintainableReference()));
                continue;
            }
            returnList.add((CategorisationBean)currentCategorisation);
        }
        return returnList;
    }

    @Override
    public SdmxBeans getMaintainables(StructureQuery complexQuery) {
        SdmxBeansImpl referencedBeans;
        block25: {
            Set<MaintainableBean> queryResultMaintainables;
            block24: {
                this.LOG.debug("Executing query for maintainables");
                queryResultMaintainables = this.retrieveStructures(complexQuery.getStructureReference().getMaintainableReference(), complexQuery.getStructureReference().getMaintainableStructureType(), false).getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]);
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Returned " + queryResultMaintainables.size() + " results");
                }
                if (complexQuery.getStructureQueryMetadata().isReturnLatest()) {
                    HashMap<String, MaintainableBean> resultMap = new HashMap<String, MaintainableBean>();
                    boolean filteredResponse = false;
                    for (MaintainableBean currentMaint : queryResultMaintainables) {
                        String key = String.valueOf(currentMaint.getStructureType().getType()) + "_" + currentMaint.getAgencyId() + "_" + currentMaint.getId();
                        if (resultMap.containsKey(key)) {
                            filteredResponse = true;
                            MaintainableBean storedAgainstKey = (MaintainableBean)resultMap.get(key);
                            if (!VersionableUtil.isHigherVersion(currentMaint.getVersion(), storedAgainstKey.getVersion())) continue;
                            resultMap.put(key, currentMaint);
                            continue;
                        }
                        resultMap.put(key, currentMaint);
                    }
                    if (filteredResponse) {
                        queryResultMaintainables = new HashSet(resultMap.values());
                    }
                }
                referencedBeans = new SdmxBeansImpl();
                SdmxBeansImpl referenceMerge = new SdmxBeansImpl();
                switch (complexQuery.getStructureQueryMetadata().getStructureReferenceDetail()) {
                    case NONE: {
                        this.LOG.debug("Reference detail NONE");
                        break;
                    }
                    case PARENTS: {
                        this.LOG.debug("Reference detail PARENTS");
                        this.resolveParents(queryResultMaintainables, referencedBeans);
                        break;
                    }
                    case PARENTS_SIBLINGS: {
                        this.LOG.debug("Reference detail PARENTS_SIBLINGS");
                        this.resolveParents(queryResultMaintainables, referencedBeans);
                        this.resolveChildren(referencedBeans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]), referenceMerge);
                        referencedBeans.merge(referenceMerge);
                        break;
                    }
                    case CHILDREN: {
                        this.LOG.debug("Reference detail CHILDREN");
                        this.resolveChildren(queryResultMaintainables, referencedBeans);
                        break;
                    }
                    case DESCENDANTS: {
                        this.LOG.debug("Reference detail DESCENDANTS");
                        this.resolveDescendants(queryResultMaintainables, referencedBeans);
                        break;
                    }
                    case ALL: {
                        this.resolveParents(queryResultMaintainables, referencedBeans);
                        Set<MaintainableBean> fullSet = referencedBeans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]);
                        fullSet.addAll(queryResultMaintainables);
                        this.resolveDescendants(fullSet, referenceMerge);
                        referencedBeans.merge(referenceMerge);
                        break;
                    }
                    case SPECIFIC: {
                        this.resolveSpecific(queryResultMaintainables, referencedBeans, complexQuery.getStructureQueryMetadata().getSpecificStructureReference());
                    }
                }
                Set<MaintainableBean> maintainableReferences = referencedBeans.getAllMaintinables(SDMX_STRUCTURE_TYPE.REGISTRATION, SDMX_STRUCTURE_TYPE.SUBSCRIPTION);
                HeaderBean header = null;
                if (this.headerRetrievalManager != null) {
                    header = this.headerRetrievalManager.getHeader();
                }
                referencedBeans = new SdmxBeansImpl(header);
                if (complexQuery.getStructureQueryMetadata().getStructureQueryDetail() == null) break block24;
                switch (complexQuery.getStructureQueryMetadata().getStructureQueryDetail()) {
                    case ALL_STUBS: {
                        MaintainableBean stubBean;
                        this.LOG.debug("Query detail ALL_STUBS");
                        for (MaintainableBean currentBean : maintainableReferences) {
                            stubBean = this.serviceRetrievalManager.createStub(currentBean);
                            referencedBeans.addIdentifiable(stubBean);
                        }
                        for (MaintainableBean currentBean : queryResultMaintainables) {
                            stubBean = this.serviceRetrievalManager.createStub(currentBean);
                            referencedBeans.addIdentifiable(stubBean);
                        }
                        break block25;
                    }
                    case FULL: {
                        this.LOG.debug("Query detail FULL");
                        referencedBeans.addIdentifiables(queryResultMaintainables);
                        referencedBeans.addIdentifiables(maintainableReferences);
                        break;
                    }
                    case REFERENCED_STUBS: {
                        this.LOG.debug("Query detail REFERENCED_STUBS");
                        for (MaintainableBean currentReference : maintainableReferences) {
                            MaintainableBean stubBean = this.serviceRetrievalManager.createStub(currentReference);
                            referencedBeans.addIdentifiable(stubBean);
                        }
                        referencedBeans.addIdentifiables(queryResultMaintainables);
                    }
                }
                break block25;
            }
            referencedBeans.addIdentifiables(queryResultMaintainables);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Result Size : " + referencedBeans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]).size());
        }
        return referencedBeans;
    }

    private void resolveSpecific(Set<MaintainableBean> resolveFor, SdmxBeans referencedBeans, SDMX_STRUCTURE_TYPE specificType) {
        this.LOG.debug("Resolving Child Structures");
        for (MaintainableBean currentMaintainable : resolveFor) {
            this.LOG.debug("Resolving Children of " + currentMaintainable.getUrn());
            referencedBeans.addIdentifiables(this.crossReferenceRetrievalManager.getCrossReferencedStructures(currentMaintainable, specificType));
            referencedBeans.addIdentifiables(this.crossReferenceRetrievalManager.getCrossReferencingStructures(currentMaintainable, specificType));
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(String.valueOf(referencedBeans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]).size()) + " children found");
        }
    }

    private void resolveDescendants(Set<MaintainableBean> resolveFor, SdmxBeans referencedBeans) {
        int numBeans = -2;
        while (numBeans != resolveFor.size()) {
            numBeans = referencedBeans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]).size();
            this.resolveChildren(resolveFor, referencedBeans);
            resolveFor = referencedBeans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(String.valueOf(referencedBeans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]).size()) + " descendants found");
        }
    }

    private void resolveChildren(Set<MaintainableBean> resolveFor, SdmxBeans referencedBeans) {
        this.LOG.debug("Resolving Child Structures");
        for (MaintainableBean currentMaintainable : resolveFor) {
            this.LOG.debug("Resolving Children of " + currentMaintainable.getUrn());
            referencedBeans.addIdentifiables(this.crossReferenceRetrievalManager.getCrossReferencedStructures(currentMaintainable, new SDMX_STRUCTURE_TYPE[0]));
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(String.valueOf(referencedBeans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]).size()) + " children found");
        }
    }

    private void resolveParents(Set<MaintainableBean> resolveFor, SdmxBeans referencedBeans) {
        this.LOG.debug("Resolving Parents Structures");
        for (MaintainableBean currentMaintainable : resolveFor) {
            this.LOG.debug("Resolving Parents of " + currentMaintainable.getUrn());
            referencedBeans.addIdentifiables(this.crossReferenceRetrievalManager.getCrossReferencingStructures(currentMaintainable, new SDMX_STRUCTURE_TYPE[0]));
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(String.valueOf(referencedBeans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]).size()) + " parents found");
        }
    }

    @Override
    public SdmxBeans retrieveStructures(List<StructureReferenceBean> queries, boolean resolveReferences) {
        SdmxBeans[] returnBeansArr = new SdmxBeans[queries.size()];
        int i = 0;
        while (i < queries.size()) {
            SdmxBeans returnedBeans = this.retrieveStructures(queries.get(i).getMaintainableReference(), queries.get(i).getMaintainableStructureType(), false);
            returnBeansArr[i] = new SdmxBeansImpl(returnedBeans);
            ++i;
        }
        SdmxBeansImpl returnBeans = new SdmxBeansImpl(returnBeansArr);
        if (resolveReferences) {
            this.resolveReferences(returnBeans);
        }
        return returnBeans;
    }

    public SdmxBeans retrieveStructures(MaintainableRefBean ref, SDMX_STRUCTURE_TYPE structureType, boolean resolveReferences) {
        if (structureType != SDMX_STRUCTURE_TYPE.ANY && structureType != SDMX_STRUCTURE_TYPE.ORGANISATION_SCHEME && !structureType.isMaintainable()) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, (Object)((Object)structureType) + " is not maintainable");
        }
        SdmxBeansImpl returnBeans = new SdmxBeansImpl();
        Set<MaintainableBean> currentMaintainables = null;
        switch (structureType) {
            case ANY: {
                for (SDMX_STRUCTURE_TYPE currentMaintainable : SDMX_STRUCTURE_TYPE.getMaintainableStructureTypes()) {
                    System.out.println((Object)currentMaintainable);
                    if (currentMaintainable == SDMX_STRUCTURE_TYPE.REGISTRATION || currentMaintainable == SDMX_STRUCTURE_TYPE.SUBSCRIPTION) continue;
                    returnBeans.merge(this.retrieveStructures(ref, currentMaintainable, resolveReferences));
                }
                break;
            }
            case ORGANISATION_SCHEME: {
                returnBeans.merge(this.retrieveStructures(ref, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, resolveReferences));
                returnBeans.merge(this.retrieveStructures(ref, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME, resolveReferences));
                returnBeans.merge(this.retrieveStructures(ref, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME, resolveReferences));
                returnBeans.merge(this.retrieveStructures(ref, SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME, resolveReferences));
                break;
            }
            case AGENCY_SCHEME: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getAgencySchemeBeans(ref);
                break;
            }
            case DATA_PROVIDER_SCHEME: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getDataProviderSchemeBeans(ref);
                break;
            }
            case DATA_CONSUMER_SCHEME: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getDataConsumerSchemeBeans(ref);
                break;
            }
            case CATEGORISATION: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getCategorisationBeans(ref);
                break;
            }
            case CATEGORY_SCHEME: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getCategorySchemeBeans(ref);
                break;
            }
            case CODE_LIST: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getCodelistBeans(ref);
                break;
            }
            case CONCEPT_SCHEME: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getConceptSchemeBeans(ref);
                break;
            }
            case DATAFLOW: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getDataflowBeans(ref);
                break;
            }
            case HIERARCHICAL_CODELIST: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getHierarchicCodeListBeans(ref);
                break;
            }
            case DSD: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getDataStructureBeans(ref);
                break;
            }
            case METADATA_FLOW: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getMetadataflowBeans(ref);
                break;
            }
            case MSD: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getMetadataStructureBeans(ref);
                break;
            }
            case ORGANISATION_UNIT_SCHEME: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getOrganisationUnitSchemeBeans(ref);
                break;
            }
            case PROCESS: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getProcessBeans(ref);
                break;
            }
            case STRUCTURE_SET: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getStructureSetBeans(ref);
                break;
            }
            case REPORTING_TAXONOMY: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getReportingTaxonomyBeans(ref);
                break;
            }
            case ATTACHMENT_CONSTRAINT: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getAttachmentConstraints(ref);
                break;
            }
            case CONTENT_CONSTRAINT: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getContentConstraints(ref);
                break;
            }
            case PROVISION_AGREEMENT: {
                currentMaintainables = this.sdmxBeanRetrievalManager.getProvisionAgreementBeans(ref);
                break;
            }
            case REGISTRATION: {
                currentMaintainables = this.registrationRetrievalManager.getRegistrations(ref);
                break;
            }
            default: {
                throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "Unsupported query for : " + (Object)((Object)structureType));
            }
        }
        if (currentMaintainables != null) {
            for (MaintainableBean currentBean : currentMaintainables) {
                returnBeans.addIdentifiable(currentBean);
            }
        }
        if (resolveReferences) {
            this.resolveReferences(returnBeans);
        }
        return returnBeans;
    }

    void resolveReferences(SdmxBeans beans) {
        CrossReferenceResolverEngineImpl resolver = new CrossReferenceResolverEngineImpl();
        Map<IdentifiableBean, Set<IdentifiableBean>> crossReferenceMap = resolver.resolveReferences(beans, false, 0, this.sdmxBeanRetrievalManager);
        for (IdentifiableBean key : crossReferenceMap.keySet()) {
            beans.addIdentifiable(key);
            for (IdentifiableBean value : crossReferenceMap.get(key)) {
                beans.addIdentifiable(value);
            }
        }
    }

    @Required
    public void setServiceRetrievalManager(ServiceRetrievalManager serviceRetrievalManager) {
        this.serviceRetrievalManager = serviceRetrievalManager;
    }

    public void setRegistrationRetrievalManager(RegistrationBeanRetrievalManager registrationRetrievalManager) {
        this.registrationRetrievalManager = registrationRetrievalManager;
    }
}

