/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager.mutable;

import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ReferenceException;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.mutable.SdmxMutableBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationUnitSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.mutable.base.AgencySchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.DataConsumerSchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.DataProviderSchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MaintainableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.OrganisationUnitSchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.categoryscheme.CategorisationMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.categoryscheme.CategorySchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.categoryscheme.ReportingTaxonomyMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodelistMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.HierarchicalCodelistMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptSchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataStructureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataflowMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.StructureSetMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.metadatastructure.MetadataFlowMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.metadatastructure.MetadataStructureDefinitionMutbaleBean;
import org.sdmxsource.sdmx.api.model.mutable.process.ProcessMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.ContentConstraintMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.ProvisionAgreementMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.categoryscheme.CategorisationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.categoryscheme.CategorySchemeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.categoryscheme.ReportingTaxonomyMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.CodelistMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.HierarchicalCodelistMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.conceptscheme.ConceptSchemeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DataStructureMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.mapping.StructureSetMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.metadatastructure.DataflowMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.metadatastructure.MetadataStructureDefinitionMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.metadatastructure.MetadataflowMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.process.ProcessMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.ContentConstraintMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.ProvisionAgreementMutableBeanImpl;
import org.sdmxsource.sdmx.structureretrieval.manager.AbstractRetrevalManager;

public class MutableBeanRetrievalManager
extends AbstractRetrevalManager
implements SdmxMutableBeanRetrievalManager {
    public MutableBeanRetrievalManager(SdmxBeanRetrievalManager sdmxBeanRetrievalManager) {
        super(sdmxBeanRetrievalManager);
    }

    @Override
    public AgencySchemeMutableBean getMutableAgencyScheme(MaintainableRefBean ref) {
        AgencySchemeBean bean = this.sdmxBeanRetrievalManager.getAgencySchemeBean(ref);
        return bean == null ? null : bean.getMutableInstance();
    }

    @Override
    public DataConsumerSchemeMutableBean getMutableDataConsumerScheme(MaintainableRefBean ref) {
        DataConsumerSchemeBean bean = this.sdmxBeanRetrievalManager.getDataConsumerSchemeBean(ref);
        return bean == null ? null : bean.getMutableInstance();
    }

    @Override
    public DataProviderSchemeMutableBean getMutableDataProviderScheme(MaintainableRefBean ref) {
        DataProviderSchemeBean bean = this.sdmxBeanRetrievalManager.getDataProviderSchemeBean(ref);
        return bean == null ? null : bean.getMutableInstance();
    }

    @Override
    public Set<AgencySchemeMutableBean> getMutableAgencySchemeBeans(MaintainableRefBean ref) {
        HashSet<AgencySchemeMutableBean> returnSet = new HashSet<AgencySchemeMutableBean>();
        for (AgencySchemeBean currentBean : this.sdmxBeanRetrievalManager.getAgencySchemeBeans(ref)) {
            returnSet.add(currentBean.getMutableInstance());
        }
        return returnSet;
    }

    @Override
    public Set<DataConsumerSchemeMutableBean> getMutableDataConsumerSchemeBeans(MaintainableRefBean ref) {
        HashSet<DataConsumerSchemeMutableBean> returnSet = new HashSet<DataConsumerSchemeMutableBean>();
        for (DataConsumerSchemeBean currentBean : this.sdmxBeanRetrievalManager.getDataConsumerSchemeBeans(ref)) {
            returnSet.add(currentBean.getMutableInstance());
        }
        return returnSet;
    }

    @Override
    public Set<DataProviderSchemeMutableBean> getMutableDataProviderSchemeBeans(MaintainableRefBean ref) {
        HashSet<DataProviderSchemeMutableBean> returnSet = new HashSet<DataProviderSchemeMutableBean>();
        for (DataProviderSchemeBean currentBean : this.sdmxBeanRetrievalManager.getDataProviderSchemeBeans(ref)) {
            returnSet.add(currentBean.getMutableInstance());
        }
        return returnSet;
    }

    @Override
    public CategorisationMutableBean getMutableCategorisation(MaintainableRefBean ref) {
        CategorisationBean bean = this.sdmxBeanRetrievalManager.getCategorisation(ref);
        return bean == null ? null : new CategorisationMutableBeanImpl(bean);
    }

    @Override
    public Set<CategorisationMutableBean> getMutableCategorisationBeans(MaintainableRefBean ref) {
        Set<CategorisationBean> beans = this.sdmxBeanRetrievalManager.getCategorisationBeans(ref);
        HashSet<CategorisationMutableBean> returnSet = new HashSet<CategorisationMutableBean>();
        for (CategorisationBean csBean : beans) {
            returnSet.add(new CategorisationMutableBeanImpl(csBean));
        }
        return returnSet;
    }

    @Override
    public CategorySchemeMutableBean getMutableCategoryScheme(MaintainableRefBean ref) {
        CategorySchemeBean bean = this.sdmxBeanRetrievalManager.getCategoryScheme(ref);
        return bean == null ? null : new CategorySchemeMutableBeanImpl(bean);
    }

    @Override
    public Set<CategorySchemeMutableBean> getMutableCategorySchemeBeans(MaintainableRefBean ref) {
        Set<CategorySchemeBean> beans = this.sdmxBeanRetrievalManager.getCategorySchemeBeans(ref);
        HashSet<CategorySchemeMutableBean> returnSet = new HashSet<CategorySchemeMutableBean>();
        for (CategorySchemeBean csBean : beans) {
            returnSet.add(new CategorySchemeMutableBeanImpl(csBean));
        }
        return returnSet;
    }

    @Override
    public CodelistMutableBean getMutableCodelist(MaintainableRefBean ref) {
        CodelistBean bean = this.sdmxBeanRetrievalManager.getCodelist(ref);
        return bean == null ? null : new CodelistMutableBeanImpl(bean);
    }

    @Override
    public Set<CodelistMutableBean> getMutableCodelistBeans(MaintainableRefBean ref) {
        Set<CodelistBean> beans = this.sdmxBeanRetrievalManager.getCodelistBeans(ref);
        HashSet<CodelistMutableBean> returnSet = new HashSet<CodelistMutableBean>();
        for (CodelistBean bean : beans) {
            returnSet.add(new CodelistMutableBeanImpl(bean));
        }
        return returnSet;
    }

    @Override
    public ConceptSchemeMutableBean getMutableConceptScheme(MaintainableRefBean ref) {
        ConceptSchemeBean bean = this.sdmxBeanRetrievalManager.getConceptScheme(ref);
        return bean == null ? null : new ConceptSchemeMutableBeanImpl(bean);
    }

    @Override
    public Set<ConceptSchemeMutableBean> getMutableConceptSchemeBeans(MaintainableRefBean ref) {
        Set<ConceptSchemeBean> beans = this.sdmxBeanRetrievalManager.getConceptSchemeBeans(ref);
        HashSet<ConceptSchemeMutableBean> returnSet = new HashSet<ConceptSchemeMutableBean>();
        for (ConceptSchemeBean bean : beans) {
            returnSet.add(new ConceptSchemeMutableBeanImpl(bean));
        }
        return returnSet;
    }

    @Override
    public DataflowMutableBean getMutableDataflow(MaintainableRefBean ref) {
        DataflowBean bean = this.sdmxBeanRetrievalManager.getDataflow(ref);
        return bean == null ? null : new DataflowMutableBeanImpl(bean);
    }

    @Override
    public Set<DataflowMutableBean> getMutableDataflowBeans(MaintainableRefBean ref) {
        Set<DataflowBean> beans = this.sdmxBeanRetrievalManager.getDataflowBeans(ref);
        HashSet<DataflowMutableBean> returnSet = new HashSet<DataflowMutableBean>();
        for (DataflowBean bean : beans) {
            returnSet.add(new DataflowMutableBeanImpl(bean));
        }
        return returnSet;
    }

    @Override
    public HierarchicalCodelistMutableBean getMutableHierarchicCodeList(MaintainableRefBean ref) {
        HierarchicalCodelistBean bean = this.sdmxBeanRetrievalManager.getHierarchicCodeList(ref);
        return bean == null ? null : new HierarchicalCodelistMutableBeanImpl(bean);
    }

    @Override
    public Set<HierarchicalCodelistMutableBean> getMutableHierarchicCodeListBeans(MaintainableRefBean ref) {
        Set<HierarchicalCodelistBean> beans = this.sdmxBeanRetrievalManager.getHierarchicCodeListBeans(ref);
        HashSet<HierarchicalCodelistMutableBean> returnSet = new HashSet<HierarchicalCodelistMutableBean>();
        for (HierarchicalCodelistBean bean : beans) {
            returnSet.add(new HierarchicalCodelistMutableBeanImpl(bean));
        }
        return returnSet;
    }

    @Override
    public DataStructureMutableBean getMutableDataStructure(MaintainableRefBean ref) {
        DataStructureBean bean = this.sdmxBeanRetrievalManager.getDataStructure(ref);
        return bean == null ? null : new DataStructureMutableBeanImpl(bean);
    }

    @Override
    public Set<DataStructureMutableBean> getMutableDataStructureBeans(MaintainableRefBean ref) {
        Set<DataStructureBean> beans = this.sdmxBeanRetrievalManager.getDataStructureBeans(ref);
        HashSet<DataStructureMutableBean> returnSet = new HashSet<DataStructureMutableBean>();
        for (DataStructureBean bean : beans) {
            returnSet.add(new DataStructureMutableBeanImpl(bean));
        }
        return returnSet;
    }

    @Override
    public MaintainableMutableBean getMutableMaintainable(StructureReferenceBean query) throws ReferenceException {
        SDMX_STRUCTURE_TYPE structureType = query.getTargetReference();
        if (!structureType.isMaintainable()) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, (Object)((Object)structureType) + " is not maintainable");
        }
        MaintainableRefBean ref = query.getMaintainableReference();
        switch (structureType) {
            case AGENCY_SCHEME: {
                return this.getMutableAgencyScheme(ref);
            }
            case DATA_PROVIDER_SCHEME: {
                return this.getMutableDataProviderScheme(ref);
            }
            case DATA_CONSUMER_SCHEME: {
                return this.getMutableDataConsumerScheme(ref);
            }
            case CATEGORISATION: {
                return this.getMutableCategorisation(ref);
            }
            case CATEGORY_SCHEME: {
                return this.getMutableCategoryScheme(ref);
            }
            case CONTENT_CONSTRAINT: {
                return this.getMutableContentConstraintBean(ref);
            }
            case CODE_LIST: {
                return this.getMutableCodelist(ref);
            }
            case CONCEPT_SCHEME: {
                return this.getMutableConceptScheme(ref);
            }
            case DATAFLOW: {
                return this.getMutableDataflow(ref);
            }
            case HIERARCHICAL_CODELIST: {
                return this.getMutableHierarchicCodeList(ref);
            }
            case DSD: {
                return this.getMutableDataStructure(ref);
            }
            case METADATA_FLOW: {
                return this.getMutableMetadataflow(ref);
            }
            case MSD: {
                return this.getMutableMetadataStructure(ref);
            }
            case ORGANISATION_UNIT_SCHEME: {
                return this.getMutableOrganisationUnitScheme(ref);
            }
            case PROCESS: {
                return this.getMutableProcessBean(ref);
            }
            case PROVISION_AGREEMENT: {
                return this.getMutableProvisionAgreement(ref);
            }
            case STRUCTURE_SET: {
                return this.getMutableStructureSet(ref);
            }
            case REPORTING_TAXONOMY: {
                return this.getMutableReportingTaxonomy(ref);
            }
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, new Object[]{structureType});
    }

    @Override
    public Set<? extends MaintainableMutableBean> getMutableMaintainables(StructureReferenceBean query) throws ReferenceException {
        SDMX_STRUCTURE_TYPE structureType = query.getTargetReference();
        if (!structureType.isMaintainable()) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, (Object)((Object)structureType) + " is not maintainable");
        }
        MaintainableRefBean ref = query.getMaintainableReference();
        switch (structureType) {
            case AGENCY_SCHEME: {
                return this.getMutableAgencySchemeBeans(ref);
            }
            case DATA_PROVIDER_SCHEME: {
                return this.getMutableDataProviderSchemeBeans(ref);
            }
            case DATA_CONSUMER_SCHEME: {
                return this.getMutableDataConsumerSchemeBeans(ref);
            }
            case CATEGORISATION: {
                return this.getMutableCategorisationBeans(ref);
            }
            case CONTENT_CONSTRAINT: {
                return this.getMutableContentConstraintBeans(ref);
            }
            case CATEGORY_SCHEME: {
                return this.getMutableCategorySchemeBeans(ref);
            }
            case CODE_LIST: {
                return this.getMutableCodelistBeans(ref);
            }
            case CONCEPT_SCHEME: {
                return this.getMutableConceptSchemeBeans(ref);
            }
            case DATAFLOW: {
                return this.getMutableDataflowBeans(ref);
            }
            case HIERARCHICAL_CODELIST: {
                return this.getMutableHierarchicCodeListBeans(ref);
            }
            case DSD: {
                return this.getMutableDataStructureBeans(ref);
            }
            case METADATA_FLOW: {
                return this.getMutableMetadataflowBeans(ref);
            }
            case MSD: {
                return this.getMutableMetadataStructureBeans(ref);
            }
            case ORGANISATION_UNIT_SCHEME: {
                return this.getMutableOrganisationUnitSchemeBeans(ref);
            }
            case PROVISION_AGREEMENT: {
                return this.getMutableProvisionAgreements(ref);
            }
            case PROCESS: {
                return this.getMutableProcessBeanBeans(ref);
            }
            case STRUCTURE_SET: {
                return this.getMutableStructureSetBeans(ref);
            }
            case REPORTING_TAXONOMY: {
                return this.getMutableReportingTaxonomyBeans(ref);
            }
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, new Object[]{structureType});
    }

    @Override
    public Set<MaintainableMutableBean> getMutableMaintainableWithReferences(StructureReferenceBean query) throws ReferenceException {
        Set<MaintainableBean> maintainables = this.sdmxBeanRetrievalManager.getMaintainableWithReferences(query);
        return this.convertToMutables(maintainables);
    }

    private Set<MaintainableMutableBean> convertToMutables(Set<MaintainableBean> maintainables) {
        HashSet<MaintainableMutableBean> returnSet = new HashSet<MaintainableMutableBean>();
        for (MaintainableBean maintainable : maintainables) {
            returnSet.add(maintainable.getMutableInstance());
        }
        return returnSet;
    }

    public ProvisionAgreementMutableBean getMutableProvisionAgreement(MaintainableRefBean ref) {
        ProvisionAgreementBean bean = this.sdmxBeanRetrievalManager.getProvisionAgreementBean(ref);
        return bean == null ? null : new ProvisionAgreementMutableBeanImpl(bean);
    }

    public Set<ProvisionAgreementMutableBean> getMutableProvisionAgreements(MaintainableRefBean ref) {
        Set<ProvisionAgreementBean> beans = this.sdmxBeanRetrievalManager.getProvisionAgreementBeans(ref);
        HashSet<ProvisionAgreementMutableBean> returnSet = new HashSet<ProvisionAgreementMutableBean>();
        for (ProvisionAgreementBean bean : beans) {
            returnSet.add(new ProvisionAgreementMutableBeanImpl(bean));
        }
        return returnSet;
    }

    public ContentConstraintMutableBean getMutableContentConstraintBean(MaintainableRefBean ref) {
        ContentConstraintBean bean = this.sdmxBeanRetrievalManager.getContentConstraint(ref);
        return bean == null ? null : new ContentConstraintMutableBeanImpl(bean);
    }

    public Set<ContentConstraintMutableBean> getMutableContentConstraintBeans(MaintainableRefBean ref) {
        Set<ContentConstraintBean> beans = this.sdmxBeanRetrievalManager.getContentConstraints(ref);
        HashSet<ContentConstraintMutableBean> returnSet = new HashSet<ContentConstraintMutableBean>();
        for (ContentConstraintBean bean : beans) {
            returnSet.add(new ContentConstraintMutableBeanImpl(bean));
        }
        return returnSet;
    }

    @Override
    public MetadataStructureDefinitionMutbaleBean getMutableMetadataStructure(MaintainableRefBean ref) {
        MetadataStructureDefinitionBean bean = this.sdmxBeanRetrievalManager.getMetadataStructure(ref);
        return bean == null ? null : new MetadataStructureDefinitionMutableBeanImpl(bean);
    }

    @Override
    public Set<MetadataStructureDefinitionMutbaleBean> getMutableMetadataStructureBeans(MaintainableRefBean ref) {
        Set<MetadataStructureDefinitionBean> beans = this.sdmxBeanRetrievalManager.getMetadataStructureBeans(ref);
        HashSet<MetadataStructureDefinitionMutbaleBean> returnSet = new HashSet<MetadataStructureDefinitionMutbaleBean>();
        for (MetadataStructureDefinitionBean bean : beans) {
            returnSet.add(new MetadataStructureDefinitionMutableBeanImpl(bean));
        }
        return returnSet;
    }

    @Override
    public MetadataFlowMutableBean getMutableMetadataflow(MaintainableRefBean ref) {
        MetadataFlowBean bean = this.sdmxBeanRetrievalManager.getMetadataflow(ref);
        return bean == null ? null : new MetadataflowMutableBeanImpl(bean);
    }

    @Override
    public Set<MetadataFlowMutableBean> getMutableMetadataflowBeans(MaintainableRefBean ref) {
        Set<MetadataFlowBean> beans = this.sdmxBeanRetrievalManager.getMetadataflowBeans(ref);
        HashSet<MetadataFlowMutableBean> returnSet = new HashSet<MetadataFlowMutableBean>();
        for (MetadataFlowBean bean : beans) {
            returnSet.add(new MetadataflowMutableBeanImpl(bean));
        }
        return returnSet;
    }

    @Override
    public OrganisationUnitSchemeMutableBean getMutableOrganisationUnitScheme(MaintainableRefBean ref) {
        OrganisationUnitSchemeBean bean = this.sdmxBeanRetrievalManager.getOrganisationUnitScheme(ref);
        return bean == null ? null : bean.getMutableInstance();
    }

    @Override
    public Set<OrganisationUnitSchemeMutableBean> getMutableOrganisationUnitSchemeBeans(MaintainableRefBean ref) {
        Set<OrganisationUnitSchemeBean> beans = this.sdmxBeanRetrievalManager.getOrganisationUnitSchemeBeans(ref);
        HashSet<OrganisationUnitSchemeMutableBean> returnSet = new HashSet<OrganisationUnitSchemeMutableBean>();
        for (OrganisationUnitSchemeBean bean : beans) {
            returnSet.add(bean.getMutableInstance());
        }
        return returnSet;
    }

    @Override
    public ProcessMutableBean getMutableProcessBean(MaintainableRefBean ref) {
        ProcessBean bean = this.sdmxBeanRetrievalManager.getProcessBean(ref);
        return bean == null ? null : new ProcessMutableBeanImpl(bean);
    }

    @Override
    public Set<ProcessMutableBean> getMutableProcessBeanBeans(MaintainableRefBean ref) {
        Set<ProcessBean> beans = this.sdmxBeanRetrievalManager.getProcessBeans(ref);
        HashSet<ProcessMutableBean> returnSet = new HashSet<ProcessMutableBean>();
        for (ProcessBean bean : beans) {
            returnSet.add(new ProcessMutableBeanImpl(bean));
        }
        return returnSet;
    }

    @Override
    public ReportingTaxonomyMutableBean getMutableReportingTaxonomy(MaintainableRefBean ref) {
        ReportingTaxonomyBean bean = this.sdmxBeanRetrievalManager.getReportingTaxonomy(ref);
        return bean == null ? null : new ReportingTaxonomyMutableBeanImpl(bean);
    }

    @Override
    public Set<ReportingTaxonomyMutableBean> getMutableReportingTaxonomyBeans(MaintainableRefBean ref) {
        Set<ReportingTaxonomyBean> beans = this.sdmxBeanRetrievalManager.getReportingTaxonomyBeans(ref);
        HashSet<ReportingTaxonomyMutableBean> returnSet = new HashSet<ReportingTaxonomyMutableBean>();
        for (ReportingTaxonomyBean bean : beans) {
            returnSet.add(new ReportingTaxonomyMutableBeanImpl(bean));
        }
        return returnSet;
    }

    @Override
    public StructureSetMutableBean getMutableStructureSet(MaintainableRefBean ref) {
        StructureSetBean bean = this.sdmxBeanRetrievalManager.getStructureSet(ref);
        return bean == null ? null : new StructureSetMutableBeanImpl(bean);
    }

    @Override
    public Set<StructureSetMutableBean> getMutableStructureSetBeans(MaintainableRefBean ref) {
        Set<StructureSetBean> beans = this.sdmxBeanRetrievalManager.getStructureSetBeans(ref);
        HashSet<StructureSetMutableBean> returnSet = new HashSet<StructureSetMutableBean>();
        for (StructureSetBean bean : beans) {
            returnSet.add(new StructureSetMutableBeanImpl(bean));
        }
        return returnSet;
    }
}

