/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.StructureException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.util.ObjectUtil;

public class UrnUtil {
    private static Logger LOG = Logger.getLogger(UrnUtil.class);

    public static void validateURN(String urn, SDMX_STRUCTURE_TYPE structureType) {
        if (urn.split("=").length == 0) {
            throw new StructureException(ExceptionCode.STRUCTURE_URN_MALFORMED, urn);
        }
        String urnPrefix = urn.split("=")[0];
        SDMX_STRUCTURE_TYPE targetType = SDMX_STRUCTURE_TYPE.parsePrefix(urnPrefix);
        if (targetType != structureType) {
            throw new StructureException(ExceptionCode.STRUCTURE_URN_UNEXPECTED_PREFIX, urn, structureType.getUrnPrefix());
        }
        String[] components = UrnUtil.getUrnComponents(urn);
        if (structureType.isMaintainable()) {
            if (components == null) {
                throw new StructureException(ExceptionCode.STRUCTURE_URN_MALFORMED, urn);
            }
            if (structureType == SDMX_STRUCTURE_TYPE.SUBSCRIPTION ? components.length != 4 : components.length != 2) {
                throw new StructureException(ExceptionCode.STRUCTURE_URN_MALFORMED, urn);
            }
        } else if (!(!structureType.isIdentifiable() || components != null && components.length > 2 || components.length == 1 && structureType == SDMX_STRUCTURE_TYPE.AGENCY)) {
            throw new StructureException(ExceptionCode.STRUCTURE_URN_MALFORMED, urn);
        }
        for (String currentComponent : components) {
            if (ObjectUtil.validString(currentComponent)) continue;
            throw new StructureException(ExceptionCode.STRUCTURE_URN_MALFORMED, urn);
        }
        String version = UrnUtil.getVersionFromUrn(urn);
        if (version == null && structureType != SDMX_STRUCTURE_TYPE.AGENCY) {
            throw new StructureException(ExceptionCode.STRUCTURE_URN_MALFORMED, urn);
        }
    }

    public static SDMX_STRUCTURE_TYPE getIdentifiableType(String urn) throws StructureException {
        if (urn.split("=").length == 0) {
            throw new StructureException(ExceptionCode.STRUCTURE_URN_MALFORMED, urn);
        }
        String urnPrefix = urn.split("=")[0];
        return SDMX_STRUCTURE_TYPE.parsePrefix(urnPrefix);
    }

    public static String getUrnPostfix(String urn) {
        return urn.split("=")[1];
    }

    public static String getUrnPrefix(String urn) {
        return urn.split("=")[0];
    }

    public static String getUrnPostfix(String agencyId, String id, String version) {
        return agencyId + ":" + id + "(" + version + ")";
    }

    public static String getUrnPostfix(String agencyId, String maintid, String version, String ... id) {
        String idPost = "";
        for (int i = 0; i < id.length; ++i) {
            idPost = idPost + ".";
            idPost = idPost + id[i];
            ++i;
        }
        return agencyId + ":" + maintid + "(" + version + ")" + idPost;
    }

    private static String removeVersionsFromUrn(String urn) {
        if (urn.contains("[") || urn.contains("]")) {
            LOG.warn("URN using pre 2.1 syntax [#version] upgrading to (#version) : " + urn);
            urn = urn.replaceAll("\\[", "(");
            urn = urn.replaceAll("\\]", ")");
        }
        return urn.replaceAll("(?=\\().*?(?<=\\))", "");
    }

    public static String[] getUrnComponents(String urn) {
        String mainUrn = UrnUtil.getUrnPostfix(urn);
        if (UrnUtil.getIdentifiableType(urn) == SDMX_STRUCTURE_TYPE.AGENCY) {
            String[] agencies = mainUrn.split("\\.");
            if (agencies.length == 1) {
                return new String[]{"SDMX", "AGENCIES", agencies[0]};
            }
            return new String[]{mainUrn.substring(0, mainUrn.lastIndexOf(".")), "AGENCIES", agencies[agencies.length - 1]};
        }
        String urnVersionsRemoved = UrnUtil.removeVersionsFromUrn(mainUrn);
        String[] majorComponents = urnVersionsRemoved.split("\\:");
        if (majorComponents.length == 1) {
            throw new ValidationException("URN agency id is expected to be followed by a ':' character : '" + urn + "'");
        }
        if (majorComponents.length != 2) {
            throw new ValidationException("URN should not contain more than one ':' character: '" + urn + "'");
        }
        String[] minorComponents = majorComponents[1].split("\\.");
        String[] returnArray = new String[minorComponents.length + 1];
        returnArray[0] = majorComponents[0];
        for (int i = 0; i < minorComponents.length; ++i) {
            returnArray[i + 1] = minorComponents[i];
        }
        return returnArray;
    }

    public static String getVersionFromUrn(String urn) {
        if (urn.contains("[") || urn.contains("]")) {
            LOG.warn("URN using pre 2.1 syntax [#version] upgrading to (#version) : " + urn);
            urn = urn.replaceAll("\\[", "(");
            urn = urn.replaceAll("\\]", ")");
        }
        String mainUrn = UrnUtil.getUrnPostfix(urn);
        String versionRegEx = "((?=\\().*?(?<=\\)))";
        Pattern p = Pattern.compile(versionRegEx);
        Matcher m = p.matcher(mainUrn);
        if (m.find()) {
            String version = m.group();
            version = version.replaceAll("\\(", "");
            version = version.replaceAll("\\)", "");
            return version;
        }
        return null;
    }
}

