/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans.container;

import java.util.HashMap;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.AgencyMetadata;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;

public class AgencyMetadataImpl
implements AgencyMetadata {
    private Map<SDMX_STRUCTURE_TYPE, Integer> structureMap = new HashMap<SDMX_STRUCTURE_TYPE, Integer>();
    private String agencyId;

    public AgencyMetadataImpl() {
    }

    public AgencyMetadataImpl(String agencyId, SdmxBeans beans) {
        this.agencyId = agencyId;
        this.structureMap.put(SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, beans.getAgenciesSchemes(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.ATTACHMENT_CONSTRAINT, beans.getAttachmentConstraints(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT, beans.getContentConstraintBeans(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME, beans.getDataProviderSchemes(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME, beans.getDataConsumerSchemes(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME, beans.getOrganisationUnitSchemes(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.CATEGORISATION, beans.getCategorisations(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.DATAFLOW, beans.getDataflows(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.METADATA_FLOW, beans.getMetadataflows(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME, beans.getCategorySchemes(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, beans.getConceptSchemes(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.CODE_LIST, beans.getCodelists(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST, beans.getHierarchicalCodelists(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.MSD, beans.getMetadataStructures(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.DSD, beans.getDataStructures(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.PROCESS, beans.getProcesses(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY, beans.getReportingTaxonomys(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.STRUCTURE_SET, beans.getStructureSets(agencyId).size());
        this.structureMap.put(SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT, beans.getProvisionAgreements(agencyId).size());
    }

    @Override
    public String getAgencyId() {
        return this.agencyId;
    }

    public void setAgencyId(String agencyId) {
        this.agencyId = agencyId;
    }

    @Override
    public Integer getNumberOfMaintainables(SDMX_STRUCTURE_TYPE structureType) {
        if (this.structureMap.containsKey((Object)structureType)) {
            return this.structureMap.get((Object)structureType);
        }
        return 0;
    }

    public void setNumberMaintainables(Integer num) {
    }

    @Override
    public Integer getNumberMaintainables() {
        int i = 0;
        for (SDMX_STRUCTURE_TYPE currentMaint : SDMX_STRUCTURE_TYPE.getMaintainableStructureTypes()) {
            i += this.getNumberOfMaintainables(currentMaint).intValue();
        }
        return i;
    }

    @Override
    public Integer getNumberCategorisations() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.CATEGORISATION);
    }

    public void setNumberCategorisations(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.CATEGORISATION, num);
    }

    @Override
    public Integer getNumberAgencySchemes() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.AGENCY_SCHEME);
    }

    public void setNumberAgencySchemes(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, num);
    }

    @Override
    public Integer getNumberAttachmentConstraint() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.ATTACHMENT_CONSTRAINT);
    }

    public void setNumberAttachmentConstraint(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.ATTACHMENT_CONSTRAINT, num);
    }

    @Override
    public Integer getNumberContentConstraintBean() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT);
    }

    public void setNumberContentConstraintBean(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT, num);
    }

    @Override
    public Integer getNumberDataProviderSchemes() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME);
    }

    public void setNumberDataProviderSchemes(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME, num);
    }

    @Override
    public Integer getNumberDataConsumerSchemes() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME);
    }

    public void setNumberDataConsumerSchemes(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME, num);
    }

    @Override
    public Integer getNumberOrganisationUnitSchemes() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME);
    }

    public void setNumberOrganisationUnitSchemes(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME, num);
    }

    @Override
    public Integer getNumberDataflows() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.DATAFLOW);
    }

    public void setNumberDataflows(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.DATAFLOW, num);
    }

    @Override
    public Integer getNumberMetadataflows() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.METADATA_FLOW);
    }

    public void setNumberMetadataflows(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.METADATA_FLOW, num);
    }

    @Override
    public Integer getNumberCategorySchemes() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME);
    }

    public void setNumberCategorySchemes(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME, num);
    }

    @Override
    public Integer getNumberConceptSchemes() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME);
    }

    public void setNumberConceptSchemes(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, num);
    }

    @Override
    public Integer getNumberCodelists() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.CODE_LIST);
    }

    public void setNumberCodelists(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.CODE_LIST, num);
    }

    @Override
    public Integer getNumberHierarchicalCodelists() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST);
    }

    public void setNumberHierarchicalCodelists(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST, num);
    }

    @Override
    public Integer getNumberMetadataStructureDefinitions() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.MSD);
    }

    public void setNumberMetadataStructureDefinitions(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.MSD, num);
    }

    @Override
    public Integer getNumberDataStructures() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.DSD);
    }

    public void setNumberDataStructures(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.DSD, num);
    }

    @Override
    public Integer getNumberStructureSets() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.STRUCTURE_SET);
    }

    public void setNumberStructureSets(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.STRUCTURE_SET, num);
    }

    @Override
    public Integer getNumberReportingTaxonomies() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY);
    }

    public void setNumberReportingTaxonomies(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY, num);
    }

    @Override
    public Integer getNumberProcesses() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.PROCESS);
    }

    public void setNumberProcesses(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.PROCESS, num);
    }

    @Override
    public Integer getNumberProvisions() {
        return this.structureMap.get((Object)SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT);
    }

    public void setNumberProvisions(Integer num) {
        if (num == null) {
            num = 0;
        }
        this.structureMap.put(SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT, num);
    }
}

