/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.springutil.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.util.exception.SchemaValidationException;
import org.sdmxsource.util.io.ReadableDataLocationTmp;
import org.sdmxsource.util.log.LoggingUtil;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@Component
public class XMLParser {
    private static final Logger log = Logger.getLogger(XMLParser.class);
    private static boolean enableValidation = true;
    private static Map<SDMX_SCHEMA, String> schemaLocations = new HashMap<SDMX_SCHEMA, String>();

    public static void validateXML(ReadableDataLocation sourceData, SDMX_SCHEMA schemaVersion, ReadableDataLocation ... extraLocations) throws ValidationException {
        XMLParser.validateXML(sourceData.getInputStream(), schemaVersion, extraLocations);
    }

    public static void validateXML(InputStream xml, SDMX_SCHEMA schemaVersion, ReadableDataLocation ... extraLocations) throws ValidationException {
        if (!enableValidation) {
            return;
        }
        if (!schemaLocations.containsKey((Object)schemaVersion)) {
            throw new IllegalArgumentException("Schema location has not been set for schema : " + (Object)((Object)schemaVersion));
        }
        String[] locations = schemaLocations.get((Object)schemaVersion).split(",");
        int addLength = locations.length;
        if (extraLocations != null) {
            addLength += extraLocations.length;
        }
        ReadableDataLocation[] schemaURI = new ReadableDataLocation[addLength];
        for (int i = 0; i < addLength; ++i) {
            if (i < locations.length) {
                try {
                    ClassPathResource cpr = new ClassPathResource(locations[i]);
                    schemaURI[i] = new ReadableDataLocationTmp(cpr.getURI());
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("Resource could not be found : " + locations[i] + "\n Error Msg :" + e.getMessage());
                }
            }
            schemaURI[i] = extraLocations[i - locations.length];
        }
        XMLParser.validateXML(xml, schemaURI);
    }

    public static void validateXML(InputStream xmlLocation, ReadableDataLocation ... schemaLocation) throws ValidationException {
        if (!enableValidation) {
            LoggingUtil.debug(log, "SKIP VALIDATION (DISABLED)");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validate XML : " + xmlLocation.toString() + " against schema in location(s):");
            for (int i = 0; i < schemaLocation.length; ++i) {
                log.debug(schemaLocation[i].toString());
            }
        }
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Source[] schemaSource = new Source[schemaLocation.length];
            for (int i = 0; i < schemaLocation.length; ++i) {
                schemaSource[i] = new StreamSource(schemaLocation[i].toString());
            }
            Schema schema = schemaFactory.newSchema(schemaSource);
            Validator schemaValidator = schema.newValidator();
            ErrorHandler eh = new ErrorHandler();
            schemaValidator.setErrorHandler(eh);
            StreamSource source = new StreamSource(xmlLocation);
            schemaValidator.validate(source);
            if (eh.getErrors().size() > 0) {
                StringBuffer buffer = new StringBuffer();
                for (SAXParseException ex : eh.getErrors()) {
                    String message = ex.getMessage() + "line/column: " + ex.getLineNumber() + "/" + ex.getColumnNumber();
                    buffer.append(message);
                    buffer.append(System.getProperties().getProperty("line.separator"));
                }
                throw new ValidationException(buffer.toString());
            }
        }
        catch (Throwable th) {
            throw new SchemaValidationException(th.getMessage());
        }
    }

    public void setEnableValidation(boolean enableValidation) {
        XMLParser.enableValidation = enableValidation;
    }

    static {
        schemaLocations.put(SDMX_SCHEMA.VERSION_ONE, "/xsd/1_0/SDMXMessage.xsd");
        schemaLocations.put(SDMX_SCHEMA.VERSION_TWO, "/xsd/2_0/SDMXMessage.xsd,/xsd/2_0/Extended/MetadataTechnologySDMXStructure.xsd");
        schemaLocations.put(SDMX_SCHEMA.VERSION_TWO_POINT_ONE, "/xsd/2_1/SDMXMessage.xsd");
    }

    protected static class ErrorHandler
    extends DefaultHandler {
        private List<SAXParseException> errors = new ArrayList<SAXParseException>();

        protected ErrorHandler() {
        }

        public List<SAXParseException> getErrors() {
            return this.errors;
        }

        @Override
        public void error(SAXParseException parseException) throws SAXException {
            this.errors.add(parseException);
        }

        @Override
        public void fatalError(SAXParseException parseException) throws SAXException {
            this.errors.add(parseException);
        }

        @Override
        public void warning(SAXParseException parseException) throws SAXException {
            this.errors.add(parseException);
        }
    }
}

