/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class StreamUtil {
    private static void copyNonUTF8InputStream(InputStream is, OutputStream os) {
        Writer bos = null;
        BufferedInputStream bis = null;
        try {
            int i;
            bis = new BufferedInputStream(is);
            bos = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), "UTF-8");
            byte[] bytes = new byte[1024];
            while ((i = bis.read(bytes)) > 0) {
                bos.write(new String(bytes, 0, i));
            }
            bos.flush();
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        finally {
            try {
                is.close();
                os.flush();
                os.close();
                if (bos != null) {
                    bos.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
        }
    }

    public static List<String> copyFirstXLines(InputStream stream, int numLines) {
        ArrayList<String> firstXRows = new ArrayList<String>();
        int rowCount = 0;
        boolean lastCharWasEndOfLine = false;
        StringBuffer buff = new StringBuffer();
        byte[] bytes = new byte[1024];
        boolean keepProcessing = true;
        try {
            int i;
            block2: while ((i = stream.read(bytes)) > 0 && keepProcessing) {
                for (int j = 0; j < i; ++j) {
                    byte aByte = bytes[j];
                    if (aByte == 10 || aByte == 13) {
                        if (!lastCharWasEndOfLine) {
                            lastCharWasEndOfLine = true;
                            ++rowCount;
                            firstXRows.add(buff.toString());
                            buff = new StringBuffer();
                        }
                    } else {
                        lastCharWasEndOfLine = false;
                        buff.append((char)aByte);
                    }
                    if (rowCount != numLines) continue;
                    keepProcessing = false;
                    continue block2;
                }
            }
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        return firstXRows;
    }

    public static void copyStream(InputStream is, OutputStream os) {
        StreamUtil.copyUTF8InputStream(is, os, false);
    }

    public static void copyStream(InputStream is, OutputStream os, boolean closeOuptutStream) {
        StreamUtil.copyUTF8InputStream(is, os, closeOuptutStream);
    }

    private static void copyUTF8InputStream(InputStream is, OutputStream os, boolean closeOuptutStream) {
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            int i;
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream(os);
            byte[] bytes = new byte[1024];
            while ((i = bis.read(bytes)) > 0) {
                bos.write(bytes, 0, i);
            }
            bos.flush();
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        finally {
            try {
                is.close();
                bos.flush();
                os.flush();
                if (closeOuptutStream) {
                    os.close();
                }
                if (bos != null) {
                    bos.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
        }
    }

    public static byte[] toByteArray(InputStream is) {
        ByteArrayOutputStream byteOs = null;
        BufferedOutputStream bos = null;
        try {
            int i;
            byteOs = new ByteArrayOutputStream();
            bos = new BufferedOutputStream(byteOs);
            byte[] bytes = new byte[1024];
            while ((i = is.read(bytes)) > 0) {
                bos.write(bytes, 0, i);
            }
            bos.flush();
            byte[] byArray = byteOs.toByteArray();
            return byArray;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        finally {
            try {
                is.close();
                if (byteOs != null) {
                    byteOs.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
        }
    }

    public static void closeStream(OutputStream ... out) {
        if (out == null) {
            return;
        }
        for (OutputStream currentOut : out) {
            try {
                currentOut.close();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    public static void closeStream(InputStream ... in) {
        if (in == null) {
            return;
        }
        for (InputStream currentIn : in) {
            try {
                currentIn.close();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }
}

