/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.util.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sdmxsource.util.io.SerializeUtil;

public class ErrorReport
implements Serializable {
    private static final long serialVersionUID = -5874227775868948616L;
    private Integer id;
    private String errorType;
    private List<byte[]> errorMessagesAsByteArray = new ArrayList<byte[]>();
    private ArrayList<String> errorMessage = new ArrayList();
    private static final SerializeUtil<ArrayList<String>> su = new SerializeUtil();
    private static final int CHUNK_SIZE = 1024;

    public ErrorReport() {
    }

    private ErrorReport(Throwable e) {
        this.addErrorMessage(e);
        Collections.reverse(this.errorMessage);
        this.errorMessagesAsByteArray = su.serializeAsChunkedByteArray(this.errorMessage, 1024);
    }

    private ErrorReport(String msg) {
        this.addErrorMessage(msg);
        Collections.reverse(this.errorMessage);
        this.errorMessagesAsByteArray = su.serializeAsChunkedByteArray(this.errorMessage, 1024);
    }

    private ErrorReport(String msg, Throwable e) {
        this.addErrorMessage(msg, e);
        Collections.reverse(this.errorMessage);
        this.errorMessagesAsByteArray = su.serializeAsChunkedByteArray(this.errorMessage, 1024);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    private void addErrorMessage(Throwable e) {
        if (e != null) {
            String errorMessageStr = e.getMessage();
            if (errorMessageStr == null) {
                this.errorMessage.add("Null Pointer");
            } else {
                for (String currentError : errorMessageStr.split(System.getProperty("line.separator"))) {
                    this.errorMessage.add(currentError);
                }
            }
            this.addErrorMessage(e.getCause());
        }
    }

    private void addErrorMessage(String msg) {
        this.errorMessage.add(msg);
    }

    private void addErrorMessage(String msg, Throwable e) {
        if (e != null) {
            this.errorMessage.add(msg + ": " + e.getMessage());
            this.addErrorMessage(e.getCause());
        }
    }

    public static ErrorReport build(Throwable e) {
        ErrorReport report = new ErrorReport(e);
        return report;
    }

    public static ErrorReport build(String msg) {
        ErrorReport report = new ErrorReport(msg);
        return report;
    }

    public static ErrorReport build(String msg, Throwable e) {
        ErrorReport report = new ErrorReport(msg, e);
        return report;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public List<String> getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(List<String> errorMessage) {
    }

    public List<byte[]> getSerializedErrorMessage() {
        return this.errorMessagesAsByteArray;
    }

    public void setSerializedErrorMessage(List<byte[]> ba) {
        this.errorMessagesAsByteArray = ba;
        if (this.errorMessagesAsByteArray.size() > 0) {
            this.errorMessage = su.deSerializeChunkedByteArray(ba);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.errorMessage.size(); ++i) {
            if (i > 0) {
                sb.append(System.getProperty("line.separator"));
            }
            sb.append("Caused By " + this.errorMessage.get(i));
        }
        return sb.toString();
    }

    public String getStringForHtml() {
        StringBuilder sb = new StringBuilder();
        for (String currentMessage : this.errorMessage) {
            sb.append("Caused By " + currentMessage);
        }
        return sb.toString();
    }
}

