/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.util.thread;

import org.apache.log4j.Logger;
import org.sdmxsource.util.log.LoggingUtil;

public class Lockable {
    Logger log = Logger.getLogger(Lockable.class);
    private boolean isLocked = false;
    private String lockOwner;
    private int lockCount = 0;

    public synchronized void lock() {
        if (this.lockOwner != null && this.lockOwner.equals(Thread.currentThread().getName())) {
            ++this.lockCount;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Lock requested from thread that already owns lock (" + Thread.currentThread().getName() + "), lock count = " + this.lockCount);
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Aquire lock : " + Thread.currentThread().getName());
        }
        if (this.isLocked) {
            do {
                try {
                    this.wait();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while trying to lock synchronized object");
                }
            } while (this.isLocked);
        }
        this.isLocked = true;
        this.lockCount = 0;
        this.lockOwner = Thread.currentThread().getName();
    }

    public synchronized void releaseLock(boolean fullRelease) {
        if (!this.isLocked) {
            return;
        }
        if (!Thread.currentThread().getName().equals(this.lockOwner)) {
            throw new RuntimeException(Thread.currentThread().getName() + " attempting to release a lock owned by " + this.lockOwner);
        }
        LoggingUtil.debug(this.log, "Release Lock Request:" + Thread.currentThread().getName());
        if (this.isLocked) {
            if (fullRelease) {
                LoggingUtil.debug(this.log, "Full Release");
                this.lockCount = 0;
                this.isLocked = false;
                this.notify();
            } else {
                if (this.lockCount <= 0) {
                    LoggingUtil.debug(this.log, "Lock Count " + this.lockCount + " Release Lock");
                    this.isLocked = false;
                    this.notify();
                }
                LoggingUtil.debug(this.log, "Lock Count " + this.lockCount + " Decrease Count Value by 1");
                --this.lockCount;
            }
        }
    }

    public synchronized boolean isLocked() {
        return this.isLocked;
    }
}

