/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public abstract class UriUtils {
    private static final BitSet SCHEME;
    private static final BitSet USER_INFO;
    private static final BitSet HOST;
    private static final BitSet PORT;
    private static final BitSet PATH;
    private static final BitSet SEGMENT;
    private static final BitSet QUERY;
    private static final BitSet QUERY_PARAM;
    private static final BitSet FRAGMENT;
    private static final String SCHEME_PATTERN = "([^:/?#]+):";
    private static final String HTTP_PATTERN = "(http|https):";
    private static final String USERINFO_PATTERN = "([^@/]*)";
    private static final String HOST_PATTERN = "([^/?#:]*)";
    private static final String PORT_PATTERN = "(\\d*)";
    private static final String PATH_PATTERN = "([^?#]*)";
    private static final String QUERY_PATTERN = "([^#]*)";
    private static final String LAST_PATTERN = "(.*)";
    private static final Pattern URI_PATTERN;
    private static final Pattern HTTP_URL_PATTERN;

    static {
        URI_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//(([^@/]*)@)?([^/?#:]*)(:(\\d*))?)?([^?#]*)(\\?([^#]*))?(#(.*))?");
        HTTP_URL_PATTERN = Pattern.compile("^(http|https):(//(([^@/]*)@)?([^/?#:]*)(:(\\d*))?)?([^?#]*)(\\?(.*))?");
        BitSet alpha = new BitSet(256);
        int i = 97;
        while (i <= 122) {
            alpha.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            alpha.set(i);
            ++i;
        }
        BitSet digit = new BitSet(256);
        int i2 = 48;
        while (i2 <= 57) {
            digit.set(i2);
            ++i2;
        }
        BitSet gendelims = new BitSet(256);
        gendelims.set(58);
        gendelims.set(47);
        gendelims.set(63);
        gendelims.set(35);
        gendelims.set(91);
        gendelims.set(93);
        gendelims.set(64);
        BitSet subdelims = new BitSet(256);
        subdelims.set(33);
        subdelims.set(36);
        subdelims.set(38);
        subdelims.set(39);
        subdelims.set(40);
        subdelims.set(41);
        subdelims.set(42);
        subdelims.set(43);
        subdelims.set(44);
        subdelims.set(59);
        subdelims.set(61);
        BitSet reserved = new BitSet(256);
        reserved.or(gendelims);
        reserved.or(subdelims);
        BitSet unreserved = new BitSet(256);
        unreserved.or(alpha);
        unreserved.or(digit);
        unreserved.set(45);
        unreserved.set(46);
        unreserved.set(95);
        unreserved.set(126);
        SCHEME = new BitSet(256);
        SCHEME.or(alpha);
        SCHEME.or(digit);
        SCHEME.set(43);
        SCHEME.set(45);
        SCHEME.set(46);
        USER_INFO = new BitSet(256);
        USER_INFO.or(unreserved);
        USER_INFO.or(subdelims);
        USER_INFO.set(58);
        HOST = new BitSet(256);
        HOST.or(unreserved);
        HOST.or(subdelims);
        PORT = new BitSet(256);
        PORT.or(digit);
        BitSet pchar = new BitSet(256);
        pchar.or(unreserved);
        pchar.or(subdelims);
        pchar.set(58);
        pchar.set(64);
        SEGMENT = new BitSet(256);
        SEGMENT.or(pchar);
        PATH = new BitSet(256);
        PATH.or(SEGMENT);
        PATH.set(47);
        QUERY = new BitSet(256);
        QUERY.or(pchar);
        QUERY.set(47);
        QUERY.set(63);
        QUERY_PARAM = new BitSet(256);
        QUERY_PARAM.or(pchar);
        QUERY_PARAM.set(47);
        QUERY_PARAM.set(63);
        QUERY_PARAM.clear(61);
        QUERY_PARAM.clear(43);
        QUERY_PARAM.clear(38);
        FRAGMENT = new BitSet(256);
        FRAGMENT.or(pchar);
        FRAGMENT.set(47);
        FRAGMENT.set(63);
    }

    public static String encodeUri(String uri, String encoding) throws UnsupportedEncodingException {
        Assert.notNull(uri, "'uri' must not be null");
        Assert.hasLength(encoding, "'encoding' must not be empty");
        Matcher m = URI_PATTERN.matcher(uri);
        if (m.matches()) {
            String scheme = m.group(2);
            String authority = m.group(3);
            String userinfo = m.group(5);
            String host = m.group(6);
            String port = m.group(8);
            String path = m.group(9);
            String query = m.group(11);
            String fragment = m.group(13);
            return UriUtils.encodeUriComponents(scheme, authority, userinfo, host, port, path, query, fragment, encoding);
        }
        throw new IllegalArgumentException("[" + uri + "] is not a valid URI");
    }

    public static String encodeHttpUrl(String httpUrl, String encoding) throws UnsupportedEncodingException {
        Assert.notNull(httpUrl, "'httpUrl' must not be null");
        Assert.hasLength(encoding, "'encoding' must not be empty");
        Matcher m = HTTP_URL_PATTERN.matcher(httpUrl);
        if (m.matches()) {
            String scheme = m.group(1);
            String authority = m.group(2);
            String userinfo = m.group(4);
            String host = m.group(5);
            String portString = m.group(7);
            String path = m.group(8);
            String query = m.group(10);
            return UriUtils.encodeUriComponents(scheme, authority, userinfo, host, portString, path, query, null, encoding);
        }
        throw new IllegalArgumentException("[" + httpUrl + "] is not a valid HTTP URL");
    }

    public static String encodeUriComponents(String scheme, String authority, String userinfo, String host, String port, String path, String query, String fragment, String encoding) throws UnsupportedEncodingException {
        Assert.hasLength(encoding, "'encoding' must not be empty");
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(UriUtils.encodeScheme(scheme, encoding));
            sb.append(':');
        }
        if (authority != null) {
            sb.append("//");
            if (userinfo != null) {
                sb.append(UriUtils.encodeUserInfo(userinfo, encoding));
                sb.append('@');
            }
            if (host != null) {
                sb.append(UriUtils.encodeHost(host, encoding));
            }
            if (port != null) {
                sb.append(':');
                sb.append(UriUtils.encodePort(port, encoding));
            }
        }
        sb.append(UriUtils.encodePath(path, encoding));
        if (query != null) {
            sb.append('?');
            sb.append(UriUtils.encodeQuery(query, encoding));
        }
        if (fragment != null) {
            sb.append('#');
            sb.append(UriUtils.encodeFragment(fragment, encoding));
        }
        return sb.toString();
    }

    public static String encodeScheme(String scheme, String encoding) throws UnsupportedEncodingException {
        return UriUtils.encode(scheme, encoding, SCHEME);
    }

    public static String encodeUserInfo(String userInfo, String encoding) throws UnsupportedEncodingException {
        return UriUtils.encode(userInfo, encoding, USER_INFO);
    }

    public static String encodeHost(String host, String encoding) throws UnsupportedEncodingException {
        return UriUtils.encode(host, encoding, HOST);
    }

    public static String encodePort(String port, String encoding) throws UnsupportedEncodingException {
        return UriUtils.encode(port, encoding, PORT);
    }

    public static String encodePath(String path, String encoding) throws UnsupportedEncodingException {
        return UriUtils.encode(path, encoding, PATH);
    }

    public static String encodePathSegment(String segment, String encoding) throws UnsupportedEncodingException {
        return UriUtils.encode(segment, encoding, SEGMENT);
    }

    public static String encodeQuery(String query, String encoding) throws UnsupportedEncodingException {
        return UriUtils.encode(query, encoding, QUERY);
    }

    public static String encodeQueryParam(String queryParam, String encoding) throws UnsupportedEncodingException {
        return UriUtils.encode(queryParam, encoding, QUERY_PARAM);
    }

    public static String encodeFragment(String fragment, String encoding) throws UnsupportedEncodingException {
        return UriUtils.encode(fragment, encoding, FRAGMENT);
    }

    private static String encode(String source, String encoding, BitSet notEncoded) throws UnsupportedEncodingException {
        Assert.notNull(source, "'source' must not be null");
        Assert.hasLength(encoding, "'encoding' must not be empty");
        byte[] bytes = UriUtils.encode(source.getBytes(encoding), notEncoded);
        return new String(bytes, "US-ASCII");
    }

    private static byte[] encode(byte[] source, BitSet notEncoded) {
        Assert.notNull(source, "'source' must not be null");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(source.length * 2);
        int i = 0;
        while (i < source.length) {
            int b = source[i];
            if (b < 0) {
                b += 256;
            }
            if (notEncoded.get(b)) {
                bos.write(b);
            } else {
                bos.write(37);
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                bos.write(hex1);
                bos.write(hex2);
            }
            ++i;
        }
        return bos.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String decode(String source, String encoding) throws UnsupportedEncodingException {
        Assert.notNull(source, "'source' must not be null");
        Assert.hasLength(encoding, "'encoding' must not be empty");
        int length = source.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        int i = 0;
        while (i < length) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 >= length) throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                char hex1 = source.charAt(i + 1);
                char hex2 = source.charAt(i + 2);
                int u = Character.digit(hex1, 16);
                int l = Character.digit(hex2, 16);
                bos.write((char)((u << 4) + l));
                i += 2;
                changed = true;
            } else {
                bos.write(ch);
            }
            ++i;
        }
        return changed ? new String(bos.toByteArray(), encoding) : source;
    }
}

