/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.api.constants;

public enum MESSAGE_TYPE {
    STRUCTURE("Structure"),
    REGISTRY_INTERFACE("RegistryInterface"),
    QUERY("QueryMessage"),
    GENERIC_DATA("GenericData"),
    UTILITY_DATA("UtilityData"),
    COMPACT_DATA("CompactData"),
    CROSS_SECTIONAL_DATA("CrossSectionalData"),
    GENERIC_METADATA("GenericMetadata"),
    METADATA_REPORT("MetadataReport"),
    MESSAGE_GROUP("MessageGroup"),
    SDMX_EDI("EDI"),
    ECV("ECV"),
    ERROR("Error"),
    UNKNOWN("Unknown");

    private String nodeName;

    private MESSAGE_TYPE(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public static MESSAGE_TYPE parseString(String messageType) {
        if (messageType == null) {
            throw new IllegalArgumentException("MESSAGE_TYPE.parseString can not parse null");
        }
        if (messageType.equals("StructureSpecificTimeSeriesData") || messageType.equals("StructureSpecificData")) {
            return COMPACT_DATA;
        }
        if (messageType.equals("GenericTimeSeriesData")) {
            return GENERIC_DATA;
        }
        for (MESSAGE_TYPE currentType : MESSAGE_TYPE.values()) {
            if (!currentType.getNodeName().equalsIgnoreCase(messageType)) continue;
            return currentType;
        }
        throw new IllegalArgumentException("'" + messageType + "' is not a known root node for an SDMX message");
    }
}

