/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.engine.impl;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.constants.EDI_TIME_FORMAT;
import org.sdmxsource.sdmx.ediparser.constants.MESSSAGE_FUNCTION;
import org.sdmxsource.sdmx.ediparser.engine.EdiParseEngine;
import org.sdmxsource.sdmx.ediparser.model.document.EDIMetadata;
import org.sdmxsource.sdmx.ediparser.model.document.impl.EDIDocumentPositionImpl;
import org.sdmxsource.sdmx.ediparser.model.document.impl.EDIMetadataImpl;
import org.sdmxsource.sdmx.ediparser.model.reader.EDIReader;
import org.sdmxsource.sdmx.ediparser.model.reader.impl.EDIReaderImpl;
import org.sdmxsource.sdmx.ediparser.util.EDIUtil;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyValueImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.PartyBeanImpl;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.springframework.stereotype.Service;

@Service
public class EdiParseEngineImpl
implements EdiParseEngine {
    @Override
    public EDIMetadata parseEDIMessage(ReadableDataLocation ediMessageLocation) {
        try {
            EDIStructureParserEngine parserEngine = new EDIStructureParserEngine(ediMessageLocation);
            return parserEngine.processMessage();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error while trying to read URI:" + ediMessageLocation);
        }
    }

    private class EDIStructureParserEngine {
        private String currentLine;
        private EDIReader ediReader;
        private String datasetId;
        private String keyFamilyIdentifier;
        private DATASET_ACTION datasetAction;
        private String missingValue;
        private Date datasetPreperation;
        private Date reportingPeriod;
        private Date reportingBegin;
        private Date reportingEnd;

        public EDIStructureParserEngine(ReadableDataLocation sourceData) {
            this.ediReader = new EDIReaderImpl(sourceData);
        }

        private EDIMetadata processMessage() throws IOException {
            try {
                EDIMetadata eDIMetadata = this.validateMessage();
                return eDIMetadata;
            }
            finally {
                this.ediReader.close();
            }
        }

        private EDIMetadata validateMessage() {
            Date prepDate;
            this.readNextLine();
            if (!this.ediReader.getLineType().isMessageStart()) {
                throw new ValidationException("EDI Message expected first line UNA:+.? '");
            }
            this.readNextLine();
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.INTERCHANGE_HEADER, true);
            String[] interchangeHeaderSplitOnPlus = EDIUtil.splitOnPlus(this.currentLine, 7);
            if (!interchangeHeaderSplitOnPlus[0].equals("UNOC:3")) {
                throw new ValidationException("Character set UNOC:3 expected, but was '" + interchangeHeaderSplitOnPlus[0] + "'");
            }
            String revieverIdentification = interchangeHeaderSplitOnPlus[2];
            String preperationDateTime = interchangeHeaderSplitOnPlus[3];
            String interchangeMessageRef = interchangeHeaderSplitOnPlus[4];
            String appReference = interchangeHeaderSplitOnPlus[6];
            if (preperationDateTime.length() != 11) {
                throw new ValidationException("Data preperation date expected in format yymmdd:hhmm - provided date time was:" + preperationDateTime);
            }
            DateFormat df = DateUtil.getDateFormatter("yyMMdd:hhmm");
            try {
                prepDate = df.parse(preperationDateTime);
            }
            catch (ParseException parseException) {
                throw new ValidationException("Data preperation date expected in format yymmdd:hhmm - provided date time was:" + preperationDateTime);
            }
            if (!appReference.equals("SDMX-EDI") && !appReference.equals("GESMES/TS")) {
                throw new ValidationException("Application reference expected to be SDMX-EDI or GESMES/TS but was '" + appReference + "'");
            }
            this.readNextLine();
            EDIMetadataImpl metadata = new EDIMetadataImpl(revieverIdentification, prepDate, interchangeMessageRef, appReference, this.reportingBegin, this.reportingEnd);
            int messageIdentifications = this.validateMessageInterchangeHeader(metadata, 1);
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.END_MESSAGE, true);
            String[] endMessageSplit = EDIUtil.splitOnPlus(this.currentLine, 2);
            int numLines = EDIUtil.parseStringAsInt(endMessageSplit[0]);
            if (messageIdentifications != numLines) {
                throw new ValidationException("Number of message identification segments expected to be '" + numLines + "' but was '" + messageIdentifications + "'");
            }
            String messageReference = endMessageSplit[1];
            if (!messageReference.equals(interchangeMessageRef)) {
                throw new ValidationException("End of message reference expected to be '" + interchangeMessageRef + "' but was '" + messageReference + "'");
            }
            return metadata;
        }

        private int validateMessageInterchangeHeader(EDIMetadata metadata, int currentnum) {
            int segmentStart = this.ediReader.getLineNumber();
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.MESSAGE_IDENTIFICATION, true);
            String[] splitOnPlus = EDIUtil.splitOnPlus(this.currentLine, 2);
            String messageIdentification = splitOnPlus[0];
            if (!splitOnPlus[1].equals("GESMES:2:1:E6")) {
                throw new IllegalArgumentException("Expecting GESMES:2:1:E6 but was " + splitOnPlus[1]);
            }
            this.readNextLine();
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.MESSAGE_FUNCTION, true);
            MESSSAGE_FUNCTION messageFunction = MESSSAGE_FUNCTION.getFromEdiStr(this.currentLine);
            this.readNextLine();
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.MESSAGE_AGENCY, true);
            String messageAgency = this.currentLine;
            this.readNextLine();
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.RECIEVING_AGENCY, true);
            String recievingAgency = this.currentLine;
            PartyBean sendingAgency = this.processMessageSender();
            int documentStart = this.ediReader.getLineNumber();
            if (messageFunction.isData()) {
                this.determineDatasetMetadata();
                metadata.setReportingBegin(this.reportingBegin);
                metadata.setReportingEnd(this.reportingEnd);
            }
            boolean inRecursive = false;
            ArrayList<KeyValue> datasetAttributes = new ArrayList<KeyValue>();
            while (this.currentLine != null) {
                try {
                    int scope;
                    this.readNextLine();
                    if (!messageFunction.isData()) {
                        if (this.ediReader.getLineType().isDataSegment()) {
                            documentStart = this.ediReader.getLineNumber() + 1;
                            throw new IllegalArgumentException("Message function is " + messageFunction.getEDIString() + " but mesage contains a data segment");
                        }
                    } else if (!messageFunction.isStructure() && this.ediReader.getLineType().isStructureSegment()) {
                        throw new IllegalArgumentException("Message function is " + messageFunction.getEDIString() + " but mesage contains a structure segment");
                    }
                    if (messageFunction.isData() && this.ediReader.getLineType() == EDI_PREFIX.DATASET_ATTRIBUTE_SCOPE && (scope = Integer.parseInt(this.ediReader.getCurrentLine())) == 1) {
                        this.readNextLine();
                        EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.DATASET_DATAATTRIBUTE, true);
                        while (true) {
                            this.readNextLine();
                            if (this.ediReader.getLineType() != EDI_PREFIX.DATASET_ATTRIBUTE_CODED && this.ediReader.getLineType() != EDI_PREFIX.DATASET_ATTRIBUTE_UNCODED) {
                                this.ediReader.moveBackLine();
                                break;
                            }
                            String attributeConceptId = this.ediReader.getCurrentLine();
                            String attributeValue = null;
                            if (this.ediReader.getLineType() == EDI_PREFIX.DATASET_ATTRIBUTE_CODED) {
                                this.assertMoveNext();
                                if (EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.CODE_VALUE, false)) {
                                    attributeValue = this.ediReader.getCurrentLine();
                                } else {
                                    this.ediReader.moveBackLine();
                                }
                            } else if (this.ediReader.getLineType() == EDI_PREFIX.DATASET_ATTRIBUTE_UNCODED) {
                                String compositeValue = "";
                                while (true) {
                                    this.assertMoveNext();
                                    if (!EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.STRING, false)) break;
                                    compositeValue = String.valueOf(compositeValue) + this.ediReader.parseTextString();
                                }
                                attributeValue = compositeValue;
                                this.ediReader.moveBackLine();
                            }
                            datasetAttributes.add(new KeyValueImpl(attributeValue, attributeConceptId));
                        }
                    }
                    if (!this.ediReader.getLineType().isEndMessageAdministration()) continue;
                    String[] splitMessAdminOnPlus = EDIUtil.splitOnPlus(this.currentLine, 2);
                    String numLinesString = splitMessAdminOnPlus[0];
                    int numLines = EDIUtil.parseStringAsInt(numLinesString);
                    int segmentCount = this.ediReader.getLineNumber() - segmentStart + 1;
                    if (segmentCount != numLines) {
                        throw new ValidationException("Expected segment count '" + numLines + "' does not match actual segment count '" + segmentCount + "'");
                    }
                    EDIDocumentPositionImpl documentPosition = new EDIDocumentPositionImpl(documentStart, this.ediReader.getLineNumber(), messageFunction.isStructure(), this.datasetId, messageAgency, sendingAgency, recievingAgency, this.datasetAction, this.keyFamilyIdentifier, this.missingValue, this.datasetPreperation, this.reportingPeriod, datasetAttributes);
                    metadata.addDocumentIndex(documentPosition);
                    String messageRef = splitMessAdminOnPlus[1];
                    if (!messageIdentification.equals(messageRef)) {
                        throw new ValidationException("Message ref expected to be '" + messageIdentification + "' but was '" + messageRef + "'");
                    }
                    this.readNextLine();
                    if (this.ediReader.getLineType().isMessageIdentification()) {
                        inRecursive = true;
                        return this.validateMessageInterchangeHeader(metadata, ++currentnum);
                    }
                    return currentnum;
                }
                catch (ValidationException th) {
                    if (inRecursive) {
                        throw th;
                    }
                    throw new ValidationException(th, "Error while trying to validate EDI Message:" + messageIdentification);
                }
            }
            throw new ValidationException("Message identification" + (Object)((Object)EDI_PREFIX.MESSAGE_IDENTIFICATION) + " is not terminated with an end identification " + (Object)((Object)EDI_PREFIX.END_MESSAGE_ADMINISTRATION));
        }

        private PartyBean processMessageSender() {
            this.readNextLine();
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.SENDING_AGENCY, true);
            String sendingAgency = this.currentLine;
            this.readNextLine();
            HashMap<String, String> nameMap = new HashMap<String, String>();
            String sendersMessageId = null;
            if (!EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.MESSAGE_ID_PROVIDED_BY_SENDER, false)) {
                this.ediReader.moveBackLine();
                return new PartyBeanImpl(null, sendingAgency, null, null);
            }
            sendersMessageId = this.ediReader.getCurrentLine();
            nameMap.put(Locale.ENGLISH.getLanguage(), sendersMessageId);
            int contactInfoCount = 0;
            int communicationChannellInfoCount = 0;
            ArrayList<PartyBean.ContactBean> contacts = new ArrayList<PartyBean.ContactBean>();
            HashMap<String, String> contactName = null;
            HashMap<String, String> contactRole = null;
            ArrayList<String> email = null;
            ArrayList<String> fax = null;
            ArrayList<String> telephone = null;
            ArrayList uri = null;
            ArrayList<String> x400 = null;
            while (this.ediReader.moveNext()) {
                String currentLine;
                if (this.ediReader.getLineType() == EDI_PREFIX.CONTACT_INFORMATION) {
                    String contactNameTxt;
                    if (++contactInfoCount > 3) {
                        throw new ValidationException("EDI Message can not contain more then 3 CTA+ segments (contact information)");
                    }
                    if (contactInfoCount > 1) {
                        contacts.add(new PartyBeanImpl.ContactImpl(contactName, contactRole, null, email, fax, telephone, uri, x400));
                    }
                    contactName = new HashMap<String, String>();
                    contactRole = new HashMap<String, String>();
                    email = new ArrayList<String>();
                    fax = new ArrayList<String>();
                    telephone = new ArrayList<String>();
                    uri = new ArrayList();
                    x400 = new ArrayList<String>();
                    communicationChannellInfoCount = 0;
                    currentLine = this.ediReader.getCurrentLine();
                    String[] contactInfoSplit = EDIUtil.splitOnPlus(currentLine, 2);
                    String contactRoleTxt = contactInfoSplit[0];
                    if (!(contactRoleTxt.equals("CC") || contactRoleTxt.equals("CP") || contactRoleTxt.equals("CF") || contactRoleTxt.equals("CE"))) {
                        throw new ValidationException((Object)((Object)EDI_PREFIX.CONTACT_INFORMATION) + " segment must have a contact function which must be either: CC, CP, CF, or CE - contact function provided was: " + contactRoleTxt);
                    }
                    String[] contactInfoReSplit = EDIUtil.splitOnColon(contactInfoSplit[1]);
                    if (contactInfoReSplit.length == 1) {
                        contactNameTxt = contactInfoReSplit[0];
                    } else if (contactInfoReSplit.length == 2) {
                        contactNameTxt = contactInfoReSplit[1];
                    } else {
                        throw new ValidationException("Unexpected ':' in string, expected only one colon to deliminate between the contact id and the contact name: " + currentLine);
                    }
                    contactName.put(Locale.ENGLISH.getLanguage(), contactNameTxt);
                    contactRole.put(Locale.ENGLISH.getLanguage(), contactRoleTxt);
                    continue;
                }
                if (this.ediReader.getLineType() == EDI_PREFIX.COMMUNICATION_NUMBER) {
                    if (contactInfoCount == 0) {
                        throw new ValidationException("Unexpected " + (Object)((Object)EDI_PREFIX.COMMUNICATION_NUMBER) + ", this segment must come after a contact information segment: " + (Object)((Object)EDI_PREFIX.CONTACT_INFORMATION));
                    }
                    if (++communicationChannellInfoCount > 5) {
                        throw new ValidationException("EDI Message can not contain more then 5 COM+ segments per CTA+ segment (communication number)");
                    }
                    currentLine = this.ediReader.getCurrentLine();
                    String[] numberChannelSplit = EDIUtil.splitOnColon(currentLine, 2);
                    String communicationNumber = numberChannelSplit[0];
                    String communicationChannel = numberChannelSplit[1];
                    if (communicationNumber.length() > 512) {
                        throw new ValidationException((Object)((Object)EDI_PREFIX.COMMUNICATION_NUMBER) + " contains a communication number which is longer then the maximum length of 512 characters.  Actual length : " + communicationNumber.length());
                    }
                    if (communicationChannel.equals("EM")) {
                        email.add(communicationNumber);
                        continue;
                    }
                    if (communicationChannel.equals("TE")) {
                        telephone.add(communicationNumber);
                        continue;
                    }
                    if (communicationChannel.equals("FX")) {
                        fax.add(communicationNumber);
                        continue;
                    }
                    if (communicationChannel.equals("XF")) {
                        x400.add(communicationNumber);
                        continue;
                    }
                    throw new ValidationException((Object)((Object)EDI_PREFIX.COMMUNICATION_NUMBER) + " contains an invalid comminication channel of '" + communicationChannel + "' - allowed channels are EM, TE, FX, or XF");
                }
                if (contactInfoCount > 0) {
                    contacts.add(new PartyBeanImpl.ContactImpl(contactName, contactRole, null, email, fax, telephone, uri, x400));
                }
                this.ediReader.moveBackLine();
                return new PartyBeanImpl(null, sendingAgency, contacts, null);
            }
            return new PartyBeanImpl(nameMap, sendingAgency, null, null);
        }

        private boolean readNextLine() {
            this.currentLine = this.ediReader.getNextLine();
            return this.currentLine != null;
        }

        private void assertMoveNext() {
            if (!this.ediReader.moveNext()) {
                throw new ValidationException("Unexpected end of file" + this.ediReader.getCurrentLine());
            }
        }

        private void determineDatasetMetadata() {
            this.readNextLine();
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.DATA_START, true);
            this.datasetId = this.ediReader.getCurrentLine();
            this.assertMoveNext();
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.DATASET_ACTION, true);
            if (this.ediReader.getCurrentLine().equals("6")) {
                this.datasetAction = DATASET_ACTION.DELETE;
            } else if (this.ediReader.getCurrentLine().equals("7")) {
                this.datasetAction = DATASET_ACTION.REPLACE;
            } else {
                throw new ValidationException("Unknown EDI-TS Dataset Action value : " + this.ediReader.getCurrentLine());
            }
            this.assertMoveNext();
            this.reportingBegin = null;
            this.reportingEnd = null;
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm:ssS");
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.DATASET_DATETIME, true);
            String currentLine = this.ediReader.getCurrentLine();
            if (!currentLine.startsWith("242:")) {
                throw new ValidationException("Could not parse dataset preperation date '" + currentLine + "' expecting '" + (Object)((Object)EDI_PREFIX.DATASET_DATETIME) + "242:' but did not find '242:'");
            }
            if (this.ediReader.getCurrentLine().length() <= 4) {
                throw new ValidationException("Could not parse dataset preperation date '" + currentLine + "' expecting '242:' to be followed by a date in the following format 'yyyyMMddHHmm:SSS' example : 19811807810530:000 (18th July 1981, 05:30am)");
            }
            String datePart = currentLine.substring(4, currentLine.length());
            try {
                this.datasetPreperation = df.parse(datePart);
            }
            catch (ParseException parseException) {
                throw new ValidationException("Could not parse dataset preperation date '" + datePart + "', please ensure format is yyyyMMddHHmm:SSS example : 19811807810530:000 (18th July 1981, 05:30am)");
            }
            this.assertMoveNext();
            if (EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.DATASET_DATETIME, false)) {
                currentLine = this.ediReader.getCurrentLine();
                if (!currentLine.startsWith("Z02:")) {
                    throw new ValidationException("Could not parse dataset preperation date '" + currentLine + "' expecting '" + (Object)((Object)EDI_PREFIX.DATASET_DATETIME) + "242:' but did not find 'Z02:'");
                }
                if (this.ediReader.getCurrentLine().length() <= 4) {
                    throw new ValidationException("Could not parse dataset preperation date '" + currentLine + "' expecting 'Z02:' to be followed by a date in the following format 'yyyyMMddHHmm:SSS' example : 19811807810530:000 (18th July 1981, 05:30am)");
                }
                int dateFormatStart = currentLine.lastIndexOf(":");
                String timeFormatString = currentLine.substring(dateFormatStart + 1);
                EDI_TIME_FORMAT timeFormat = EDI_TIME_FORMAT.parseString(timeFormatString);
                datePart = currentLine.substring(4, dateFormatStart);
                this.reportingBegin = timeFormat.parseDate(datePart);
                this.reportingEnd = timeFormat.isRange() ? timeFormat.parseEndDate(datePart) : this.reportingBegin;
                this.reportingPeriod = this.reportingBegin;
                this.reportingEnd = DateUtil.moveToEndofPeriod(this.reportingEnd, timeFormat.getSdmxTimeFormat());
            } else {
                this.ediReader.moveBackLine();
            }
            this.assertMoveNext();
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.DSD_REFERENCE, true);
            this.keyFamilyIdentifier = this.ediReader.getCurrentLine();
            this.assertMoveNext();
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.DATASET_SEND_METHOD, true);
            this.assertMoveNext();
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.DATASET_MISSING_VALUE_SYMBOL, true);
            this.missingValue = this.ediReader.getCurrentLine();
        }
    }
}

