/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.engine.writer.impl;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.constants.MESSSAGE_FUNCTION;
import org.sdmxsource.sdmx.ediparser.model.impl.InterchangeHeader;
import org.sdmxsource.sdmx.ediparser.model.impl.MessageIdentification;

public abstract class AbstractEdiOutputEngine {

    protected class InnerEngine {
        private PrintWriter writer;
        private int numLines;
        private int numMessages;
        private InterchangeHeader header;
        private MessageIdentification messageId;

        public InnerEngine(OutputStream out) {
            this.writer = new PrintWriter(new BufferedOutputStream(out));
        }

        protected void writeInterchangeAdministration(InterchangeHeader header) throws IOException {
            this.header = header;
            this.writer.println((Object)((Object)EDI_PREFIX.MESSAGE_START) + "'");
            this.writer.println(header.toString());
        }

        protected void writeMessageIdentification(MessageIdentification messageId) throws IOException {
            this.messageId = messageId;
            this.numLines = 1;
            ++this.numMessages;
            this.writeSegment(messageId.toString());
        }

        protected void writeMessageFunction(MESSSAGE_FUNCTION messagefunctionEnum) throws IOException {
            this.writeSegment(String.valueOf(EDI_PREFIX.MESSAGE_FUNCTION.toString()) + messagefunctionEnum.getEDIString() + "'");
        }

        protected void writeStructureMaintAgency(String agencyId) throws IOException {
            this.writeSegment(String.valueOf(EDI_PREFIX.MESSAGE_AGENCY.toString()) + agencyId + "'");
        }

        protected void writeRecievingAgency(String agencyId) throws IOException {
            this.writeSegment(String.valueOf(EDI_PREFIX.RECIEVING_AGENCY.toString()) + agencyId + "'");
        }

        protected void writeSendingAgency(String agencyId) throws IOException {
            this.writeSegment(String.valueOf(EDI_PREFIX.SENDING_AGENCY.toString()) + agencyId + "'");
        }

        protected void writeEndMessageAdministration() {
            this.writeSegment(String.valueOf(EDI_PREFIX.END_MESSAGE_ADMINISTRATION.toString()) + this.numLines + "+" + this.messageId.getMessageRefNum() + "'");
        }

        protected void writeEndMessage() {
            this.writer.println(String.valueOf(EDI_PREFIX.END_MESSAGE.toString()) + this.numMessages + "+" + this.header.getInterchangeRef() + "'");
        }

        protected void writeSegment(String str) {
            this.writer.println(str);
            ++this.numLines;
        }

        public void closeResources() {
            this.writer.close();
        }
    }
}

