/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.model.impl;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.engine.EdiParseEngine;
import org.sdmxsource.sdmx.ediparser.engine.reader.impl.EDIDataReaderEngineImpl;
import org.sdmxsource.sdmx.ediparser.model.EDIWorkspace;
import org.sdmxsource.sdmx.ediparser.model.document.EDIDataDocument;
import org.sdmxsource.sdmx.ediparser.model.document.EDIDocumentPosition;
import org.sdmxsource.sdmx.ediparser.model.document.EDIMetadata;
import org.sdmxsource.sdmx.ediparser.model.document.impl.EDIDataDocumentImpl;
import org.sdmxsource.sdmx.ediparser.model.document.impl.EDIStructureDocumentImpl;
import org.sdmxsource.sdmx.ediparser.model.reader.EDIDataReader;
import org.sdmxsource.sdmx.ediparser.model.reader.impl.FileReaderImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.HeaderImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.PartyBeanImpl;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.util.io.WriteableDataLocationTmp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.beans.factory.aspectj.ConfigurableObject;

@Configurable(preConstruction=true)
public class EDIWorkspaceImpl
implements EDIWorkspace,
ConfigurableObject {
    @Autowired
    private EdiParseEngine ediParseEngine;
    private List<EDIDataDocument> dataDocuments;
    private List<SdmxBeans> beans;
    private Set<MaintainableRefBean> keyFamilyReferences;
    private EDIMetadata ediMetadata;
    private HeaderBean headerBean;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public EDIWorkspaceImpl(ReadableDataLocation ediDocument) {
        ReadableDataLocation readableDataLocation = ediDocument;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)readableDataLocation);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if ((this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && this != null && this.getClass().isAnnotationPresent(Configurable.class) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        this.dataDocuments = new ArrayList<EDIDataDocument>();
        this.beans = new ArrayList<SdmxBeans>();
        this.keyFamilyReferences = new HashSet<MaintainableRefBean>();
        this.ediMetadata = this.ediParseEngine.parseEDIMessage(ediDocument);
        FileReaderImpl fr = new FileReaderImpl(ediDocument, "(?<!\\?)\\'");
        int idx = 0;
        for (EDIDocumentPosition documentPosition : this.ediMetadata.getDocumentIndex()) {
            int start = documentPosition.getStartLine();
            documentPosition.getEndLine();
            WriteableDataLocationTmp wdl = new WriteableDataLocationTmp();
            PrintWriter pw = new PrintWriter(wdl.getOutputStream());
            while (fr.moveNext()) {
                idx = fr.getLineNumber();
                if (idx < start) continue;
                String line = fr.getCurrentLine();
                pw.println(String.valueOf(line) + "'");
                if (line.startsWith(EDI_PREFIX.END_MESSAGE_ADMINISTRATION.toString())) break;
            }
            pw.close();
            if (documentPosition.isData()) {
                EDIDataDocumentImpl dataDocument = new EDIDataDocumentImpl(wdl, documentPosition, this.ediMetadata);
                this.dataDocuments.add(dataDocument);
                this.keyFamilyReferences.add(dataDocument.getDataReader().getDatasetHeaderBean().getDataStructureReference().getStructureReference().getMaintainableReference());
                continue;
            }
            EDIStructureDocumentImpl doc = new EDIStructureDocumentImpl(wdl, documentPosition, this.ediMetadata);
            try {
                this.beans.add(doc.getSdmxBeans());
            }
            finally {
                wdl.close();
            }
        }
        this.createHeader();
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    private void createHeader() {
        ArrayList<DatasetStructureReferenceBean> structure = new ArrayList<DatasetStructureReferenceBean>();
        ArrayList<PartyBean> receiver = new ArrayList<PartyBean>();
        PartyBean sender = null;
        HashSet<String> allreceivers = new HashSet<String>();
        for (EDIDataDocument currentReader : this.dataDocuments) {
            EDIDataReader reader = currentReader.getDataReader();
            DatasetHeaderBean header = reader.getDatasetHeaderBean();
            structure.add(header.getDataStructureReference());
            sender = reader.getSendingAgency();
            String recievingAgency = reader.getRecievingAgency();
            if (allreceivers.contains(recievingAgency)) continue;
            allreceivers.add(recievingAgency);
            receiver.add(new PartyBeanImpl(null, recievingAgency, null, null));
        }
        this.headerBean = new HeaderImpl(this.ediMetadata.getInterchangeReference(), this.ediMetadata.getDateOfPreparation(), this.ediMetadata.getReportingBegin(), this.ediMetadata.getReportingEnd(), receiver, sender);
    }

    @Override
    public HeaderBean getHeader() {
        return this.headerBean;
    }

    @Override
    public List<DatasetHeaderBean> getDatasetHeaders() {
        ArrayList<DatasetHeaderBean> returnList = new ArrayList<DatasetHeaderBean>();
        for (EDIDataDocument currentReader : this.dataDocuments) {
            EDIDataReader reader = currentReader.getDataReader();
            DatasetHeaderBean header = reader.getDatasetHeaderBean();
            returnList.add(header);
        }
        return returnList;
    }

    @Override
    public DataReaderEngine getDataReader(SdmxBeanRetrievalManager beanRetrieval) {
        ArrayList<EDIDataReader> engines = new ArrayList<EDIDataReader>();
        for (EDIDataDocument dataDocument : this.dataDocuments) {
            engines.add(dataDocument.getDataReader());
        }
        return new EDIDataReaderEngineImpl(this.headerBean, beanRetrieval, engines);
    }

    @Override
    public DataReaderEngine getDataReader(DataStructureBean keyFamily) {
        if (!this.hasData()) {
            throw new IllegalArgumentException("Attempting to read data from an EDI file that does not contain data");
        }
        if (!this.keyFamilyReferences.contains(keyFamily.asReference().getMaintainableReference())) {
            return null;
        }
        ArrayList<EDIDataReader> engines = new ArrayList<EDIDataReader>();
        for (EDIDataDocument dataDocument : this.dataDocuments) {
            if (!dataDocument.getDataReader().getDatasetHeaderBean().getDataStructureReference().getStructureReference().getMaintainableReference().equals(keyFamily.asReference().getMaintainableReference())) continue;
            engines.add(dataDocument.getDataReader());
        }
        return new EDIDataReaderEngineImpl(this.headerBean, keyFamily, engines);
    }

    public List<EDIDataDocument> getEDIDataDocument() {
        return new ArrayList<EDIDataDocument>(this.dataDocuments);
    }

    @Override
    public List<SdmxBeans> getBeans() {
        return new ArrayList<SdmxBeans>(this.beans);
    }

    @Override
    public SdmxBeans getMergedBeans() {
        if (!this.hasStructures()) {
            throw new RuntimeException("There are no structures within this EDI file.");
        }
        if (this.beans.size() == 1) {
            return this.beans.get(0);
        }
        SdmxBeansImpl returnBeans = new SdmxBeansImpl(this.headerBean);
        for (SdmxBeans currentBeans : this.beans) {
            returnBeans.merge(currentBeans);
        }
        return returnBeans;
    }

    @Override
    public boolean hasData() {
        return this.dataDocuments.size() > 0;
    }

    @Override
    public boolean hasStructures() {
        return this.beans.size() > 0;
    }

    static {
        Factory factory = new Factory("EDIWorkspaceImpl.java", Class.forName("org.sdmxsource.sdmx.ediparser.model.impl.EDIWorkspaceImpl"));
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 81);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.sdmxsource.sdmx.ediparser.model.impl.EDIWorkspaceImpl", "org.sdmxsource.sdmx.api.util.ReadableDataLocation:", "ediDocument:", ""), 81);
    }
}

