/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.model.impl;

import java.util.Date;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.model.impl.AbstractEdiModel;
import org.sdmxsource.util.ObjectUtil;

public class InterchangeHeader
extends AbstractEdiModel {
    private String syntaxIdentifier = "UNOC";
    private String syntaxVersion = "3";
    private String senderIdentification;
    private String receiverIdentification;
    private Date dateOfPreperation;
    private String interchangeRef;
    private String applicationRef = "SDMX-EDI";
    private String testIndicator;

    public InterchangeHeader(String senderIdentification, String receiverIdentification, Date dateOfPreperation, int interchangeRefNum, String testIndicator) {
        this.interchangeRef = "IREF" + this.prependZeros(interchangeRefNum, 6);
        this.setupHeader(senderIdentification, receiverIdentification, dateOfPreperation, this.interchangeRef, testIndicator);
    }

    public InterchangeHeader(String senderIdentification, String receiverIdentification, Date dateOfPreperation, String interchangeRef, int defaultInterchangeRefNum, String testIndicator) {
        if (!this.doesInterchageRefConformToStandard(interchangeRef)) {
            this.interchangeRef = "IREF" + this.prependZeros(defaultInterchangeRefNum, 6);
        }
        this.setupHeader(senderIdentification, receiverIdentification, dateOfPreperation, interchangeRef, testIndicator);
    }

    private void setupHeader(String senderIdentification, String receiverIdentification, Date dateOfPreperation, String interchangeRef, String testIndicator) {
        if (!ObjectUtil.validString(senderIdentification)) {
            throw new ValidationException("Can not write EDI Interchange Header, no sender identification provided");
        }
        if (!ObjectUtil.validString(receiverIdentification)) {
            throw new ValidationException("Can not write EDI Interchange Header, no receiver identification provided");
        }
        if (dateOfPreperation == null) {
            dateOfPreperation = new Date();
        }
        this.senderIdentification = senderIdentification;
        this.receiverIdentification = receiverIdentification;
        this.dateOfPreperation = dateOfPreperation;
        this.interchangeRef = interchangeRef;
        this.testIndicator = testIndicator;
    }

    private boolean doesInterchageRefConformToStandard(String iref) {
        if (iref.length() != 10) {
            return false;
        }
        if (!iref.substring(0, 4).equals("IREF")) {
            return false;
        }
        int i = 4;
        while (i < iref.length()) {
            char c = iref.charAt(i);
            if (!Character.isDigit(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getInterchangeRef() {
        return this.interchangeRef;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)EDI_PREFIX.INTERCHANGE_HEADER);
        sb.append(this.syntaxIdentifier);
        sb.append(":");
        sb.append(this.syntaxVersion);
        sb.append("+");
        sb.append(this.senderIdentification);
        sb.append("+");
        sb.append(this.receiverIdentification);
        sb.append("+");
        sb.append(this.formatDate(this.dateOfPreperation));
        sb.append("+");
        sb.append(this.interchangeRef);
        sb.append("+");
        sb.append("+");
        sb.append(this.applicationRef);
        if (this.testIndicator != null) {
            sb.append("+");
            sb.append("+");
            sb.append("+");
            sb.append("+");
            sb.append(this.testIndicator);
        }
        sb.append("'");
        return sb.toString();
    }
}

