/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import org.sdmx.resources.sdmxml.schemas.v21.common.TimeRangeValueType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.base.TimeRangeBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TimeRangeMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class TimeRangeBeanImpl
extends SdmxStructureBeanImpl
implements TimeRangeBean {
    private static final long serialVersionUID = -1105081442071478375L;
    private SdmxDate startDate;
    private SdmxDate endDate;
    private boolean isRange;
    private boolean isStartInclusive;
    private boolean isEndInclusive;

    public TimeRangeBeanImpl(TimeRangeMutableBean mutable, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.TIME_RANGE, parent);
        if (mutable.getStartDate() != null) {
            this.startDate = new SdmxDateImpl(mutable.getStartDate(), TIME_FORMAT.DATE_TIME);
        }
        if (mutable.getEndDate() != null) {
            this.endDate = new SdmxDateImpl(mutable.getEndDate(), TIME_FORMAT.DATE_TIME);
        }
        this.isRange = mutable.isRange();
        this.isStartInclusive = mutable.isStartInclusive();
        this.isEndInclusive = mutable.isEndInclusive();
    }

    public TimeRangeBeanImpl(TimeRangeValueType type, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.TIME_RANGE, parent);
        if (type.getAfterPeriod() != null) {
            this.isRange = false;
            this.endDate = new SdmxDateImpl(type.getAfterPeriod().getObjectValue().toString());
            this.isEndInclusive = type.getAfterPeriod().getIsInclusive();
        }
        if (type.getBeforePeriod() != null) {
            this.isRange = false;
            this.startDate = new SdmxDateImpl(type.getBeforePeriod().getObjectValue().toString());
            this.isStartInclusive = type.getBeforePeriod().getIsInclusive();
        }
        if (type.getStartPeriod() != null) {
            this.isRange = true;
            this.startDate = new SdmxDateImpl(type.getStartPeriod().getObjectValue().toString());
            this.isStartInclusive = type.getStartPeriod().getIsInclusive();
        }
        if (type.getEndPeriod() != null) {
            this.isRange = true;
            this.endDate = new SdmxDateImpl(type.getEndPeriod().getObjectValue().toString());
            this.isEndInclusive = type.getEndPeriod().getIsInclusive();
        }
        this.validate();
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            TimeRangeBean that = (TimeRangeBean)bean;
            if (!ObjectUtil.equivalent(this.startDate, that.getStartDate())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.endDate, that.getEndDate())) {
                return false;
            }
            if (this.isRange != that.isRange()) {
                return false;
            }
            if (this.isStartInclusive != that.isStartInclusive()) {
                return false;
            }
            return this.isEndInclusive == that.isEndInclusive();
        }
        return false;
    }

    private void validate() throws ValidationException {
        if (this.startDate == null && this.endDate == null) {
            throw new ValidationException("Time period must define at least one date");
        }
        if (this.isRange) {
            if (this.startDate == null || this.endDate == null) {
                throw new ValidationException("Time period with a range requires both a start and end period");
            }
            if (this.startDate.isLater(this.endDate)) {
                throw new ValidationException("Time range can not specify start period after end period");
            }
        } else if (this.startDate != null && this.endDate != null) {
            throw new ValidationException("Time period can not define both a before period and after period");
        }
    }

    @Override
    public boolean isRange() {
        return this.isRange;
    }

    @Override
    public SdmxDate getStartDate() {
        return this.startDate;
    }

    @Override
    public SdmxDate getEndDate() {
        return this.endDate;
    }

    @Override
    public boolean isStartInclusive() {
        return this.isStartInclusive;
    }

    @Override
    public boolean isEndInclusive() {
        return this.isEndInclusive;
    }
}

