/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist;

import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MutableBean;
import org.sdmxsource.sdmx.api.model.mutable.reference.CodelistRefMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class CodelistRefBeanImpl
extends SdmxStructureBeanImpl
implements CodelistRefBean {
    private static final long serialVersionUID = 1L;
    private String alias;
    private CrossReferenceBean codelistReference;

    public CodelistRefBeanImpl(CodelistRefMutableBean bean, SdmxStructureBean parent) {
        super((MutableBean)bean, parent);
        this.alias = bean.getAlias();
        if (bean.getCodelistReference() != null) {
            this.codelistReference = new CrossReferenceBeanImpl((SDMXBean)this, bean.getCodelistReference());
        }
        this.validate();
    }

    public CodelistRefBeanImpl(String agencyId, String maintainableId, String version, String alias, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.CODE_LIST_REF, parent);
        this.alias = alias;
        this.codelistReference = new CrossReferenceBeanImpl(this, agencyId, maintainableId, version, SDMX_STRUCTURE_TYPE.CODE_LIST);
        this.validate();
    }

    public CodelistRefBeanImpl(String urn, String alias, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.CODE_LIST_REF, parent);
        this.alias = alias;
        this.codelistReference = new CrossReferenceBeanImpl((SDMXBean)this, urn);
        this.validate();
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public CrossReferenceBean getCodelistReference() {
        return this.codelistReference;
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            CodelistRefBean that = (CodelistRefBean)bean;
            if (!ObjectUtil.equivalent(this.alias, that.getAlias())) {
                return false;
            }
            return super.equivalent(this.codelistReference, that.getCodelistReference());
        }
        return false;
    }

    private void validate() throws ValidationException {
        if (this.codelistReference == null) {
            throw new ValidationException("HierarchicalCodelist, Codelist Reference Missing a Reference");
        }
        if (this.codelistReference.getTargetReference() != SDMX_STRUCTURE_TYPE.CODE_LIST) {
            throw new ValidationException("Referenced structure should be " + SDMX_STRUCTURE_TYPE.CODE_LIST.getType() + " but is declared as " + this.codelistReference.getTargetReference().getType());
        }
    }
}

