/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodeRefType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.HierarchicalCodeType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistRefBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.LevelBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.mutable.reference.CodeRefMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.IdentifiableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class HierarchicalCodeBeanImpl
extends IdentifiableBeanImpl
implements HierarchicalCodeBean {
    private static final long serialVersionUID = 1L;
    private List<HierarchicalCodeBean> codeRefs = new ArrayList<HierarchicalCodeBean>();
    private CrossReferenceBean codeReference;
    private String codelistAliasRef;
    private String codeId;
    private SdmxDate validFrom;
    private SdmxDate validTo;
    private String levelRef;
    private transient LevelBean level;

    public HierarchicalCodeBeanImpl(CodeRefMutableBean bean, SdmxStructureBean parent) {
        super(bean, parent);
        try {
            if (bean.getCodeReference() != null) {
                this.codeReference = new CrossReferenceBeanImpl((SDMXBean)this, bean.getCodeReference());
            }
            this.codelistAliasRef = bean.getCodelistAliasRef();
            this.codeId = bean.getCodeId();
            if (bean.getCodeRefs() != null) {
                for (CodeRefMutableBean currentCodeRef : bean.getCodeRefs()) {
                    this.codeRefs.add(new HierarchicalCodeBeanImpl(currentCodeRef, (SdmxStructureBean)this));
                }
            }
        }
        catch (Throwable th) {
            throw new ValidationException(th, "Error creating structure: " + this.toString());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
    }

    public HierarchicalCodeBeanImpl(HierarchicalCodeType codeRef, SdmxStructureBean parent) {
        super(codeRef, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODE, parent);
        if (codeRef.getCodeID() != null && codeRef.getCodeID().getRef() != null && codeRef.getCodelistAliasRef() != null) {
            this.codeId = codeRef.getCodeID().getRef().getId();
            this.codelistAliasRef = codeRef.getCodelistAliasRef();
        }
        if (codeRef.getLevel() != null) {
            this.levelRef = RefUtil.createLocalIdReference(codeRef.getLevel());
        }
        if (codeRef.getCode() != null) {
            this.codeReference = RefUtil.createReference(this, codeRef.getCode());
        }
        if (codeRef.getValidFrom() != null) {
            this.validFrom = new SdmxDateImpl(codeRef.getValidFrom().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (codeRef.getValidTo() != null) {
            this.validTo = new SdmxDateImpl(codeRef.getValidTo().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (codeRef.getHierarchicalCodeList() != null) {
            for (HierarchicalCodeType currentCodeRef : codeRef.getHierarchicalCodeList()) {
                this.codeRefs.add(new HierarchicalCodeBeanImpl(currentCodeRef, (SdmxStructureBean)this));
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
    }

    public HierarchicalCodeBeanImpl(CodeRefType codeRef, SdmxStructureBean parent) {
        super(HierarchicalCodeBeanImpl.generateId(codeRef, parent), SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODE, parent);
        if (ObjectUtil.validString(codeRef.getURN())) {
            this.codeReference = new CrossReferenceBeanImpl((SDMXBean)this, codeRef.getURN());
        }
        this.codeId = codeRef.getCodeID();
        this.codelistAliasRef = codeRef.getCodelistAliasRef();
        if (codeRef.getCodeRefList() != null) {
            for (CodeRefType currentCodeRef : codeRef.getCodeRefList()) {
                this.codeRefs.add(new HierarchicalCodeBeanImpl(currentCodeRef, (SdmxStructureBean)this));
            }
        }
        if (codeRef.getValidFrom() != null) {
            this.validFrom = new SdmxDateImpl(codeRef.getValidFrom().toString());
        }
        if (codeRef.getValidTo() != null) {
            this.validTo = new SdmxDateImpl(codeRef.getValidTo().toString());
        }
        if (codeRef.getLevelRef() != null) {
            HierarchyBean hierarchy = this.getParent(HierarchyBean.class, false);
            LevelBean level = hierarchy.getLevel();
            this.levelRef = "";
            while (!level.getId().equals(codeRef.getLevelRef())) {
                this.levelRef = this.levelRef + level.getId() + ".";
                level = level.getChildLevel();
            }
            this.levelRef = this.levelRef + level.getId();
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
    }

    private static String generateId(CodeRefType codeRef, SDMXBean parent) {
        if (ObjectUtil.validString(codeRef.getNodeAliasID())) {
            return codeRef.getNodeAliasID();
        }
        List<HierarchicalCodeBean> currentChildren = null;
        if (parent.getStructureType() == SDMX_STRUCTURE_TYPE.HIERARCHY) {
            currentChildren = ((HierarchyBean)parent).getHierarchicalCodeBeans();
        } else {
            ((HierarchicalCodeBean)parent).getCodeRefs();
        }
        String codeId = null;
        if (ObjectUtil.validString(codeRef.getCodeID())) {
            codeId = codeRef.getCodeID();
        } else {
            if (!ObjectUtil.validString(codeRef.getURN())) {
                throw new ValidationException("Could not generate Hierarchical Code Id - no NodeAlias Id, Code ID, or Code URN found");
            }
            StructureReferenceBeanImpl localXsRef = new StructureReferenceBeanImpl(codeRef.getURN());
            if (localXsRef.getTargetReference() != SDMX_STRUCTURE_TYPE.CODE) {
                throw new ValidationException(ExceptionCode.REFERENCE_ERROR_UNEXPECTED_STRUCTURE, SDMX_STRUCTURE_TYPE.CODE.getType(), localXsRef.getTargetReference().getType());
            }
            codeId = localXsRef.getChildReference().getId();
        }
        String inputId = codeId;
        int i = 2;
        while (!HierarchicalCodeBeanImpl.isCodeIdUnique(currentChildren, codeId)) {
            codeId = inputId + "_" + i;
            ++i;
        }
        return codeId;
    }

    private static boolean isCodeIdUnique(List<HierarchicalCodeBean> currentChildren, String codeId) {
        if (currentChildren != null) {
            for (HierarchicalCodeBean currentChild : currentChildren) {
                if (!currentChild.getId().equals(codeId)) continue;
                return false;
            }
        }
        return true;
    }

    private void validate() {
        HierarchyBean heirarchy;
        if (ObjectUtil.validString(this.codelistAliasRef)) {
            if (!ObjectUtil.validString(this.codeId)) {
                throw new ValidationException(ExceptionCode.CODE_REF_MISSING_CODE_ID, this.toString());
            }
            if (this.codeReference != null) {
                CrossReferenceBean generatedReference = this.generateCodelistReference();
                if (!generatedReference.getTargetUrn().equals(this.codeReference.getTargetUrn())) {
                    throw new ValidationException("Code reference was supplied both by a codelist alias ('" + this.codelistAliasRef + "') and code Id ('" + this.codeId + "'), and by a code URN ('" + this.codeReference.getTargetUrn() + "') - " + "the two references contradict each other");
                }
            } else {
                this.codeReference = this.getCodeReference();
                if (this.codeReference == null) {
                    throw new ValidationException("Could not resolve reference to codelist with alias : " + this.codelistAliasRef);
                }
            }
        } else if (this.codeReference != null) {
            if (ObjectUtil.validString(this.codeId) && !this.codeReference.getChildReference().getId().equals(this.codeId)) {
                throw new ValidationException("Code id was supplied both by a code Id ('" + this.codeId + "'), and by a code URN ('" + this.codeReference.getTargetUrn() + "') - " + "the two references contradict each other");
            }
            if (this.codeReference.getTargetReference() != SDMX_STRUCTURE_TYPE.CODE) {
                throw new ValidationException(ExceptionCode.REFERENCE_ERROR_UNEXPECTED_STRUCTURE, SDMX_STRUCTURE_TYPE.CODE.getType(), this.codeReference.getTargetReference().getType());
            }
            this.codeId = this.codeReference.getChildReference().getId();
        } else {
            throw new ValidationException(ExceptionCode.CODE_REF_MISSING_CODE_REFERENCE, this.toString());
        }
        if (this.validFrom != null && this.validTo != null && this.validFrom.isLater(this.validTo)) {
            throw new ValidationException("Hierarchical Code Error - Valid from can not be after valid to");
        }
        if (ObjectUtil.validString(this.levelRef)) {
            heirarchy = this.getParent(HierarchyBean.class, false);
            String[] levelSplit = this.levelRef.split("\\.");
            this.level = heirarchy.getLevelAtPosition(levelSplit.length);
            if (this.level == null) {
                throw new ValidationException("Hierarchical Code Error - Could not find level with id '" + this.levelRef + "', ensure the Level Reference is dot '.' seperated e.g. L1.L2.L3 (where L1 is the Id of the first level, L2 is the Id of the second level and L3 is the id of the third level) ");
            }
            String levelFullId = this.level.getFullIdPath(false);
            if (!levelFullId.equals(this.levelRef)) {
                throw new ValidationException("Hierarchical Code Error - Could not find level with id '" + this.levelRef + "', Level id at depth '" + levelSplit.length + "' is '" + levelFullId + "', ensure the Level Reference is dot '.' seperated e.g. L1.L2.L3 (where L1 is the Id of the first level, L2 is the Id of the second level and L3 is the id of the third level) ");
            }
        } else {
            heirarchy = this.getParent(HierarchyBean.class, false);
            if (heirarchy.hasFormalLevels()) {
                int depthOfHierarchy = this.getLevelInHierarchy();
                this.level = heirarchy.getLevelAtPosition(depthOfHierarchy);
                if (this.level == null) {
                    throw new ValidationException("Hierarchical Code Error - Hierarchy states that there are formal levels, but there is no level defined for a hierarchy of depth '" + depthOfHierarchy + 1 + "'");
                }
            }
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            HierarchicalCodeBean that = (HierarchicalCodeBean)bean;
            if (!super.equivalent(this.codeRefs, that.getCodeRefs())) {
                return false;
            }
            if (!super.equivalent(this.codeReference, that.getCodeReference())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.codeId, that.getCodeId())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.validFrom, that.getValidFrom())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.validTo, that.getValidTo())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.getLevel(true), that.getLevel(true))) {
                return false;
            }
            if (this.getLevelInHierarchy() != that.getLevelInHierarchy()) {
                return false;
            }
            return super.deepEqualsInternal(that);
        }
        return false;
    }

    @Override
    public List<HierarchicalCodeBean> getCodeRefs() {
        return new ArrayList<HierarchicalCodeBean>(this.codeRefs);
    }

    @Override
    public int getLevelInHierarchy() {
        return this.getFullIdPath(false).split("\\.").length;
    }

    @Override
    public LevelBean getLevel(boolean acceptDefault) {
        if (!ObjectUtil.validString(this.levelRef)) {
            if (!acceptDefault) {
                return null;
            }
            if (this.level != null) {
                HierarchyBean hb = this.getParent(HierarchyBean.class, false);
                this.level = hb.getLevelAtPosition(this.getLevelInHierarchy());
            }
        }
        return this.level;
    }

    @Override
    public CrossReferenceBean getCodeReference() {
        if (this.codeReference == null) {
            this.codeReference = this.generateCodelistReference();
        }
        return this.codeReference;
    }

    private CrossReferenceBean generateCodelistReference() {
        HierarchicalCodelistBean hcl = (HierarchicalCodelistBean)this.getMaintainableParent();
        if (hcl.getCodelistRef() != null) {
            for (CodelistRefBean currentCodelistRef : hcl.getCodelistRef()) {
                if (!currentCodelistRef.getAlias().equals(this.getCodelistAliasRef())) continue;
                MaintainableRefBean codelistRef = currentCodelistRef.getCodelistReference().getMaintainableReference();
                return new CrossReferenceBeanImpl(this, codelistRef.getAgencyId(), codelistRef.getMaintainableId(), codelistRef.getVersion(), SDMX_STRUCTURE_TYPE.CODE, this.codeId);
            }
        }
        return null;
    }

    @Override
    public String getCodelistAliasRef() {
        return this.codelistAliasRef;
    }

    @Override
    public String getCodeId() {
        return this.codeId;
    }

    @Override
    public SdmxDate getValidFrom() {
        return this.validFrom;
    }

    @Override
    public SdmxDate getValidTo() {
        return this.validTo;
    }
}

