/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.conceptscheme;

import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConceptType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.RepresentationBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.ItemBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.RepresentationBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class ConceptBeanImpl
extends ItemBeanImpl
implements ConceptBean {
    private static final long serialVersionUID = 1L;
    private String parentConcept;
    private String parentAgency;
    private CrossReferenceBean isoConceptReference;
    private RepresentationBean coreRepresentation;

    public ConceptBeanImpl(ConceptSchemeBean parent, ConceptMutableBean bean) {
        super(bean, (IdentifiableBean)parent);
        if (bean.getCoreRepresentation() != null) {
            this.coreRepresentation = new RepresentationBeanImpl(bean.getCoreRepresentation(), (IdentifiableBean)this);
        }
        if (bean.getIsoConceptReference() != null) {
            this.isoConceptReference = new CrossReferenceBeanImpl((SDMXBean)this, bean.getIsoConceptReference());
        }
        this.parentConcept = bean.getParentConcept();
        this.parentAgency = bean.getParentAgency();
    }

    public ConceptBeanImpl(ConceptSchemeBean parent, ConceptType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.CONCEPT, (IdentifiableBean)parent);
        if (bean.getCoreRepresentation() != null) {
            this.coreRepresentation = new RepresentationBeanImpl(bean.getCoreRepresentation(), (IdentifiableBean)this);
        }
        if (bean.getISOConceptReference() != null) {
            this.isoConceptReference = new CrossReferenceBeanImpl(this, bean.getISOConceptReference().getConceptAgency(), bean.getISOConceptReference().getConceptSchemeID(), null, SDMX_STRUCTURE_TYPE.CONCEPT, bean.getISOConceptReference().getConceptID());
        }
        if (bean.getParent() != null) {
            if (bean.getParent().getURN() != null) {
                StructureReferenceBeanImpl sRef = new StructureReferenceBeanImpl(bean.getParent().getURN());
                this.parentConcept = sRef.getChildReference().getId();
                this.parentAgency = sRef.getMaintainableReference().getAgencyId();
            } else {
                this.parentConcept = bean.getParent().getRef().getId();
                this.parentAgency = this.getMaintainableParent().getAgencyId();
            }
        }
    }

    public ConceptBeanImpl(ConceptSchemeBean parent, org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptType bean) {
        super((XmlObject)bean, SDMX_STRUCTURE_TYPE.CONCEPT, bean.getId(), bean.getUri(), bean.getNameList(), bean.getDescriptionList(), bean.getAnnotations(), (IdentifiableBean)parent);
        if (ObjectUtil.validString(bean.getCoreRepresentation())) {
            String representationAgency = bean.getCoreRepresentationAgency();
            if (representationAgency == null) {
                representationAgency = parent.getAgencyId();
            }
            this.coreRepresentation = new RepresentationBeanImpl(bean.getTextFormat(), representationAgency, bean.getCoreRepresentation(), "1.0", this);
        }
        this.parentConcept = bean.getParent();
        this.parentAgency = bean.getParentAgency();
    }

    public ConceptBeanImpl(ConceptSchemeBean parent, org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.ConceptType bean) {
        super((XmlObject)bean, SDMX_STRUCTURE_TYPE.CONCEPT, bean.getId(), bean.getUri(), bean.getNameList(), null, bean.getAnnotations(), (IdentifiableBean)parent);
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            ConceptBean that = (ConceptBean)bean;
            if (!ObjectUtil.equivalent(this.parentConcept, that.getParentConcept())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.parentAgency, that.getParentAgency())) {
                return false;
            }
            if (!super.equivalent(this.isoConceptReference, that.getIsoConceptReference())) {
                return false;
            }
            if (!super.equivalent(this.coreRepresentation, that.getCoreRepresentation())) {
                return false;
            }
            return super.deepEqualsInternal(that);
        }
        return false;
    }

    @Override
    protected void validateId(boolean startWithIntAllowed) {
        super.validateId(false);
    }

    @Override
    public boolean isStandAloneConcept() {
        return false;
    }

    @Override
    public RepresentationBean getCoreRepresentation() {
        return this.coreRepresentation;
    }

    @Override
    public String getParentConcept() {
        return this.parentConcept;
    }

    @Override
    public String getParentAgency() {
        return this.parentAgency;
    }

    @Override
    public CrossReferenceBean getIsoConceptReference() {
        return this.isoConceptReference;
    }
}

