/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v21.common.ConceptReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.LocalDimensionReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.AttributeRelationshipType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.AttributeType;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeListBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.AttributeMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.ComponentBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class AttributeBeanImpl
extends ComponentBeanImpl
implements AttributeBean {
    private static final long serialVersionUID = 1L;
    private ATTRIBUTE_ATTACHMENT_LEVEL attachmentLevel;
    private String assignmentStatus;
    private String attachmentGroup;
    private List<String> dimensionReference = new ArrayList<String>();
    private List<CrossReferenceBean> conceptRoles = new ArrayList<CrossReferenceBean>();
    private String primaryMeasureReference;

    public AttributeBeanImpl(AttributeMutableBean attribute, AttributeListBean parent) {
        super(attribute, parent);
        try {
            this.attachmentLevel = attribute.getAttachmentLevel();
            this.assignmentStatus = attribute.getAssignmentStatus();
            this.attachmentGroup = attribute.getAttachmentGroup();
            if (attribute.getDimensionReferences() != null) {
                this.dimensionReference = new ArrayList<String>(attribute.getDimensionReferences());
            }
            if (attribute.getConceptRoles() != null) {
                for (StructureReferenceBean currentConceptRole : attribute.getConceptRoles()) {
                    this.conceptRoles.add(new CrossReferenceBeanImpl((SDMXBean)this, currentConceptRole));
                }
            }
            this.primaryMeasureReference = attribute.getPrimaryMeasureReference();
            this.validateAttributeAttributes();
        }
        catch (Throwable th) {
            throw new ValidationException(th, "Error creating structure: " + this.toString());
        }
    }

    public AttributeBeanImpl(AttributeType attribute, AttributeListBean parent) {
        super(attribute, SDMX_STRUCTURE_TYPE.DATA_ATTRIBUTE, parent);
        if (attribute.getAttributeRelationship() != null) {
            AttributeRelationshipType attRelationShip = attribute.getAttributeRelationship();
            if (attRelationShip.getGroup() != null) {
                this.attachmentGroup = RefUtil.createLocalIdReference(attRelationShip.getGroup());
                this.attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.GROUP;
            } else if (ObjectUtil.validCollection(attRelationShip.getDimensionList())) {
                this.attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP;
                for (LocalDimensionReferenceType lDim : attRelationShip.getDimensionList()) {
                    this.dimensionReference.add(RefUtil.createLocalIdReference(lDim));
                }
                DataStructureBean parentDSD = (DataStructureBean)this.getMaintainableParent();
                for (DimensionBean currentDimension : parentDSD.getDimensions(new SDMX_STRUCTURE_TYPE[0])) {
                    if (!this.dimensionReference.contains(currentDimension.getId()) || !currentDimension.isTimeDimension()) continue;
                    this.attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION;
                    break;
                }
                if (ObjectUtil.validCollection(attRelationShip.getAttachmentGroupList())) {
                    this.attachmentGroup = RefUtil.createLocalIdReference(attRelationShip.getAttachmentGroupList().get(0));
                    this.attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.GROUP;
                }
            } else if (attRelationShip.getPrimaryMeasure() != null) {
                this.primaryMeasureReference = RefUtil.createLocalIdReference(attRelationShip.getPrimaryMeasure());
                this.attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION;
            } else {
                this.attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.DATA_SET;
            }
        }
        this.assignmentStatus = attribute.getAssignmentStatus().toString();
        if (attribute.getConceptRoleList() != null) {
            for (ConceptReferenceType conceptRef : attribute.getConceptRoleList()) {
                this.conceptRoles.add(RefUtil.createReference(this, conceptRef));
            }
        }
        try {
            this.validateAttributeAttributes();
        }
        catch (Throwable th) {
            throw new ValidationException(th, "Error creating structure: " + this.toString());
        }
    }

    public AttributeBeanImpl(org.sdmx.resources.sdmxml.schemas.v20.structure.AttributeType attribute, AttributeListBean parent) {
        super(attribute, SDMX_STRUCTURE_TYPE.DATA_ATTRIBUTE, attribute.getAnnotations(), attribute.getTextFormat(), attribute.getCodelistAgency(), attribute.getCodelist(), attribute.getCodelistVersion(), attribute.getConceptSchemeAgency(), attribute.getConceptSchemeRef(), attribute.getConceptVersion(), attribute.getConceptAgency(), attribute.getConceptRef(), parent);
        if (attribute.getAttachmentGroupList() != null) {
            if (attribute.getAttachmentGroupList().size() > 1) {
                throw new ValidationException(ExceptionCode.UNSUPPORTED, "Attribute with more then one group attachment");
            }
            if (attribute.getAttachmentGroupList().size() == 1) {
                this.attachmentGroup = attribute.getAttachmentGroupList().get(0);
            }
        }
        ATTRIBUTE_ATTACHMENT_LEVEL attachmentLevel = null;
        DataStructureBean parentDSD = (DataStructureBean)this.getMaintainableParent();
        switch (attribute.getAttachmentLevel().intValue()) {
            case 1: {
                attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.DATA_SET;
                break;
            }
            case 2: {
                attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.GROUP;
                break;
            }
            case 4: {
                attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION;
                this.primaryMeasureReference = parentDSD.getPrimaryMeasure().getId();
                break;
            }
            case 3: {
                attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP;
                for (DimensionBean currentDimension : parentDSD.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION)) {
                    if (this.dimensionReference.contains(currentDimension.getId())) continue;
                    this.dimensionReference.add(currentDimension.getId());
                }
                break;
            }
            default: {
                throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "Attachment:" + attribute.getAttachmentLevel().toString());
            }
        }
        this.attachmentLevel = attachmentLevel;
        this.assignmentStatus = attribute.getAssignmentStatus().toString();
        try {
            this.validateAttributeAttributes();
        }
        catch (Throwable th) {
            throw new ValidationException(th, "Error creating structure: " + this.toString());
        }
    }

    public AttributeBeanImpl(org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.AttributeType attribute, AttributeListBean parent) {
        super((XmlObject)attribute, SDMX_STRUCTURE_TYPE.DATA_ATTRIBUTE, attribute.getAnnotations(), attribute.getCodelist(), attribute.getConcept(), (SdmxStructureBean)parent);
        if (attribute.getAttachmentGroupList() != null) {
            if (attribute.getAttachmentGroupList().size() > 1) {
                throw new ValidationException(ExceptionCode.UNSUPPORTED, "Attribute with more then one group attachment");
            }
            if (attribute.getAttachmentGroupList().size() == 1) {
                this.attachmentGroup = attribute.getAttachmentGroupList().get(0);
            }
        }
        ATTRIBUTE_ATTACHMENT_LEVEL attachmentLevel = null;
        DataStructureBean parentDSD = (DataStructureBean)this.getMaintainableParent();
        switch (attribute.getAttachmentLevel().intValue()) {
            case 1: {
                attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.DATA_SET;
                break;
            }
            case 2: {
                attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.GROUP;
                break;
            }
            case 4: {
                attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION;
                this.primaryMeasureReference = parentDSD.getPrimaryMeasure().getId();
                break;
            }
            case 3: {
                attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP;
                for (DimensionBean currentDimension : parentDSD.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION)) {
                    if (this.dimensionReference.contains(currentDimension.getId())) continue;
                    this.dimensionReference.add(currentDimension.getId());
                }
                break;
            }
            default: {
                throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "Attachment:" + attribute.getAttachmentLevel().toString());
            }
        }
        this.attachmentLevel = attachmentLevel;
        this.assignmentStatus = attribute.getAssignmentStatus().toString();
        try {
            this.validateAttributeAttributes();
        }
        catch (Throwable th) {
            throw new ValidationException(th, "Error creating structure: " + this.toString());
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            AttributeBean that = (AttributeBean)bean;
            if (!ObjectUtil.equivalent((Object)this.attachmentLevel, (Object)that.getAttachmentLevel())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.assignmentStatus, that.getAssignmentStatus())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.attachmentGroup, that.getAttachmentGroup())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.dimensionReference, that.getDimensionReferences())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.conceptRoles, that.getConceptRoles())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.primaryMeasureReference, that.getPrimaryMeasureReference())) {
                return false;
            }
            return super.deepEqualsInternal(that);
        }
        return false;
    }

    protected void validateAttributeAttributes() throws ValidationException {
        if (this.attachmentLevel == null) {
            throw new ValidationException(ExceptionCode.BEAN_MISSING_REQUIRED_ATTRIBUTE, new Object[]{this.structureType, "attachmentLevel"});
        }
        if (this.attachmentLevel == ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION) {
            if (!ObjectUtil.validCollection(this.dimensionReference)) {
                this.primaryMeasureReference = "OBS_VALUE";
            } else {
                DataStructureBean parentDSD = (DataStructureBean)this.getMaintainableParent();
                DimensionBean timeDimension = parentDSD.getTimeDimension();
                if (timeDimension == null) {
                    this.attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP;
                } else {
                    String timeDimensionId = timeDimension.getId();
                    if (!this.dimensionReference.contains(timeDimensionId)) {
                        this.attachmentLevel = ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP;
                    }
                }
            }
        }
        if (this.assignmentStatus == null) {
            throw new ValidationException(ExceptionCode.BEAN_MISSING_REQUIRED_ATTRIBUTE, new Object[]{this.structureType, "assignmentStatus"});
        }
        if (!ObjectUtil.validString(this.attachmentGroup) && this.attachmentLevel == ATTRIBUTE_ATTACHMENT_LEVEL.GROUP) {
            throw new ValidationException("Attribute has specified attachment level specified as Group, but does not specifies the attachment groups. Either change the attachment level, or declare which group the attribute attaches to: " + this.getId());
        }
        if (ObjectUtil.validString(this.attachmentGroup) && this.attachmentLevel != ATTRIBUTE_ATTACHMENT_LEVEL.GROUP) {
            throw new ValidationException("Attribute specifies an attachment group of '" + this.attachmentGroup + "', but the the attachement level is not set to GROUP, it is set to  '" + (Object)((Object)this.attachmentLevel) + "'.  Either remove the attribute's reference to the '" + this.attachmentGroup + "' or change the attribute's attachment level to GROUP");
        }
        if (this.attachmentLevel == ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP && !ObjectUtil.validCollection(this.dimensionReference)) {
            throw new ValidationException("Attribute specifies attachment level of 'Dimension Group' but does not specify any dimensions");
        }
        for (CrossReferenceBean conceptRole : this.conceptRoles) {
            if (conceptRole.getTargetReference() == SDMX_STRUCTURE_TYPE.CONCEPT) continue;
            throw new ValidationException("Illegal concept role '" + conceptRole.getTargetUrn() + "'.  Concept Role must reference a concept.");
        }
    }

    @Override
    protected List<String> getParentIds(boolean includeDifferentTypes) {
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add(this.getId());
        return returnList;
    }

    @Override
    public String getAttachmentGroup() {
        return this.attachmentGroup;
    }

    @Override
    public List<CrossReferenceBean> getConceptRoles() {
        return new ArrayList<CrossReferenceBean>(this.conceptRoles);
    }

    @Override
    public boolean isTimeFormat() {
        return this.getId().equals("TIME_FORMAT");
    }

    @Override
    public ATTRIBUTE_ATTACHMENT_LEVEL getAttachmentLevel() {
        return this.attachmentLevel;
    }

    @Override
    public String getAssignmentStatus() {
        return this.assignmentStatus;
    }

    @Override
    public List<String> getDimensionReferences() {
        return this.dimensionReference;
    }

    @Override
    public String getPrimaryMeasureReference() {
        return this.primaryMeasureReference;
    }

    @Override
    public boolean isMandatory() {
        return this.assignmentStatus.equals("Mandatory");
    }
}

