/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.process;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessStepType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ComputationType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.process.ComputationBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.process.ComputationMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.AnnotableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.TextTypeUtil;
import org.sdmxsource.util.ObjectUtil;

public class ComputationBeanImpl
extends AnnotableBeanImpl
implements ComputationBean {
    private static final long serialVersionUID = 2467028947066566585L;
    private String localId;
    private String softwarePackage;
    private String softwareLanguage;
    private String softwareVersion;
    private List<TextTypeWrapper> description = new ArrayList<TextTypeWrapper>();

    public ComputationBeanImpl(IdentifiableBean parent, ComputationMutableBean mutableBean) {
        super(mutableBean, (SdmxStructureBean)parent);
        this.localId = mutableBean.getLocalId();
        this.softwareLanguage = mutableBean.getSoftwareLanguage();
        this.softwarePackage = mutableBean.getSoftwarePackage();
        this.softwareVersion = mutableBean.getSoftwareVersion();
        if (mutableBean.getDescription() != null) {
            for (TextTypeWrapperMutableBean currentTT : mutableBean.getDescription()) {
                if (!ObjectUtil.validString(currentTT.getValue())) continue;
                this.description.add(new TextTypeWrapperImpl(currentTT, (SDMXBean)this));
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, "Computation");
        }
    }

    public ComputationBeanImpl(IdentifiableBean parent, ComputationType xmlType) {
        super(xmlType, SDMX_STRUCTURE_TYPE.COMPUTATION, parent);
        this.localId = xmlType.getLocalID();
        this.softwareLanguage = xmlType.getSoftwareLanguage();
        this.softwarePackage = xmlType.getSoftwarePackage();
        this.softwareVersion = xmlType.getSoftwareVersion();
        if (xmlType.getDescriptionList() != null) {
            this.description = TextTypeUtil.wrapTextTypeV21(xmlType.getDescriptionList(), this);
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, "Computation");
        }
    }

    public ComputationBeanImpl(IdentifiableBean parent, ProcessStepType processBean) {
        super(null, SDMX_STRUCTURE_TYPE.COMPUTATION, parent);
        if (processBean.getComputationList() != null) {
            this.description = TextTypeUtil.wrapTextTypeV2(processBean.getComputationList(), this);
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, "Computation");
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            ComputationBean that = (ComputationBean)bean;
            if (!super.equivalent(this.description, that.getDescription())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.localId, that.getLocalId())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.softwarePackage, that.getSoftwarePackage())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.softwareLanguage, that.getSoftwareLanguage())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.softwareVersion, that.getSoftwareVersion())) {
                return false;
            }
            return super.deepEqualsInternal(that);
        }
        return false;
    }

    @Override
    public String getLocalId() {
        return this.localId;
    }

    @Override
    public String getSoftwarePackage() {
        return this.softwarePackage;
    }

    @Override
    public String getSoftwareLanguage() {
        return this.softwareLanguage;
    }

    @Override
    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    @Override
    public List<TextTypeWrapper> getDescription() {
        return new ArrayList<TextTypeWrapper>(this.description);
    }

    private void validate() {
        if (this.description == null) {
            throw new ValidationException("Computation missing mandatory field 'description'");
        }
    }
}

