/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.process;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessStepType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.InputOutputType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.TransitionType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.NameableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.process.ComputationBean;
import org.sdmxsource.sdmx.api.model.beans.process.InputOutputBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessStepBean;
import org.sdmxsource.sdmx.api.model.beans.process.TransitionBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TransitionMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.process.InputOutputMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.process.ProcessStepMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.NameableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.process.ComputationBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.process.InputOutputBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.process.TransitionBeanImpl;

public class ProcessStepBeanImpl
extends NameableBeanImpl
implements ProcessStepBean {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(ProcessStepBeanImpl.class);
    private List<InputOutputBean> input = new ArrayList<InputOutputBean>();
    private List<InputOutputBean> output = new ArrayList<InputOutputBean>();
    private List<TransitionBean> transitions = new ArrayList<TransitionBean>();
    private List<ProcessStepBean> processSteps = new ArrayList<ProcessStepBean>();
    private ComputationBean computation;

    public ProcessStepBeanImpl(IdentifiableBean parent, ProcessStepMutableBean processBean) {
        super(processBean, parent);
        if (processBean.getInput() != null) {
            for (InputOutputMutableBean inputOutputMutableBean : processBean.getInput()) {
                this.input.add(new InputOutputBeanImpl((IdentifiableBean)this, inputOutputMutableBean));
            }
        }
        if (processBean.getOutput() != null) {
            for (InputOutputMutableBean inputOutputMutableBean : processBean.getOutput()) {
                this.output.add(new InputOutputBeanImpl((IdentifiableBean)this, inputOutputMutableBean));
            }
        }
        if (processBean.getComputation() != null) {
            this.computation = new ComputationBeanImpl((IdentifiableBean)this, processBean.getComputation());
        }
        if (processBean.getTransitions() != null) {
            for (TransitionMutableBean transitionMutableBean : processBean.getTransitions()) {
                this.transitions.add(new TransitionBeanImpl(transitionMutableBean, (SdmxStructureBean)this));
            }
        }
        if (processBean.getProcessSteps() != null) {
            for (ProcessStepMutableBean processStepMutableBean : processBean.getProcessSteps()) {
                this.processSteps.add(new ProcessStepBeanImpl((IdentifiableBean)this, processStepMutableBean));
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.toString());
        }
    }

    public ProcessStepBeanImpl(NameableBean parent, org.sdmx.resources.sdmxml.schemas.v21.structure.ProcessStepType processBean) {
        super(processBean, SDMX_STRUCTURE_TYPE.PROCESS_STEP, parent);
        if (processBean.getInputList() != null) {
            for (InputOutputType currentIo : processBean.getInputList()) {
                this.input.add(new InputOutputBeanImpl((IdentifiableBean)this, currentIo));
            }
        }
        if (processBean.getOutputList() != null) {
            for (InputOutputType currentIo : processBean.getOutputList()) {
                this.output.add(new InputOutputBeanImpl((IdentifiableBean)this, currentIo));
            }
        }
        if (processBean.getComputation() != null) {
            this.computation = new ComputationBeanImpl((IdentifiableBean)this, processBean.getComputation());
        }
        if (processBean.getProcessStepList() != null) {
            for (org.sdmx.resources.sdmxml.schemas.v21.structure.ProcessStepType processStep : processBean.getProcessStepList()) {
                this.processSteps.add(new ProcessStepBeanImpl((NameableBean)this, processStep));
            }
        }
        if (processBean.getTransitionList() != null) {
            for (TransitionType trans : processBean.getTransitionList()) {
                TransitionBeanImpl tRef = new TransitionBeanImpl(trans, (SdmxStructureBean)this);
                this.transitions.add(tRef);
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.toString());
        }
    }

    public ProcessStepBeanImpl(NameableBean parent, ProcessStepType processBean) {
        super((XmlObject)processBean, SDMX_STRUCTURE_TYPE.PROCESS_STEP, processBean.getId(), "", processBean.getNameList(), processBean.getDescriptionList(), processBean.getAnnotations(), (IdentifiableBean)parent);
        if (processBean.getInputList() != null) {
            LOG.warn((Object)"Input items not supported for SDMX V2.0. These items will be discarded");
        }
        if (processBean.getOutputList() != null) {
            LOG.warn((Object)"Input items not supported for SDMX V2.0. These items will be discarded");
        }
        if (processBean.getComputationList() != null) {
            this.computation = new ComputationBeanImpl((IdentifiableBean)this, processBean);
        }
        if (processBean.getProcessStepList() != null) {
            for (ProcessStepType processStep : processBean.getProcessStepList()) {
                this.processSteps.add(new ProcessStepBeanImpl((NameableBean)this, processStep));
            }
        }
        if (processBean.getTransitionList() != null) {
            for (org.sdmx.resources.sdmxml.schemas.v20.structure.TransitionType trans : processBean.getTransitionList()) {
                TransitionBeanImpl tRef = new TransitionBeanImpl(trans, (SdmxStructureBean)this);
                this.transitions.add(tRef);
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.toString());
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            ProcessStepBean that = (ProcessStepBean)bean;
            if (!super.equivalent(this.input, that.getInput())) {
                return false;
            }
            if (!super.equivalent(this.output, that.getOutput())) {
                return false;
            }
            if (!super.equivalent(this.transitions, that.getTransitions())) {
                return false;
            }
            if (!super.equivalent(this.processSteps, that.getProcessSteps())) {
                return false;
            }
            if (!super.equivalent(this.computation, that.getComputation())) {
                return false;
            }
            return super.deepEqualsInternal(that);
        }
        return false;
    }

    private void validate() throws ValidationException {
    }

    @Override
    public ComputationBean getComputation() {
        return this.computation;
    }

    @Override
    public List<TextTypeWrapper> getAllTextTypes() {
        List<TextTypeWrapper> allTextTypes = super.getAllTextTypes();
        if (this.computation != null) {
            allTextTypes.addAll(this.computation.getDescription());
        }
        return allTextTypes;
    }

    @Override
    public List<InputOutputBean> getInput() {
        return new ArrayList<InputOutputBean>(this.input);
    }

    @Override
    public List<InputOutputBean> getOutput() {
        return new ArrayList<InputOutputBean>(this.output);
    }

    @Override
    public List<TransitionBean> getTransitions() {
        return new ArrayList<TransitionBean>(this.transitions);
    }

    @Override
    public List<ProcessStepBean> getProcessSteps() {
        return new ArrayList<ProcessStepBean>(this.processSteps);
    }
}

