/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import java.net.URL;
import org.sdmx.resources.sdmxml.schemas.v21.common.DistinctKeyType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConstraintType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataKeySetType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstraintAttachmentBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstraintDataKeySetBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.ConstraintMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.MaintainableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.ConstraintAttachmentBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.ConstraintDataKeySetBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public abstract class ConstraintBeanImpl
extends MaintainableBeanImpl
implements ConstraintBean {
    private static final long serialVersionUID = 1L;
    private ConstraintDataKeySetBean includedSeriesKeys;
    private ConstraintDataKeySetBean excludedSeriesKeys;
    private ConstraintAttachmentBean constraintAttachment;

    public ConstraintBeanImpl(MaintainableBean bean, URL actualLocation, boolean isServiceUrl) {
        super(bean, actualLocation, isServiceUrl);
    }

    public ConstraintBeanImpl(ConstraintMutableBean bean) {
        super(bean);
        if (bean.getIncludedSeriesKeys() != null && bean.getIncludedSeriesKeys().getConstrainedDataKeys() != null && bean.getIncludedSeriesKeys().getConstrainedDataKeys().size() > 0) {
            this.includedSeriesKeys = new ConstraintDataKeySetBeanImpl(bean.getIncludedSeriesKeys(), (ConstraintBean)this);
        }
        if (bean.getExcludedSeriesKeys() != null && bean.getExcludedSeriesKeys().getConstrainedDataKeys() != null && bean.getExcludedSeriesKeys().getConstrainedDataKeys().size() > 0) {
            this.excludedSeriesKeys = new ConstraintDataKeySetBeanImpl(bean.getExcludedSeriesKeys(), (ConstraintBean)this);
        }
        if (bean.getConstraintAttachment() != null) {
            this.constraintAttachment = new ConstraintAttachmentBeanImpl(bean.getConstraintAttachment(), (ConstraintBean)this);
        }
        this.validate();
    }

    public ConstraintBeanImpl(ConstraintType createdFrom, SDMX_STRUCTURE_TYPE structureType) {
        super(createdFrom, structureType);
        if (ObjectUtil.validCollection(createdFrom.getDataKeySetList())) {
            DataKeySetType includedKeySet = DataKeySetType.Factory.newInstance();
            DataKeySetType excludedKeySet = DataKeySetType.Factory.newInstance();
            for (DataKeySetType currentDataKeySet : createdFrom.getDataKeySetList()) {
                if (currentDataKeySet.getIsIncluded()) {
                    for (DistinctKeyType currentKey : currentDataKeySet.getKeyList()) {
                        if (currentKey.isSetInclude() && !currentKey.getInclude()) {
                            excludedKeySet.getKeyList().add(currentKey);
                            continue;
                        }
                        includedKeySet.getKeyList().add(currentKey);
                    }
                    continue;
                }
                for (DistinctKeyType currentKey : currentDataKeySet.getKeyList()) {
                    if (currentKey.isSetInclude() && !currentKey.getInclude()) {
                        excludedKeySet.getKeyList().add(currentKey);
                        continue;
                    }
                    includedKeySet.getKeyList().add(currentKey);
                }
            }
            if (includedKeySet.getKeyList().size() > 0) {
                this.includedSeriesKeys = new ConstraintDataKeySetBeanImpl(includedKeySet, (ConstraintBean)this);
            }
            if (excludedKeySet.getKeyList().size() > 0) {
                this.excludedSeriesKeys = new ConstraintDataKeySetBeanImpl(excludedKeySet, (ConstraintBean)this);
            }
        }
        if (ObjectUtil.validCollection(createdFrom.getMetadataKeySetList())) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "AttachmentConstraint - MetadataKeySet");
        }
        if (createdFrom.getConstraintAttachment() != null) {
            this.constraintAttachment = new ConstraintAttachmentBeanImpl(createdFrom.getConstraintAttachment(), (ConstraintBean)this);
        }
        this.validate();
    }

    protected boolean deepEqualsInternal(ConstraintBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            ConstraintBean that = bean;
            if (!super.equivalent(this.includedSeriesKeys, that.getIncludedSeriesKeys())) {
                return false;
            }
            if (!super.equivalent(this.excludedSeriesKeys, that.getExcludedSeriesKeys())) {
                return false;
            }
            if (!super.equivalent(this.constraintAttachment, that.getConstraintAttachment())) {
                return false;
            }
            return this.deepEqualsInternal(that);
        }
        return false;
    }

    private void validate() {
        if (this.includedSeriesKeys != null && !ObjectUtil.validCollection(this.includedSeriesKeys.getConstrainedDataKeys())) {
            this.includedSeriesKeys = null;
        }
        if (this.excludedSeriesKeys != null && !ObjectUtil.validCollection(this.excludedSeriesKeys.getConstrainedDataKeys())) {
            this.excludedSeriesKeys = null;
        }
    }

    @Override
    public ConstraintAttachmentBean getConstraintAttachment() {
        return this.constraintAttachment;
    }

    @Override
    public ConstraintDataKeySetBean getIncludedSeriesKeys() {
        return this.includedSeriesKeys;
    }

    @Override
    public ConstraintDataKeySetBean getExcludedSeriesKeys() {
        return this.excludedSeriesKeys;
    }
}

