/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.data.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.DATA_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.data.query.DataQuery;
import org.sdmxsource.sdmx.api.model.data.query.DataQuerySelection;
import org.sdmxsource.sdmx.api.model.data.query.DataQuerySelectionGroup;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.DataQuerySelectionGroupImpl;
import org.sdmxsource.util.ObjectUtil;

public class DataQueryImpl
implements DataQuery {
    private static final long serialVersionUID = 1L;
    private DataStructureBean dataStructureBean;
    private Set<DataProviderBean> dataProviders = new HashSet<DataProviderBean>();
    private List<DataQuerySelectionGroup> dataQuerySelectionGroups = new ArrayList<DataQuerySelectionGroup>();
    private DataflowBean dataflowBean;
    private SdmxDate lastUpdated;
    private DATA_QUERY_DETAIL dataQueryDetail = DATA_QUERY_DETAIL.FULL;
    private Integer maxObs;
    private boolean orderAsc;
    private String dimensionAtObservation = "OBS_VALUE";

    private DataQueryImpl() {
    }

    public static DataQuery buildEmptyQuery(DataStructureBean dataStructureBean, DataflowBean dataflowBean, DATA_QUERY_DETAIL dataQueryDetail) {
        DataQueryImpl dataQuery = new DataQueryImpl();
        dataQuery.dataStructureBean = dataStructureBean;
        dataQuery.dataQueryDetail = dataQueryDetail;
        dataQuery.dataflowBean = dataflowBean;
        dataQuery.dataQueryDetail = dataQueryDetail;
        return dataQuery;
    }

    public DataQueryImpl(DataStructureBean dataStructureBean, SdmxDate lastUpdated, DATA_QUERY_DETAIL dataQueryDetail, Integer maxObs, boolean orderAsc, Set<DataProviderBean> dataProviders, DataflowBean dataflowBean, String dimensionAtObservation, Set<DataQuerySelection> selections, Date dateFrom, Date dateTo) {
        this.dataStructureBean = dataStructureBean;
        this.lastUpdated = lastUpdated;
        if (dataQueryDetail != null) {
            this.dataQueryDetail = dataQueryDetail;
        }
        this.maxObs = maxObs;
        this.orderAsc = orderAsc;
        if (dataProviders != null) {
            this.dataProviders = new HashSet<DataProviderBean>(dataProviders);
        }
        this.dataflowBean = dataflowBean;
        if (dimensionAtObservation != null) {
            this.dimensionAtObservation = dimensionAtObservation;
        }
        if (ObjectUtil.validCollection(selections) || dateFrom != null || dateTo != null) {
            SdmxDateImpl sdmxDateFrom = null;
            if (dateFrom != null) {
                sdmxDateFrom = new SdmxDateImpl(dateFrom, TIME_FORMAT.DATE);
            }
            SdmxDateImpl sdmxDateTo = null;
            if (dateFrom != null) {
                sdmxDateTo = new SdmxDateImpl(dateTo, TIME_FORMAT.DATE);
            }
            this.dataQuerySelectionGroups.add(new DataQuerySelectionGroupImpl(selections, sdmxDateFrom, sdmxDateTo));
        }
    }

    public DataQueryImpl(DataStructureBean dataStructureBean, SdmxDate lastUpdated, DATA_QUERY_DETAIL dataQueryDetail, Integer maxObs, boolean orderAsc, Set<DataProviderBean> dataProviders, DataflowBean dataflowBean, String dimensionAtObservation, Collection<DataQuerySelectionGroup> selectionGroup) {
        this.dataStructureBean = dataStructureBean;
        this.lastUpdated = lastUpdated;
        if (dataQueryDetail != null) {
            this.dataQueryDetail = dataQueryDetail;
        }
        this.maxObs = maxObs;
        this.orderAsc = orderAsc;
        if (dataProviders != null) {
            this.dataProviders = new HashSet<DataProviderBean>(dataProviders);
        }
        this.dataflowBean = dataflowBean;
        if (dimensionAtObservation != null) {
            this.dimensionAtObservation = dimensionAtObservation;
        }
        if (selectionGroup != null) {
            for (DataQuerySelectionGroup dqsg : selectionGroup) {
                if (dqsg == null) continue;
                this.dataQuerySelectionGroups.add(dqsg);
            }
        }
    }

    public DataQueryImpl(DataStructureBean dataStructureBean, SdmxDate lastUpdated, DATA_QUERY_DETAIL dataQueryDetail, Integer maxObs, boolean orderAsc, Set<DataProviderBean> dataProviders, DataflowBean dataflowBean, String dimensionAtObservation, DataQuerySelectionGroup ... selectionGroup) {
        this.dataStructureBean = dataStructureBean;
        this.lastUpdated = lastUpdated;
        if (dataQueryDetail != null) {
            this.dataQueryDetail = dataQueryDetail;
        }
        this.maxObs = maxObs;
        this.orderAsc = orderAsc;
        if (dataProviders != null) {
            this.dataProviders = new HashSet<DataProviderBean>(dataProviders);
        }
        this.dataflowBean = dataflowBean;
        if (dimensionAtObservation != null) {
            this.dimensionAtObservation = dimensionAtObservation;
        }
        if (selectionGroup != null) {
            for (DataQuerySelectionGroup dqsg : selectionGroup) {
                if (dqsg == null) continue;
                this.dataQuerySelectionGroups.add(dqsg);
            }
        }
    }

    @Override
    public String dimensionAtObservation() {
        return this.dimensionAtObservation;
    }

    @Override
    public DataflowBean getDataflow() {
        return this.dataflowBean;
    }

    @Override
    public Set<DataProviderBean> getDataProvider() {
        return new HashSet<DataProviderBean>(this.dataProviders);
    }

    @Override
    public boolean hasSelections() {
        return this.dataQuerySelectionGroups.size() > 0;
    }

    @Override
    public List<DataQuerySelectionGroup> getSelectionGroups() {
        return new ArrayList<DataQuerySelectionGroup>(this.dataQuerySelectionGroups);
    }

    @Override
    public DataStructureBean getDataStructure() {
        return this.dataStructureBean;
    }

    @Override
    public DATA_QUERY_DETAIL getDataQueryDetail() {
        return this.dataQueryDetail;
    }

    @Override
    public SdmxDate getLastUpdatedDate() {
        return this.lastUpdated;
    }

    @Override
    public Integer getMaxNumberObs() {
        return this.maxObs;
    }

    @Override
    public boolean isOrderAsc() {
        return this.orderAsc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataQueryImpl");
        if (this.dataStructureBean != null) {
            sb.append("\nKey Family  : " + this.dataStructureBean.getUrn());
        }
        if (this.dataflowBean != null) {
            sb.append("\nDataflow : " + this.dataflowBean.getUrn());
        }
        if (this.hasSelections()) {
            String concat = "";
            for (DataQuerySelectionGroup selectionGroup : this.dataQuerySelectionGroups) {
                sb.append(concat + "(" + selectionGroup.toString() + ")");
                concat = "OR";
            }
        }
        return sb.toString();
    }
}

